/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasm.ast;

import com.oracle.svm.aotjs.wasm.types.c;
import com.oracle.svm.aotjs.wasm.types.e;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;

public final class n {
    public final c wK;
    PrimitiveConstant wL;

    private n(PrimitiveConstant primitiveConstant) {
        JavaKind javaKind = primitiveConstant.getJavaKind();
        assert (javaKind.isNumericInteger() || javaKind.isNumericFloat()) : primitiveConstant;
        this.wK = e.e(javaKind);
        this.wL = primitiveConstant;
    }

    public static n a(c c2) {
        JavaKind javaKind = switch (c2) {
            default -> throw new MatchException(null, null);
            case c.dV -> JavaKind.Int;
            case c.dW -> JavaKind.Long;
            case c.dX -> JavaKind.Float;
            case c.dY -> JavaKind.Double;
        };
        return n.e((PrimitiveConstant)JavaConstant.defaultForKind((JavaKind)javaKind));
    }

    public static n e(PrimitiveConstant primitiveConstant) {
        return new n(primitiveConstant);
    }

    public static n u(int n2) {
        return new n(JavaConstant.forInt((int)n2));
    }

    public static n h(long l2) {
        return new n(JavaConstant.forLong((long)l2));
    }

    public static n d(float f2) {
        return new n(JavaConstant.forFloat((float)f2));
    }

    public static n e(double d2) {
        return new n(JavaConstant.forDouble((double)d2));
    }

    public int eW() {
        assert (this.wK == c.dV) : this.wK;
        return this.wL.asInt();
    }

    public long eX() {
        assert (this.wK == c.dW) : this.wK;
        return this.wL.asLong();
    }

    public float eY() {
        assert (this.wK == c.dX) : this.wK;
        return this.wL.asFloat();
    }

    public double eZ() {
        assert (this.wK == c.dY) : this.wK;
        return this.wL.asDouble();
    }

    public String fa() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.wK) {
            case dV: {
                stringBuilder.append("0x").append(Integer.toHexString(this.eW()));
                break;
            }
            case dW: {
                stringBuilder.append("0x").append(Long.toHexString(this.eX()));
                break;
            }
            case dX: {
                float f2 = this.eY();
                if (Float.isNaN(f2)) {
                    stringBuilder.append("nan");
                    break;
                }
                if (f2 == Float.NEGATIVE_INFINITY) {
                    stringBuilder.append("-inf");
                    break;
                }
                if (f2 == Float.POSITIVE_INFINITY) {
                    stringBuilder.append("+inf");
                    break;
                }
                stringBuilder.append(f2);
                break;
            }
            case dY: {
                double d2 = this.eZ();
                if (Double.isNaN(d2)) {
                    stringBuilder.append("nan");
                    break;
                }
                if (d2 == Double.NEGATIVE_INFINITY) {
                    stringBuilder.append("-inf");
                    break;
                }
                if (d2 == Double.POSITIVE_INFINITY) {
                    stringBuilder.append("+inf");
                    break;
                }
                stringBuilder.append(d2);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)this.wK.name());
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "Literal{" + String.valueOf(this.wK) + ", " + this.fa() + "}";
    }
}

