/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.phases;

import com.oracle.svm.core.util.VMError;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.JavaKind;

public class a
extends BasePhase<CoreProviders> {
    protected void a(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        for (CommitAllocationNode commitAllocationNode : structuredGraph.getNodes().filter(CommitAllocationNode.class)) {
            this.a(commitAllocationNode, coreProviders);
        }
    }

    protected void a(CommitAllocationNode commitAllocationNode, CoreProviders coreProviders) {
        AbstractNewObjectNode[] abstractNewObjectNodeArray = this.a(commitAllocationNode);
        this.a(commitAllocationNode, abstractNewObjectNodeArray, coreProviders);
        FixedValueAnchorNode[] fixedValueAnchorNodeArray = this.a((FixedWithNextNode)commitAllocationNode, abstractNewObjectNodeArray);
        this.a(commitAllocationNode, fixedValueAnchorNodeArray);
        commitAllocationNode.graph().removeFixed((FixedWithNextNode)commitAllocationNode);
    }

    protected AbstractNewObjectNode[] a(CommitAllocationNode commitAllocationNode) {
        StructuredGraph structuredGraph = commitAllocationNode.graph();
        List list = commitAllocationNode.getVirtualObjects();
        int n2 = list.size();
        AbstractNewObjectNode[] abstractNewObjectNodeArray = new AbstractNewObjectNode[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            VirtualObjectNode virtualObjectNode = (VirtualObjectNode)list.get(i2);
            try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)virtualObjectNode);){
                VirtualObjectNode virtualObjectNode2;
                Objects.requireNonNull(virtualObjectNode);
                int n3 = 0;
                AbstractNewObjectNode abstractNewObjectNode = (AbstractNewObjectNode)structuredGraph.addOrUniqueWithInputs((Node)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VirtualInstanceNode.class, VirtualArrayNode.class}, (Object)virtualObjectNode2, n3)) {
                    case 0 -> {
                        VirtualInstanceNode var12_14 = (VirtualInstanceNode)virtualObjectNode2;
                        yield new NewInstanceNode(virtualObjectNode.type(), true);
                    }
                    case 1 -> {
                        VirtualArrayNode var13_15 = (VirtualArrayNode)virtualObjectNode2;
                        yield new NewArrayNode(var13_15.componentType(), (ValueNode)ConstantNode.forInt((int)virtualObjectNode.entryCount()), true);
                    }
                    default -> throw VMError.shouldNotReachHere((String)("Unexpected VirtualNode: " + String.valueOf(virtualObjectNode)));
                }));
                structuredGraph.addBeforeFixed((FixedNode)commitAllocationNode, (FixedWithNextNode)abstractNewObjectNode);
                abstractNewObjectNodeArray[i2] = abstractNewObjectNode;
                continue;
            }
        }
        return abstractNewObjectNodeArray;
    }

    protected void a(CommitAllocationNode commitAllocationNode, AbstractNewObjectNode[] abstractNewObjectNodeArray, CoreProviders coreProviders) {
        int n2;
        StructuredGraph structuredGraph = commitAllocationNode.graph();
        FrameState frameState = GraphUtil.findLastFrameState((FixedNode)commitAllocationNode).duplicate();
        List list = commitAllocationNode.getVirtualObjects();
        int n3 = list.size();
        int[] nArray = new int[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = n4;
            n4 += ((VirtualObjectNode)list.get(n2)).entryCount();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            VirtualObjectNode virtualObjectNode = (VirtualObjectNode)list.get(n2);
            try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)virtualObjectNode);){
                AbstractNewObjectNode abstractNewObjectNode = abstractNewObjectNodeArray[n2];
                int n5 = nArray[n2];
                for (int i2 = 0; i2 < virtualObjectNode.entryCount(); ++i2) {
                    VirtualObjectNode virtualObjectNode2;
                    ValueNode valueNode = (ValueNode)commitAllocationNode.getValues().get(n5 + i2);
                    if (valueNode instanceof VirtualObjectNode) {
                        assert (list.contains(valueNode)) : "Virtual object " + String.valueOf(valueNode) + " does not belong to " + String.valueOf(commitAllocationNode);
                        valueNode = abstractNewObjectNodeArray[list.indexOf(valueNode)];
                    }
                    if (valueNode.isDefaultConstant()) continue;
                    JavaKind javaKind = virtualObjectNode.entryKind(coreProviders.getMetaAccessExtensionProvider(), i2);
                    Objects.requireNonNull(virtualObjectNode);
                    int n6 = 0;
                    FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)structuredGraph.addOrUniqueWithInputs((Node)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VirtualInstanceNode.class, VirtualArrayNode.class}, (Object)virtualObjectNode2, n6)) {
                        case 0 -> {
                            VirtualInstanceNode var20_23 = (VirtualInstanceNode)virtualObjectNode2;
                            yield new StoreFieldNode((ValueNode)abstractNewObjectNode, var20_23.field(i2), valueNode);
                        }
                        case 1 -> {
                            VirtualArrayNode var21_24 = (VirtualArrayNode)virtualObjectNode2;
                            yield new StoreIndexedNode((ValueNode)abstractNewObjectNode, (ValueNode)ConstantNode.forInt((int)i2), null, null, javaKind, valueNode);
                        }
                        default -> throw VMError.shouldNotReachHere((String)("Unexpected VirtualNode: " + String.valueOf(virtualObjectNode)));
                    }));
                    ((StateSplit)fixedWithNextNode).setStateAfter(frameState);
                    structuredGraph.addBeforeFixed((FixedNode)commitAllocationNode, fixedWithNextNode);
                }
                continue;
            }
        }
    }

    protected FixedValueAnchorNode[] a(FixedWithNextNode fixedWithNextNode, AbstractNewObjectNode[] abstractNewObjectNodeArray) {
        StructuredGraph structuredGraph = fixedWithNextNode.graph();
        FixedWithNextNode fixedWithNextNode2 = fixedWithNextNode;
        FixedValueAnchorNode[] fixedValueAnchorNodeArray = new FixedValueAnchorNode[abstractNewObjectNodeArray.length];
        for (int i2 = 0; i2 < abstractNewObjectNodeArray.length; ++i2) {
            FixedValueAnchorNode fixedValueAnchorNode;
            AbstractNewObjectNode abstractNewObjectNode = abstractNewObjectNodeArray[i2];
            fixedValueAnchorNodeArray[i2] = fixedValueAnchorNode = (FixedValueAnchorNode)structuredGraph.add((Node)new FixedValueAnchorNode((ValueNode)abstractNewObjectNode));
            structuredGraph.addAfterFixed(fixedWithNextNode2, (FixedNode)fixedValueAnchorNode);
            fixedWithNextNode2 = fixedValueAnchorNode;
        }
        return fixedValueAnchorNodeArray;
    }

    protected void a(CommitAllocationNode commitAllocationNode, FixedValueAnchorNode[] fixedValueAnchorNodeArray) {
        List list = commitAllocationNode.getVirtualObjects();
        for (Node node : commitAllocationNode.usages().snapshot()) {
            if (node instanceof AllocatedObjectNode) {
                AllocatedObjectNode allocatedObjectNode = (AllocatedObjectNode)node;
                int n2 = list.indexOf(allocatedObjectNode.getVirtualObject());
                allocatedObjectNode.replaceAtUsagesAndDelete((Node)fixedValueAnchorNodeArray[n2]);
                continue;
            }
            throw VMError.shouldNotReachHere((String)("Found CommitAllocationNode with unexpected usage: " + String.valueOf(node)));
        }
        assert (commitAllocationNode.hasNoUsages()) : commitAllocationNode.usages().snapshot();
    }

    protected /* synthetic */ void run(StructuredGraph structuredGraph, Object object) {
        this.a(structuredGraph, (CoreProviders)object);
    }
}

