/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.codegen;

import com.oracle.svm.hosted.aotjs.js.a;
import java.util.Collection;
import java.util.HashSet;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.variables.VariableAllocation;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.java.AbstractNewArrayNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;

public class ac
extends VariableAllocation {
    private static final long jv = -10L;
    private static final long jw = 100L;

    public Collection<VariableAllocation.SafetyPolicy> getSafeInliningPolicies(ValueNode node, CodeGenTool codeGenTool) {
        HashSet<VariableAllocation.SafetyPolicy> hashSet = new HashSet<VariableAllocation.SafetyPolicy>();
        if (node.inputs().filter(PhiNode.class).isNotEmpty()) {
            hashSet.add(VariableAllocation.SafetyPolicy.InBlockNoMerge);
        }
        if (node instanceof StateSplit) {
            hashSet.add(VariableAllocation.SafetyPolicy.SingleUsage);
        }
        if (node instanceof AbstractNewArrayNode) {
            hashSet.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof BoxNode) {
            hashSet.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof a) {
            hashSet.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof PhiNode) {
            hashSet.add(VariableAllocation.SafetyPolicy.Never);
        } else if (node instanceof FloatingNode) {
            hashSet.add(VariableAllocation.SafetyPolicy.Always);
        } else if (node instanceof FixedWithNextNode) {
            hashSet.add(VariableAllocation.SafetyPolicy.SingleUsageAtNext);
        } else if (node instanceof FixedNode) {
            hashSet.add(VariableAllocation.SafetyPolicy.Never);
        } else {
            hashSet.add(VariableAllocation.SafetyPolicy.SingleUsage);
        }
        return hashSet;
    }

    protected boolean shouldInline(ValueNode node, int numUsages, CodeGenTool codeGenTool) {
        if (node instanceof ParameterNode) {
            return true;
        }
        if (node instanceof ValueProxyNode) {
            return true;
        }
        if (node instanceof PiNode) {
            return true;
        }
        if (node instanceof ConstantNode) {
            Constant constant = ((ConstantNode)node).getValue();
            if (constant.isDefaultForKind()) {
                return true;
            }
            if (constant instanceof PrimitiveConstant) {
                long l2;
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
                JavaKind javaKind = primitiveConstant.getJavaKind();
                if (javaKind == JavaKind.Boolean) {
                    return true;
                }
                if (javaKind.isNumericInteger() && -10L < (l2 = primitiveConstant.asLong()) && l2 < 100L) {
                    return true;
                }
            }
        }
        return numUsages == 1;
    }
}

