/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.aotjs.substitute.system;

import com.oracle.svm.aotjs.substitute.system.Target_java_io_FileSystem_Web;
import com.oracle.svm.aotjs.substitute.system.Target_java_io_File_Web;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import jdk.internal.util.StaticProperty;

@BasedOnJDKClass(className="java.io.UnixFileSystem")
public final class e {
    private static final int dA = 255;
    private static final String dB = "/";
    protected static final char dC = '/';
    protected static final char dD = ':';
    private static final String dE = StaticProperty.userDir();

    private e() {
    }

    public static char getSeparator() {
        return '/';
    }

    public static char getPathSeparator() {
        return ':';
    }

    private static String a(String string, int n2) {
        int n3;
        for (n3 = string.length(); n3 > n2 && string.charAt(n3 - 1) == '/'; --n3) {
        }
        if (n3 == 0) {
            return dB;
        }
        if (n3 == n2) {
            return string.substring(0, n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (n2 > 0) {
            stringBuilder.append(string, 0, n2);
        }
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (n4 == 47 && c2 == '/') continue;
            stringBuilder.append(c2);
            n4 = c2;
        }
        return stringBuilder.toString();
    }

    public static String normalize(String pathname) {
        int n2 = pathname.indexOf("//");
        if (n2 >= 0) {
            return e.a(pathname, n2);
        }
        if (pathname.endsWith(dB)) {
            return e.a(pathname, pathname.length() - 1);
        }
        return pathname;
    }

    public static int prefixLength(String pathname) {
        return pathname.startsWith(dB) ? 1 : 0;
    }

    private static String h(String string) {
        int n2 = string.length();
        if (n2 > 1 && string.charAt(n2 - 1) == '/') {
            return string.substring(0, n2 - 1);
        }
        return string;
    }

    public static String resolve(String parent, String child) {
        if (child.isEmpty()) {
            return parent;
        }
        if (child.charAt(0) == '/') {
            if (parent.equals(dB)) {
                return child;
            }
            return e.h(parent + child);
        }
        if (parent.equals(dB)) {
            return e.h(parent + child);
        }
        return e.h(parent + dB + child);
    }

    public static String getDefaultParent() {
        return dB;
    }

    public static String fromURIPath(String path) {
        String string = path;
        if (string.endsWith(dB) && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean isAbsolute(File f2) {
        return ((Target_java_io_File_Web)SubstrateUtil.cast((Object)f2, Target_java_io_File_Web.class)).getPrefixLength() != 0;
    }

    public static boolean isInvalid(File f2) {
        return f2.getPath().indexOf(0) >= 0;
    }

    public static String resolve(File f2) {
        if (e.isAbsolute(f2)) {
            return f2.getPath();
        }
        return e.resolve(dE, f2.getPath());
    }

    public static String canonicalize(String path) throws IOException {
        return e.i(path);
    }

    private static String i(String string) throws IOException {
        return e.j(string).toString();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/canonicalize_md.c#L48-L125")
    public static Path j(String string) throws IOException {
        Path path;
        Path path2 = Path.of(string, new String[0]).toAbsolutePath();
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        Path path3 = path2;
        do {
            if (Files.exists(path3, new LinkOption[0])) {
                path3 = path3.toRealPath(new LinkOption[0]);
                break;
            }
            path = path3.getFileName();
            if (path == null) break;
            arrayDeque.push(path.toString());
        } while ((path3 = path3.getParent()) != null);
        if (path3 == null) {
            path3 = Path.of(dB, new String[0]);
        }
        path = path3;
        for (String string2 : arrayDeque) {
            path = path.resolve(string2);
        }
        return path.normalize();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/UnixFileSystem_md.c#L116-L132")
    private static int a(File file) {
        int n2 = 0;
        Path path = file.toPath();
        if (Files.exists(path, new LinkOption[0])) {
            n2 |= Target_java_io_FileSystem_Web.BA_EXISTS;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            n2 |= Target_java_io_FileSystem_Web.BA_REGULAR;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            n2 |= Target_java_io_FileSystem_Web.BA_DIRECTORY;
        }
        return n2;
    }

    public static int getBooleanAttributes(File f2) {
        int n2 = e.a(f2);
        return n2 | e.b(f2);
    }

    public static boolean hasBooleanAttributes(File f2, int attributes) {
        int n2 = e.a(f2);
        if ((attributes & Target_java_io_FileSystem_Web.BA_HIDDEN) != 0) {
            n2 |= e.b(f2);
        }
        return (n2 & attributes) == attributes;
    }

    private static int b(File file) {
        return file.getName().startsWith(".") ? Target_java_io_FileSystem_Web.BA_HIDDEN : 0;
    }

    public static boolean checkAccess(File f2, int access) {
        return e.a(f2, access);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/UnixFileSystem_md.c#L134-L160")
    private static boolean a(File file, int n2) {
        Path path = file.toPath();
        if (n2 == Target_java_io_FileSystem_Web.ACCESS_READ) {
            return Files.isReadable(path);
        }
        if (n2 == Target_java_io_FileSystem_Web.ACCESS_WRITE) {
            return Files.isWritable(path);
        }
        if (n2 == Target_java_io_FileSystem_Web.ACCESS_EXECUTE) {
            return Files.isExecutable(path);
        }
        throw VMError.shouldNotReachHereUnexpectedInput((Object)n2);
    }

    public static boolean setPermission(File f2, int access, boolean enable, boolean owneronly) {
        return e.a(f2, access, enable, owneronly);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/UnixFileSystem_md.c#L163-L210")
    private static boolean a(File file, int n2, boolean bl, boolean bl2) {
        HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
        if (n2 == Target_java_io_FileSystem_Web.ACCESS_READ) {
            hashSet.add(PosixFilePermission.OWNER_READ);
            if (!bl2) {
                hashSet.add(PosixFilePermission.GROUP_READ);
                hashSet.add(PosixFilePermission.OTHERS_READ);
            }
        } else if (n2 == Target_java_io_FileSystem_Web.ACCESS_WRITE) {
            hashSet.add(PosixFilePermission.OWNER_WRITE);
            if (!bl2) {
                hashSet.add(PosixFilePermission.GROUP_WRITE);
                hashSet.add(PosixFilePermission.OTHERS_WRITE);
            }
        } else if (n2 == Target_java_io_FileSystem_Web.ACCESS_EXECUTE) {
            hashSet.add(PosixFilePermission.OWNER_EXECUTE);
            if (!bl2) {
                hashSet.add(PosixFilePermission.GROUP_EXECUTE);
                hashSet.add(PosixFilePermission.OTHERS_EXECUTE);
            }
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput((Object)n2);
        }
        Path path = file.toPath();
        try {
            HashSet<PosixFilePermission> hashSet2 = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
            if (bl) {
                hashSet2.addAll(hashSet);
            } else {
                hashSet2.removeAll(hashSet);
            }
            Files.setPosixFilePermissions(path, hashSet2);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static long getLastModifiedTime(File f2) {
        return e.c(f2);
    }

    private static long c(File file) {
        try {
            FileTime fileTime = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]);
            return fileTime.toMillis();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static long getLength(File f2) {
        return e.d(f2);
    }

    private static long d(File file) {
        try {
            Path path = file.toPath();
            if (!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
                return 0L;
            }
            return Files.size(path);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static boolean createFileExclusively(String path) throws IOException {
        return e.k(path);
    }

    private static boolean k(String string) throws IOException {
        try {
            Path path = Path.of(string, new String[0]);
            Files.createFile(path, new FileAttribute[0]);
            return true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            return false;
        }
    }

    public static boolean delete(File f2) {
        return e.e(f2);
    }

    private static boolean e(File file) {
        try {
            return Files.deleteIfExists(file.toPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String[] list(File f2) {
        return e.f(f2);
    }

    private static String[] f(File file) {
        String[] stringArray;
        block10: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file.toPath());
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Path path : directoryStream) {
                    Path path2 = path.getFileName();
                    assert (path2 != null);
                    arrayList.add(path2.toString());
                }
                stringArray = arrayList.toArray(new String[0]);
                if (directoryStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            directoryStream.close();
        }
        return stringArray;
    }

    public static boolean createDirectory(File f2) {
        return e.g(f2);
    }

    private static boolean g(File file) {
        try {
            Files.createDirectory(file.toPath(), new FileAttribute[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean rename(File f1, File f2) {
        return e.a(f1, f2);
    }

    private static boolean a(File file, File file2) {
        try {
            Files.move(file.toPath(), file2.toPath(), new CopyOption[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean setLastModifiedTime(File f2, long time) {
        return e.a(f2, time);
    }

    private static boolean a(File file, long l2) {
        try {
            Files.setLastModifiedTime(file.toPath(), FileTime.fromMillis(l2));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean setReadOnly(File f2) {
        return e.h(f2);
    }

    private static boolean h(File file) {
        return e.setPermission(file, Target_java_io_FileSystem_Web.ACCESS_WRITE, false, false);
    }

    public static File[] listRoots() {
        return new File[]{new File(dB)};
    }

    public static long getSpace(File f2, int t2) {
        return e.b(f2, t2);
    }

    private static long b(File file, int n2) {
        try {
            FileStore fileStore = Files.getFileStore(file.toPath());
            if (n2 == Target_java_io_FileSystem_Web.SPACE_TOTAL) {
                return fileStore.getTotalSpace();
            }
            if (n2 == Target_java_io_FileSystem_Web.SPACE_FREE) {
                return fileStore.getUnallocatedSpace();
            }
            if (n2 == Target_java_io_FileSystem_Web.SPACE_USABLE) {
                return fileStore.getUsableSpace();
            }
            throw VMError.shouldNotReachHereUnexpectedInput((Object)n2);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private static long am() {
        return 255L;
    }

    public static int getNameMax(String path) {
        long l2 = e.am();
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    public static int compare(File f1, File f2) {
        return f1.getPath().compareTo(f2.getPath());
    }

    public static int hashCode(File f2) {
        return f2.getPath().hashCode() ^ 0x12D591;
    }
}

