/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.diagnosticsagent;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIJavaVM;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.diagnosticsagent.ClinitGenerationVisitor;
import com.oracle.svm.diagnosticsagent.JavaStackTraceCreator;
import com.oracle.svm.diagnosticsagent.NativeImageDiagnosticsAgentJNIHandleSet;
import com.oracle.svm.diagnosticsagent.ObjectInstantiationTraceCreator;
import com.oracle.svm.diagnosticsagent.TracingAdvisor;
import com.oracle.svm.jvmtiagentbase.AgentIsolate;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import com.oracle.svm.jvmtiagentbase.JvmtiAgentBase;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiCapabilities;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEvent;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventCallbacks;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEventMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class NativeImageDiagnosticsAgent
extends JvmtiAgentBase<NativeImageDiagnosticsAgentJNIHandleSet> {
    private static final CEntryPointLiteral<CFunctionPointer> ON_CLASS_PREPARE = CEntryPointLiteral.create(NativeImageDiagnosticsAgent.class, (String)"onClassPrepare", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class});
    private static final CEntryPointLiteral<CFunctionPointer> ON_BREAKPOINT = CEntryPointLiteral.create(NativeImageDiagnosticsAgent.class, (String)"onBreakpoint", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIMethodId.class, Long.TYPE});
    private static final CEntryPointLiteral<CFunctionPointer> ON_CLASS_FILE_LOAD_HOOK = CEntryPointLiteral.create(NativeImageDiagnosticsAgent.class, (String)"onClassFileLoadHook", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class, JNIObjectHandle.class, CCharPointer.class, JNIObjectHandle.class, Integer.TYPE, CCharPointer.class, CIntPointer.class, CCharPointerPointer.class});
    private final Map<Long, ClassHandleHolder> clinitClassMap = new ConcurrentHashMap<Long, ClassHandleHolder>();
    private final Map<Long, ClassHandleHolder> initClassMap = new ConcurrentHashMap<Long, ClassHandleHolder>();
    TracingAdvisor advisor;
    static final int ASM8 = 524288;
    static final int ASM_TARGET_VERSION = 524288;

    protected JNIHandleSet constructJavaHandles(JNIEnvironment env) {
        return new NativeImageDiagnosticsAgentJNIHandleSet(env);
    }

    protected int onLoadCallback(JNIJavaVM vm, JvmtiEnv jvmti, JvmtiEventCallbacks callbacks, String options) {
        this.advisor = new TracingAdvisor(options);
        NativeImageDiagnosticsAgent.enableCapabilities(jvmti);
        callbacks.setClassPrepare(ON_CLASS_PREPARE.getFunctionPointer());
        callbacks.setBreakpoint(ON_BREAKPOINT.getFunctionPointer());
        callbacks.setClassFileLoadHook(ON_CLASS_FILE_LOAD_HOOK.getFunctionPointer());
        jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_BREAKPOINT, (JNIObjectHandle)JNIObjectHandles.nullHandle());
        Support.check((JvmtiError)jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_CLASS_FILE_LOAD_HOOK, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        return 0;
    }

    protected void onVMInitCallback(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
        this.openInstrumentationModuleToAllOtherModules(jvmti, jni);
        ((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).initializeTrackingSupportHandles(jni);
        jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_CLASS_PREPARE, (JNIObjectHandle)JNIObjectHandles.nullHandle());
        this.setConstructorBreakpointsForLoadedClasses(jvmti, jni);
    }

    private void setConstructorBreakpointsForLoadedClasses(JvmtiEnv jvmti, JNIEnvironment jni) {
        CIntPointer classCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        WordPointer classesPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check((JvmtiError)Support.jvmtiFunctions().GetLoadedClasses().invoke(jvmti, classCountPtr, classesPtr));
        WordPointer classesArray = (WordPointer)classesPtr.read();
        int classCount = classCountPtr.read();
        for (int i = 0; i < classCount; ++i) {
            JNIObjectHandle clazz = (JNIObjectHandle)classesArray.read(i);
            String className = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)clazz);
            if (!this.advisor.shouldTraceObjectInstantiation(className)) continue;
            this.setConstructorBreakpointsForClass(jvmti, jni, clazz, className);
        }
        Support.jvmtiFunctions().Deallocate().invoke(jvmti, (PointerBase)classesArray);
    }

    private void onClassPrepareCallback(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle clazz) {
        String className = Support.getClassNameOrNull((JNIEnvironment)jni, (JNIObjectHandle)clazz);
        if (className != null) {
            if (this.advisor.shouldTraceClassInitialization(className)) {
                JNIMethodId clinitMethodId = NativeImageDiagnosticsAgent.getClassClinitMethodIdOrNull(jvmti, clazz);
                if (clinitMethodId.notEqual((ComparableWord)JNIObjectHandles.nullHandle())) {
                    JNIObjectHandle klass = ((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).newTrackedGlobalRef(jni, clazz);
                    ClassHandleHolder classHandleHolder = new ClassHandleHolder(klass);
                    this.clinitClassMap.put(clinitMethodId.rawValue(), classHandleHolder);
                    Support.check((JvmtiError)jvmti.getFunctions().SetBreakpoint().invoke(jvmti, clinitMethodId, 0L));
                } else {
                    System.err.println("Trace class initialization requested for " + className + " but the class has not been instrumented with <clinit>.");
                }
            }
            if (this.advisor.shouldTraceObjectInstantiation(className)) {
                this.setConstructorBreakpointsForClass(jvmti, jni, clazz, className);
            }
        }
    }

    private void setConstructorBreakpointsForClass(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle clazz, String className) {
        List<MethodIdHolder> initMethodIds = NativeImageDiagnosticsAgent.getClassMethodIdsWithName(jvmti, clazz, "<init>");
        if (initMethodIds.size() != 0) {
            JNIObjectHandle klass = ((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).newTrackedGlobalRef(jni, clazz);
            ClassHandleHolder classHandleHolder = new ClassHandleHolder(klass);
            for (MethodIdHolder holder : initMethodIds) {
                this.initClassMap.put(holder.methodId.rawValue(), classHandleHolder);
                Support.check((JvmtiError)jvmti.getFunctions().SetBreakpoint().invoke(jvmti, holder.methodId, 0L));
            }
        } else {
            System.err.println("Trace object instantiation requested for " + className + " but the class has no constructors.");
        }
    }

    private void onBreakpointCallback(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method) {
        block4: {
            try {
                if (this.clinitClassMap.get(method.rawValue()) != null) {
                    this.handleClinitBreakpoint(jvmti, jni, method);
                    break block4;
                }
                if (this.initClassMap.get(method.rawValue()) != null) {
                    this.handleInitBreakpoint(jvmti, jni, thread);
                    break block4;
                }
                throw VMError.shouldNotReachHere((String)"Breakpoint hit for a method that isn't tracked in the diagnostics agent. (For developers: have you set a breakpoint in a method that isn't <clinit> or <init>)");
            }
            catch (Support.WrongPhaseError wrongPhaseError) {
                // empty catch block
            }
        }
    }

    private void handleClinitBreakpoint(JvmtiEnv jvmti, JNIEnvironment jni, JNIMethodId method) {
        JNIObjectHandle clazz = this.clinitClassMap.get((Object)Long.valueOf((long)method.rawValue())).clazz;
        JavaStackTraceCreator stackTraceCreator = new JavaStackTraceCreator(jvmti, jni);
        JNIObjectHandle threadStackTrace = stackTraceCreator.getStackTraceArray();
        this.reportClassInitialized(jni, clazz, threadStackTrace);
    }

    private void handleInitBreakpoint(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
        JNIObjectHandle thisHandle = Support.getReceiver((JNIObjectHandle)thread);
        if (thisHandle.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return;
        }
        ObjectInstantiationTraceCreator stackTraceCreator = new ObjectInstantiationTraceCreator(jvmti, jni);
        JNIObjectHandle threadStackTrace = stackTraceCreator.getStackTraceArray();
        if (!stackTraceCreator.encounteredObjectInstantiatedReportCall()) {
            this.reportObjectInstantiated(jni, thisHandle, threadStackTrace);
        }
    }

    private static void enableCapabilities(JvmtiEnv jvmti) {
        JvmtiCapabilities capabilities = (JvmtiCapabilities)UnmanagedMemory.calloc((int)SizeOf.get(JvmtiCapabilities.class));
        Support.check((JvmtiError)jvmti.getFunctions().GetCapabilities().invoke(jvmti, capabilities));
        capabilities.setCanGenerateBreakpointEvents(1);
        capabilities.setCanAccessLocalVariables(1);
        Support.check((JvmtiError)jvmti.getFunctions().AddCapabilities().invoke(jvmti, capabilities));
        capabilities.setCanGetLineNumbers(1);
        capabilities.setCanGetSourceFileName(1);
        jvmti.getFunctions().AddCapabilities().invoke(jvmti, capabilities);
        UnmanagedMemory.free((PointerBase)capabilities);
    }

    private void openInstrumentationModuleToAllOtherModules(JvmtiEnv jvmti, JNIEnvironment jni) {
        JNIObjectHandle moduleClass = ((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).findClass(jni, "java/lang/Module");
        JNIMethodId moduleGetName = ((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).getMethodId(jni, moduleClass, "getName", "()Ljava/lang/String;", false);
        try (CTypeConversion.CCharPointerHolder packageName = Support.toCString((String)"org.graalvm.nativeimage.impl.clinit");){
            JNIObjectHandle module;
            int i;
            CIntPointer moduleCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
            WordPointer modulesPtr = (WordPointer)StackValue.get(WordPointer.class);
            Support.check((JvmtiError)jvmti.getFunctions().GetAllModules().invoke(jvmti, moduleCountPtr, (PointerBase)modulesPtr));
            int moduleCount = moduleCountPtr.read();
            WordPointer modulesArrayPtr = (WordPointer)modulesPtr.read();
            JNIObjectHandle clinitTrackingSupportModule = (JNIObjectHandle)JNIObjectHandles.nullHandle();
            for (i = 0; i < moduleCount; ++i) {
                module = (JNIObjectHandle)modulesArrayPtr.read(i);
                VMError.guarantee((boolean)module.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), (String)"Unexpected null handle while iterating over modules.");
                JNIObjectHandle moduleName = Support.callObjectMethod((JNIEnvironment)jni, (JNIObjectHandle)module, (JNIMethodId)moduleGetName);
                String name = Support.fromJniString((JNIEnvironment)jni, (JNIObjectHandle)moduleName);
                if (name == null || !name.equals("org.graalvm.nativeimage")) continue;
                clinitTrackingSupportModule = module;
                break;
            }
            VMError.guarantee((boolean)clinitTrackingSupportModule.notEqual((ComparableWord)JNIObjectHandles.nullHandle()), (String)"The module name that provides clinit reporting support has changed.");
            for (i = 0; i < moduleCount; ++i) {
                module = (JNIObjectHandle)modulesArrayPtr.read(i);
                Support.check((JvmtiError)jvmti.getFunctions().AddModuleOpens().invoke(jvmti, clinitTrackingSupportModule, packageName.get(), module));
            }
            jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)modulesArrayPtr);
        }
    }

    private static List<MethodIdHolder> getClassMethodIdsWithName(JvmtiEnv jvmti, JNIObjectHandle clazz, String methodName) {
        ArrayList<MethodIdHolder> methodIds = new ArrayList<MethodIdHolder>();
        CIntPointer methodCountPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        WordPointer methodsPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.check((JvmtiError)jvmti.getFunctions().GetClassMethods().invoke(jvmti, clazz, methodCountPtr, methodsPtr));
        int methodCount = methodCountPtr.read();
        WordPointer methodsArray = (WordPointer)methodsPtr.read();
        for (int i = 0; i < methodCount; ++i) {
            JNIMethodId methodId = (JNIMethodId)methodsArray.read(i);
            String currentMethodName = Support.getMethodNameOr((JNIMethodId)methodId, (String)"");
            if (!currentMethodName.equals(methodName)) continue;
            methodIds.add(new MethodIdHolder(methodId));
        }
        Support.check((JvmtiError)jvmti.getFunctions().Deallocate().invoke(jvmti, (PointerBase)methodsPtr.read()));
        return methodIds;
    }

    private static JNIMethodId getClassClinitMethodIdOrNull(JvmtiEnv jvmti, JNIObjectHandle clazz) {
        List<MethodIdHolder> classMethodIdsWithName = NativeImageDiagnosticsAgent.getClassMethodIdsWithName(jvmti, clazz, "<clinit>");
        VMError.guarantee((classMethodIdsWithName.size() < 2 ? 1 : 0) != 0);
        return classMethodIdsWithName.size() == 1 ? classMethodIdsWithName.get((int)0).methodId : (JNIMethodId)WordFactory.nullPointer();
    }

    private void reportClassInitialized(JNIEnvironment jni, JNIObjectHandle clazz, JNIObjectHandle stackTrace) {
        Support.callStaticVoidMethodLL((JNIEnvironment)jni, (JNIObjectHandle)((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).getClassInitializationTrackingClassHandle(), (JNIMethodId)((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).getReportClassInitializedMethodId(), (JNIObjectHandle)clazz, (JNIObjectHandle)stackTrace);
    }

    private void reportObjectInstantiated(JNIEnvironment jni, JNIObjectHandle object, JNIObjectHandle stackTrace) {
        Support.callStaticVoidMethodLL((JNIEnvironment)jni, (JNIObjectHandle)((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).getClassInitializationTrackingClassHandle(), (JNIMethodId)((NativeImageDiagnosticsAgentJNIHandleSet)this.handles()).getReportObjectInstantiatedMethodId(), (JNIObjectHandle)object, (JNIObjectHandle)stackTrace);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onClassPrepare(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIObjectHandle clazz) {
        NativeImageDiagnosticsAgent agent = (NativeImageDiagnosticsAgent)NativeImageDiagnosticsAgent.singleton();
        agent.onClassPrepareCallback(jvmti, jni, clazz);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onClassFileLoadHook(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle classBeingRedefined, JNIObjectHandle loader, CCharPointer name, JNIObjectHandle protectionDomain, int classDataLen, CCharPointer classData, CIntPointer newClassDataLen, CCharPointerPointer newClassData) {
        String javaName = CTypeConversion.toJavaString((CCharPointer)name);
        byte[] clazzData = new byte[classDataLen];
        CTypeConversion.asByteBuffer((PointerBase)classData, (int)classDataLen).get(clazzData);
        NativeImageDiagnosticsAgent agent = (NativeImageDiagnosticsAgent)NativeImageDiagnosticsAgent.singleton();
        byte[] result = agent.maybeInstrumentClassWithClinit(javaName, clazzData);
        if (result == null) {
            return;
        }
        int newClassDataLength = result.length;
        Support.check((JvmtiError)jvmti.getFunctions().Allocate().invoke(jvmti, (long)newClassDataLength, newClassData));
        CTypeConversion.asByteBuffer((PointerBase)newClassData.read(), (int)newClassDataLength).put(result);
        newClassDataLen.write(newClassDataLength);
    }

    private byte[] maybeInstrumentClassWithClinit(String clazzName, byte[] clazzData) {
        if (clazzName != null && !this.advisor.shouldTraceClassInitialization(clazzName.replace('/', '.'))) {
            return null;
        }
        try {
            ClassReader reader = new ClassReader(clazzData);
            ClassWriter writer = new ClassWriter(reader, 0);
            ClinitGenerationVisitor visitor = new ClinitGenerationVisitor(524288, writer);
            reader.accept(visitor, 0);
            if (!visitor.didGeneration()) {
                return null;
            }
            return writer.toByteArray();
        }
        catch (Throwable e) {
            String targetClazzName = clazzName != null ? clazzName : "<unknown class>";
            System.err.println("[native-image-diagnostics-agent] Failed to instrument class " + targetClazzName + ": ");
            e.printStackTrace(System.err);
            return null;
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class)
    private static void onBreakpoint(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread, JNIMethodId method, long location) {
        NativeImageDiagnosticsAgent agent = (NativeImageDiagnosticsAgent)NativeImageDiagnosticsAgent.singleton();
        agent.onBreakpointCallback(jvmti, jni, thread, method);
    }

    protected int onUnloadCallback(JNIJavaVM vm) {
        return 0;
    }

    protected void onVMStartCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
    }

    protected void onVMDeathCallback(JvmtiEnv jvmti, JNIEnvironment jni) {
    }

    protected int getRequiredJvmtiVersion() {
        return 0x30090000;
    }

    private static final class ClassHandleHolder {
        final JNIObjectHandle clazz;

        ClassHandleHolder(JNIObjectHandle clazz) {
            this.clazz = clazz;
        }
    }

    private static final class MethodIdHolder {
        final JNIMethodId methodId;

        MethodIdHolder(JNIMethodId methodId) {
            this.methodId = methodId;
        }
    }

    public static class RegistrationFeature
    implements Feature {
        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            NativeImageDiagnosticsAgent.registerAgent((JvmtiAgentBase)new NativeImageDiagnosticsAgent());
        }
    }
}

