/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.processor;

import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import jdk.graal.compiler.processor.AbstractProcessor;
import jdk.graal.compiler.replacements.processor.GeneratedPlugin;
import jdk.graal.compiler.replacements.processor.InjectedDependencies;

public abstract class GeneratedNodeIntrinsicPlugin
extends GeneratedPlugin {
    private final TypeMirror[] signature;

    public GeneratedNodeIntrinsicPlugin(ExecutableElement intrinsicMethod, TypeMirror[] signature) {
        super(intrinsicMethod);
        this.signature = signature;
    }

    @Override
    protected TypeElement getAnnotationClass(AbstractProcessor processor) {
        return processor.getTypeElement("jdk.graal.compiler.graph.Node.NodeIntrinsic");
    }

    @Override
    protected String pluginSuperclass() {
        return "GeneratedNodeIntrinsicInvocationPlugin";
    }

    @Override
    public void extraImports(AbstractProcessor processor, Set<String> imports) {
        imports.add("jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext");
        if (this.needsReplacement(processor)) {
            imports.add("jdk.graal.compiler.core.common.type.Stamp");
        }
    }

    protected abstract List<? extends VariableElement> getParameters();

    protected abstract void factoryCall(AbstractProcessor var1, PrintWriter var2, InjectedDependencies var3, int var4, boolean var5);

    @Override
    protected void createExecute(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps) {
        VariableElement param;
        int idx;
        List<? extends VariableElement> params = this.getParameters();
        for (idx = 0; idx < params.size() && processor.getAnnotation(param = params.get(idx), processor.getType("jdk.graal.compiler.graph.Node.InjectedNodeParameter")) != null; ++idx) {
            out.printf("        %s arg%d = %s;\n", param.asType(), idx, deps.use(processor, (DeclaredType)param.asType()));
        }
        int i = 0;
        while (i < this.signature.length) {
            if (processor.getAnnotation(this.intrinsicMethod.getParameters().get(i), processor.getType("jdk.graal.compiler.graph.Node.ConstantNodeParameter")) != null) {
                String argName = this.constantArgument(processor, out, deps, idx, this.signature[i], i, false);
                this.verifyConstantArgument(out, argName, this.signature[i]);
            } else if (this.signature[i].equals(processor.getType("jdk.graal.compiler.nodes.ValueNode"))) {
                out.printf("        ValueNode arg%d = args[%d];\n", idx, i);
            } else {
                out.printf("        %s arg%d = (%s) args[%d];\n", this.signature[i], idx, this.signature[i], i);
            }
            ++i;
            ++idx;
        }
        this.factoryCall(processor, out, deps, idx, false);
    }

    protected void verifyConstantArgument(PrintWriter out, String argName, TypeMirror type) {
    }

    @Override
    protected void createOtherClasses(AbstractProcessor processor, PrintWriter out) {
        if (this.needsReplacement(processor)) {
            if (this.isWithExceptionReplacement(processor)) {
                String name = this.getReplacementName();
                out.printf("//        class: %s\n", this.intrinsicMethod.getEnclosingElement());
                out.printf("//       method: %s\n", this.intrinsicMethod);
                out.printf("// generated-by: %s\n", this.getClass().getName());
                out.printf("@ExcludeFromJacocoGeneratedReport(\"deferred plugin support that is only called in libgraal\")\n", new Object[0]);
                out.printf("final class %s implements PluginReplacementWithExceptionNode.ReplacementWithExceptionFunction {\n", name);
                out.printf("    static PluginReplacementWithExceptionNode.ReplacementWithExceptionFunction FUNCTION = new %s();\n", name);
                InjectedDependencies deps = new InjectedDependencies(false, this.intrinsicMethod);
                this.createHelpers(processor, out, deps);
                out.printf("}\n", new Object[0]);
            } else {
                super.createOtherClasses(processor, out);
            }
        }
    }

    @Override
    protected boolean needsReplacement(AbstractProcessor processor) {
        VariableElement param;
        int idx;
        List<? extends VariableElement> params = this.getParameters();
        for (idx = 0; idx < params.size() && processor.getAnnotation(param = params.get(idx), processor.getType("jdk.graal.compiler.graph.Node.InjectedNodeParameter")) != null; ++idx) {
        }
        int i = 0;
        while (i < this.signature.length) {
            if (processor.getAnnotation(this.intrinsicMethod.getParameters().get(i), processor.getType("jdk.graal.compiler.graph.Node.ConstantNodeParameter")) != null) {
                return true;
            }
            ++i;
            ++idx;
        }
        return false;
    }

    @Override
    protected void createHelpers(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps) {
        VariableElement param;
        int idx;
        if (!this.needsReplacement(processor)) {
            return;
        }
        out.printf("\n", new Object[0]);
        out.printf("    @Override\n", new Object[0]);
        out.printf("    public boolean replace(GraphBuilderContext b, Replacements injection, Stamp stamp, NodeInputList<ValueNode> args) {\n", new Object[0]);
        List<? extends VariableElement> params = this.getParameters();
        for (idx = 0; idx < params.size() && processor.getAnnotation(param = params.get(idx), processor.getType("jdk.graal.compiler.graph.Node.InjectedNodeParameter")) != null; ++idx) {
            out.printf("        %s arg%d = %s;\n", param.asType(), idx, deps.find(processor, (DeclaredType)param.asType()).getExpression(processor, this.intrinsicMethod));
        }
        int i = 0;
        while (i < this.signature.length) {
            if (processor.getAnnotation(this.intrinsicMethod.getParameters().get(i), processor.getType("jdk.graal.compiler.graph.Node.ConstantNodeParameter")) != null) {
                this.constantArgument(processor, out, deps, idx, this.signature[i], i, true);
            } else if (this.signature[i].equals(processor.getType("jdk.graal.compiler.nodes.ValueNode"))) {
                out.printf("        ValueNode arg%d = args.get(%d);\n", idx, i);
            } else {
                out.printf("        %s arg%d = (%s) args.get(%d);\n", this.signature[i], idx, this.signature[i], i);
            }
            ++i;
            ++idx;
        }
        this.factoryCall(processor, out, deps, idx, true);
        out.printf("    }\n", new Object[0]);
    }

    public static class CustomFactoryPlugin
    extends GeneratedNodeIntrinsicPlugin {
        private final ExecutableElement customFactory;

        public CustomFactoryPlugin(ExecutableElement intrinsicMethod, ExecutableElement customFactory, TypeMirror[] signature) {
            super(intrinsicMethod, signature);
            this.customFactory = customFactory;
        }

        @Override
        protected List<? extends VariableElement> getParameters() {
            List<? extends VariableElement> ret = this.customFactory.getParameters();
            return ret.subList(1, ret.size());
        }

        @Override
        public void extraImports(AbstractProcessor processor, Set<String> imports) {
            if (this.needsReplacement(processor)) {
                imports.add("jdk.graal.compiler.debug.GraalError");
            }
            super.extraImports(processor, imports);
        }

        @Override
        protected void factoryCall(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps, int argCount, boolean inReplacement) {
            out.printf("        if (%s.%s(b", this.customFactory.getEnclosingElement(), this.customFactory.getSimpleName());
            for (int i = 0; i < argCount; ++i) {
                out.printf(", arg%d", i);
            }
            out.printf(")) {\n", new Object[0]);
            out.printf("            return true;\n", new Object[0]);
            out.printf("        }\n", new Object[0]);
            if (this.needsReplacement(processor) && !inReplacement) {
                out.printf("        if (b.canDeferPlugin(this)) {\n", new Object[0]);
                out.printf("            b.replacePlugin%s(this, targetMethod, args, %s.FUNCTION);\n", this.getReplacementFunctionSuffix(processor), this.getReplacementName());
                out.printf("            return true;\n", new Object[0]);
                out.printf("        }\n", new Object[0]);
                out.printf("        throw GraalError.shouldNotReachHere(\"Can't inline plugin \" + b.getClass().toString());\n", new Object[0]);
            } else {
                out.printf("        return false;\n", new Object[0]);
            }
        }

        @Override
        protected void verifyConstantArgument(PrintWriter out, String argName, TypeMirror type) {
            if (CustomFactoryPlugin.getErasedType(type).equals("jdk.graal.compiler.core.common.spi.ForeignCallDescriptor")) {
                out.printf("        assert verifyForeignCallDescriptor(b, targetMethod, %s) : %s;\n", argName, argName);
            }
        }
    }

    public static class ConstructorPlugin
    extends GeneratedNodeIntrinsicPlugin {
        private final ExecutableElement constructor;

        public ConstructorPlugin(ExecutableElement intrinsicMethod, ExecutableElement constructor, TypeMirror[] signature) {
            super(intrinsicMethod, signature);
            this.constructor = constructor;
        }

        @Override
        public void extraImports(AbstractProcessor processor, Set<String> imports) {
            if (this.intrinsicMethod.getReturnType().getKind() != TypeKind.VOID) {
                imports.add("jdk.vm.ci.meta.JavaKind");
            }
            super.extraImports(processor, imports);
        }

        @Override
        protected List<? extends VariableElement> getParameters() {
            return this.constructor.getParameters();
        }

        @Override
        protected void factoryCall(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps, int argCount, boolean inReplacement) {
            out.printf("        %s node = new %s(", this.constructor.getEnclosingElement(), this.constructor.getEnclosingElement());
            if (argCount > 0) {
                out.printf("arg0", new Object[0]);
                for (int i = 1; i < argCount; ++i) {
                    out.printf(", arg%d", i);
                }
            }
            out.printf(");\n", new Object[0]);
            if (this.intrinsicMethod.getReturnType().getKind() == TypeKind.VOID) {
                out.printf("        b.add(node);\n", new Object[0]);
            } else {
                out.printf("        b.addPush(JavaKind.%s, node);\n", ConstructorPlugin.getReturnKind(this.intrinsicMethod));
            }
            out.printf("        return true;\n", new Object[0]);
        }
    }
}

