/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.processor;

import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import jdk.graal.compiler.processor.AbstractProcessor;
import jdk.graal.compiler.replacements.processor.GeneratedPlugin;
import jdk.graal.compiler.replacements.processor.InjectedDependencies;

public class GeneratedFoldPlugin
extends GeneratedPlugin {
    public GeneratedFoldPlugin(ExecutableElement intrinsicMethod) {
        super(intrinsicMethod);
    }

    @Override
    protected TypeElement getAnnotationClass(AbstractProcessor processor) {
        return processor.getTypeElement("jdk.graal.compiler.api.replacements.Fold");
    }

    @Override
    protected String pluginSuperclass() {
        return "GeneratedFoldInvocationPlugin";
    }

    @Override
    public void extraImports(AbstractProcessor processor, Set<String> imports) {
        imports.add("jdk.vm.ci.meta.JavaConstant");
        imports.add("jdk.vm.ci.meta.JavaKind");
        imports.add("jdk.graal.compiler.nodes.ConstantNode");
        imports.add("jdk.graal.compiler.core.common.type.Stamp");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createExecute(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps) {
        Object receiver;
        List<? extends VariableElement> params = this.intrinsicMethod.getParameters();
        out.printf("        if (b.shouldDeferPlugin(this)) {\n", new Object[0]);
        out.printf("            b.replacePlugin%s(this, targetMethod, args, %s.FUNCTION);\n", this.getReplacementFunctionSuffix(processor), this.getReplacementName());
        out.printf("            return true;\n", new Object[0]);
        out.printf("        }\n", new Object[0]);
        int argCount = 0;
        if (this.intrinsicMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            receiver = this.intrinsicMethod.getEnclosingElement();
        } else {
            receiver = "arg0";
            TypeElement type = (TypeElement)this.intrinsicMethod.getEnclosingElement();
            this.constantArgument(processor, out, deps, argCount, type.asType(), argCount, false);
            ++argCount;
        }
        int firstArg = argCount;
        for (VariableElement variableElement : params) {
            if (processor.getAnnotation(variableElement, processor.getType("jdk.graal.compiler.api.replacements.Fold.InjectedParameter")) == null) {
                this.constantArgument(processor, out, deps, argCount, variableElement.asType(), argCount, false);
            } else {
                out.printf("        if (!checkInjectedArgument(b, args[%d], targetMethod)) {\n", argCount);
                out.printf("            return false;\n", new Object[0]);
                out.printf("        }\n", new Object[0]);
                out.printf("        %s arg%d = %s;\n", variableElement.asType(), argCount, deps.use(processor, (DeclaredType)variableElement.asType()));
            }
            ++argCount;
        }
        TreeSet<String> suppressWarnings = new TreeSet<String>();
        if (this.intrinsicMethod.getAnnotation(Deprecated.class) != null) {
            suppressWarnings.add("deprecation");
        }
        if (GeneratedFoldPlugin.hasRawtypeWarning(this.intrinsicMethod.getReturnType())) {
            suppressWarnings.add("rawtypes");
        }
        for (VariableElement variableElement : params) {
            if (!GeneratedFoldPlugin.hasUncheckedWarning(variableElement.asType())) continue;
            suppressWarnings.add("unchecked");
        }
        if (suppressWarnings.size() > 0) {
            out.printf("        @SuppressWarnings({", new Object[0]);
            String string = "";
            for (String suppressWarning : suppressWarnings) {
                void var9_13;
                out.printf("%s\"%s\"", var9_13, suppressWarning);
                String string2 = ", ";
            }
            out.printf("})\n", new Object[0]);
        }
        out.printf("        %s result = %s.%s(", GeneratedFoldPlugin.getErasedType(this.intrinsicMethod.getReturnType()), receiver, this.intrinsicMethod.getSimpleName());
        if (argCount > firstArg) {
            void var9_17;
            out.printf("arg%d", firstArg);
            int n = firstArg + 1;
            while (var9_17 < argCount) {
                out.printf(", arg%d", (int)var9_17);
                ++var9_17;
            }
        }
        out.printf(");\n", new Object[0]);
        TypeMirror typeMirror = this.intrinsicMethod.getReturnType();
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                out.printf("        JavaConstant constant = JavaConstant.forInt(result ? 1 : 0);\n", new Object[0]);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: {
                out.printf("        JavaConstant constant = JavaConstant.forInt(result);\n", new Object[0]);
                break;
            }
            case LONG: {
                out.printf("        JavaConstant constant = JavaConstant.forLong(result);\n", new Object[0]);
                break;
            }
            case FLOAT: {
                out.printf("        JavaConstant constant = JavaConstant.forFloat(result);\n", new Object[0]);
                break;
            }
            case DOUBLE: {
                out.printf("        JavaConstant constant = JavaConstant.forDouble(result);\n", new Object[0]);
                break;
            }
            case ARRAY: 
            case TYPEVAR: 
            case DECLARED: {
                if (typeMirror.equals(processor.getType("java.lang.String"))) {
                    out.printf("        JavaConstant constant = %s.forString(result);\n", deps.use(processor, InjectedDependencies.WellKnownDependency.CONSTANT_REFLECTION));
                    break;
                }
                out.printf("        JavaConstant constant = %s.forObject(result);\n", deps.use(processor, InjectedDependencies.WellKnownDependency.SNIPPET_REFLECTION));
                break;
            }
            default: {
                throw new IllegalArgumentException(typeMirror.toString());
            }
        }
        out.printf("        ConstantNode node = ConstantNode.forConstant(constant, %s, %s);\n", deps.use(processor, InjectedDependencies.WellKnownDependency.META_ACCESS), deps.use(processor, InjectedDependencies.WellKnownDependency.STRUCTURED_GRAPH));
        out.printf("        b.push(JavaKind.%s, node);\n", GeneratedFoldPlugin.getReturnKind(this.intrinsicMethod));
        out.printf("        return true;\n", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createHelpers(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps) {
        Object receiver;
        out.printf("\n", new Object[0]);
        out.printf("    @Override\n", new Object[0]);
        out.printf("    public boolean replace(GraphBuilderContext b, Replacements injection, Stamp stamp, NodeInputList<ValueNode> args) {\n", new Object[0]);
        List<? extends VariableElement> params = this.intrinsicMethod.getParameters();
        int argCount = 0;
        if (this.intrinsicMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            receiver = this.intrinsicMethod.getEnclosingElement();
        } else {
            receiver = "arg0";
            TypeElement type = (TypeElement)this.intrinsicMethod.getEnclosingElement();
            this.constantArgument(processor, out, deps, argCount, type.asType(), argCount, true);
            ++argCount;
        }
        int firstArg = argCount;
        for (VariableElement variableElement : params) {
            if (processor.getAnnotation(variableElement, processor.getType("jdk.graal.compiler.api.replacements.Fold.InjectedParameter")) == null) {
                this.constantArgument(processor, out, deps, argCount, variableElement.asType(), argCount, true);
            } else {
                out.printf("        assert args.get(%d).isNullConstant() : \"Must be null constant \" + args.get(%d);\n", argCount, argCount);
                out.printf("        %s arg%d = %s;\n", variableElement.asType(), argCount, deps.find(processor, (DeclaredType)variableElement.asType()).getExpression(processor, this.intrinsicMethod));
            }
            ++argCount;
        }
        TreeSet<String> suppressWarnings = new TreeSet<String>();
        if (this.intrinsicMethod.getAnnotation(Deprecated.class) != null) {
            suppressWarnings.add("deprecation");
        }
        if (GeneratedFoldPlugin.hasRawtypeWarning(this.intrinsicMethod.getReturnType())) {
            suppressWarnings.add("rawtypes");
        }
        for (VariableElement variableElement : params) {
            if (!GeneratedFoldPlugin.hasUncheckedWarning(variableElement.asType())) continue;
            suppressWarnings.add("unchecked");
        }
        if (suppressWarnings.size() > 0) {
            out.printf("        @SuppressWarnings({", new Object[0]);
            String string = "";
            for (String suppressWarning : suppressWarnings) {
                void var9_13;
                out.printf("%s\"%s\"", var9_13, suppressWarning);
                String string2 = ", ";
            }
            out.printf("})\n", new Object[0]);
        }
        out.printf("        %s result = %s.%s(", GeneratedFoldPlugin.getErasedType(this.intrinsicMethod.getReturnType()), receiver, this.intrinsicMethod.getSimpleName());
        if (argCount > firstArg) {
            void var9_17;
            out.printf("arg%d", firstArg);
            int n = firstArg + 1;
            while (var9_17 < argCount) {
                out.printf(", arg%d", (int)var9_17);
                ++var9_17;
            }
        }
        out.printf(");\n", new Object[0]);
        TypeMirror typeMirror = this.intrinsicMethod.getReturnType();
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                out.printf("        JavaConstant constant = JavaConstant.forInt(result ? 1 : 0);\n", new Object[0]);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: {
                out.printf("        JavaConstant constant = JavaConstant.forInt(result);\n", new Object[0]);
                break;
            }
            case LONG: {
                out.printf("        JavaConstant constant = JavaConstant.forLong(result);\n", new Object[0]);
                break;
            }
            case FLOAT: {
                out.printf("        JavaConstant constant = JavaConstant.forFloat(result);\n", new Object[0]);
                break;
            }
            case DOUBLE: {
                out.printf("        JavaConstant constant = JavaConstant.forDouble(result);\n", new Object[0]);
                break;
            }
            case ARRAY: 
            case TYPEVAR: 
            case DECLARED: {
                if (typeMirror.equals(processor.getType("java.lang.String"))) {
                    out.printf("        JavaConstant constant = %s.forString(result);\n", deps.use(processor, InjectedDependencies.WellKnownDependency.CONSTANT_REFLECTION));
                    break;
                }
                out.printf("        JavaConstant constant = %s.forObject(result);\n", deps.use(processor, InjectedDependencies.WellKnownDependency.SNIPPET_REFLECTION));
                break;
            }
            default: {
                throw new IllegalArgumentException(typeMirror.toString());
            }
        }
        out.printf("        ConstantNode node = ConstantNode.forConstant(constant, %s, %s);\n", deps.use(processor, InjectedDependencies.WellKnownDependency.META_ACCESS), deps.use(processor, InjectedDependencies.WellKnownDependency.STRUCTURED_GRAPH));
        out.printf("        b.push(JavaKind.%s, node);\n", GeneratedFoldPlugin.getReturnKind(this.intrinsicMethod));
        out.printf("        return true;\n", new Object[0]);
        out.printf("    }\n", new Object[0]);
    }
}

