/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.ocsp;

import com.oracle.jipher.pki.internal.ExtensionHelper;
import com.oracle.jipher.pki.internal.Util;
import com.oracle.jipher.pki.ocsp.CertId;
import com.oracle.jipher.pki.ocsp.CertResponse;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class OcspResponse
implements X509Extension {
    X500Principal responderName;
    byte[] responderKeyHash;
    Date producedAt;
    List<X509Certificate> certs;
    Map<String, byte[]> extns;
    Set<String> nonCriticalExtOids;
    Set<String> criticalExtOids;
    List<CertResponse> responses;

    OcspResponse() {
    }

    public CertResponse getResponse(X509Certificate cert, X509Certificate issuer) {
        for (CertResponse response : this.responses) {
            try {
                CertId id = CertId.create(response.certId.hashAlg, cert, issuer);
                if (!response.certId.equals(id)) continue;
                return response;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        return null;
    }

    public Date getProducedAt() {
        return this.producedAt;
    }

    public X500Principal getResponderIdName() {
        return this.responderName;
    }

    public byte[] getResponderIdHash() {
        if (this.responderKeyHash == null) {
            return null;
        }
        return (byte[])this.responderKeyHash.clone();
    }

    public List<X509Certificate> getSigningCerts() {
        if (this.certs == null) {
            return null;
        }
        return Collections.unmodifiableList(this.certs);
    }

    public List<CertResponse> getResponses() {
        return Collections.unmodifiableList(this.responses);
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extns == null) {
            return null;
        }
        byte[] val = this.extns.get(oid);
        if (val == null) {
            return null;
        }
        return (byte[])val.clone();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.criticalExtOids == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.criticalExtOids);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.nonCriticalExtOids == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.nonCriticalExtOids);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.criticalExtOids == null || this.criticalExtOids.isEmpty()) {
            return false;
        }
        return this.criticalExtOids.size() > 1 || !this.criticalExtOids.contains("1.3.6.1.5.5.7.48.1.2");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(System.lineSeparator());
        if (this.responderName != null) {
            sb.append("responderName=").append(this.responderName);
        } else {
            sb.append("responderHash=").append(Util.toHex(this.responderKeyHash));
        }
        sb.append(",").append(System.lineSeparator());
        sb.append("producedAt=").append(this.producedAt).append(",").append(System.lineSeparator());
        sb.append("responses=").append(this.responses).append(System.lineSeparator());
        sb.append("ext=");
        if (this.extns != null) {
            sb.append(ExtensionHelper.extnPrinter(this.extns));
        }
        sb.append(System.lineSeparator());
        sb.append("]");
        return sb.toString();
    }
}

