/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.ClassInclusionPolicy;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.AnyPrimitiveSourceTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisField;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.reports.StatisticsPrinter;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.util.ClassUtil;
import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class PointsToAnalysis
extends AbstractAnalysisEngine {
    private final AnalysisType objectType;
    private final boolean trackPrimitiveValues;
    private final AnalysisType longType;
    private final AnalysisType voidType;
    private final boolean usePredicates;
    private AnyPrimitiveSourceTypeFlow anyPrimitiveSourceTypeFlow;
    protected final boolean trackTypeFlowInputs;
    protected final boolean reportAnalysisStatistics;
    private ConcurrentMap<OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow, Boolean> unsafeLoads;
    private ConcurrentMap<OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow, Boolean> unsafeStores;
    public final AtomicLong numParsedGraphs = new AtomicLong();
    private final CompletionExecutor.Timing timing;
    public final Timer typeFlowTimer;

    public PointsToAnalysis(OptionValues options, AnalysisUniverse universe, HostVM hostVM, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, UnsupportedFeatures unsupportedFeatures, DebugContext debugContext, TimerCollection timerCollection, ClassInclusionPolicy classInclusionPolicy) {
        super(options, universe, hostVM, metaAccess, snippetReflectionProvider, constantReflectionProvider, wordTypes, unsupportedFeatures, debugContext, timerCollection, classInclusionPolicy);
        this.typeFlowTimer = timerCollection.createTimer("(typeflow)");
        this.objectType = metaAccess.lookupJavaType((Class)Object.class);
        this.longType = metaAccess.lookupJavaType((Class)Long.TYPE);
        this.voidType = metaAccess.lookupJavaType((Class)Void.TYPE);
        this.trackPrimitiveValues = (Boolean)PointstoOptions.TrackPrimitiveValues.getValue(options);
        this.usePredicates = (Boolean)PointstoOptions.UsePredicates.getValue(options);
        this.anyPrimitiveSourceTypeFlow = new AnyPrimitiveSourceTypeFlow(null, this.longType);
        this.anyPrimitiveSourceTypeFlow.enableFlow(null);
        this.objectType.getTypeFlow(this, true);
        this.trackTypeFlowInputs = (Boolean)PointstoOptions.TrackInputFlows.getValue(options);
        this.reportAnalysisStatistics = (Boolean)PointstoOptions.PrintPointsToStatistics.getValue(options);
        if (this.reportAnalysisStatistics) {
            PointsToStats.init(this);
        }
        this.unsafeLoads = new ConcurrentHashMap<OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow, Boolean>();
        this.unsafeStores = new ConcurrentHashMap<OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow, Boolean>();
        this.timing = (Boolean)PointstoOptions.ProfileAnalysisOperations.getValue(options) != false ? new AnalysisTiming() : null;
        this.executor.init(this.timing);
    }

    public boolean isClosed(AnalysisType type) {
        if (this.hostVM.isClosedTypeWorld()) {
            return true;
        }
        return type.isArray() || type.isLeaf();
    }

    @Override
    protected CompletionExecutor.Timing getTiming() {
        return this.timing;
    }

    @Override
    public void printTimerStatistics(PrintWriter out) {
        StatisticsPrinter.print(out, "typeflow_time_ms", this.typeFlowTimer.getTotalTime());
        StatisticsPrinter.print(out, "verify_time_ms", this.verifyHeapTimer.getTotalTime());
        StatisticsPrinter.print(out, "features_time_ms", this.processFeaturesTimer.getTotalTime());
        StatisticsPrinter.print(out, "total_analysis_time_ms", this.analysisTimer.getTotalTime());
        StatisticsPrinter.printLast(out, "total_memory_bytes", this.analysisTimer.getTotalMemory());
    }

    public boolean trackTypeFlowInputs() {
        return this.trackTypeFlowInputs;
    }

    public boolean reportAnalysisStatistics() {
        return this.reportAnalysisStatistics;
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        return new MethodTypeFlowBuilder(bb, method, flowsGraph, graphKind);
    }

    public void registerUnsafeLoad(OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow unsafeLoad) {
        this.unsafeLoads.putIfAbsent(unsafeLoad, true);
    }

    public void registerUnsafeStore(OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow unsafeStore) {
        this.unsafeStores.putIfAbsent(unsafeStore, true);
    }

    public void forceUnsafeUpdate(AnalysisField field) {
        for (OffsetLoadTypeFlow.AbstractUnsafeLoadTypeFlow unsafeLoad : this.unsafeLoads.keySet()) {
            unsafeLoad.forceUpdate(this);
            if (!unsafeLoad.receiver().isFlowEnabled()) continue;
            this.postFlow(unsafeLoad.receiver());
        }
        for (OffsetStoreTypeFlow.AbstractUnsafeStoreTypeFlow unsafeStore : this.unsafeStores.keySet()) {
            unsafeStore.forceUpdate(this);
            if (!unsafeStore.receiver().isFlowEnabled()) continue;
            this.postFlow(unsafeStore.receiver());
        }
    }

    @Override
    public void registerAsJNIAccessed(AnalysisField f, boolean writable) {
        PointsToAnalysisField field = (PointsToAnalysisField)f;
        TypeFlow<AnalysisField> declaredTypeFlow = field.getType().getTypeFlow(this, true);
        if (this.isSupportedJavaKind(field.getStorageKind())) {
            if (field.isStatic()) {
                if (field.getStorageKind().isObject()) {
                    declaredTypeFlow.addUse(this, field.getStaticFieldFlow());
                } else {
                    field.saturatePrimitiveField();
                }
            } else {
                FieldTypeFlow instanceFieldFlow = field.getDeclaringClass().getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, writable);
                if (field.getStorageKind().isObject()) {
                    declaredTypeFlow.addUse(this, instanceFieldFlow);
                } else {
                    field.saturatePrimitiveField();
                }
            }
        }
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        return true;
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.anyPrimitiveSourceTypeFlow = null;
        this.unsafeLoads = null;
        this.unsafeStores = null;
        ConstantObjectsProfiler.constantTypes.clear();
    }

    public AnalysisType lookup(JavaType type) {
        return this.universe.lookup(type);
    }

    public AnalysisType getObjectType() {
        return this.universe.objectType();
    }

    public AnalysisType getLongType() {
        return this.longType;
    }

    public AnalysisType getVoidType() {
        return this.voidType;
    }

    public AnalysisType getObjectArrayType() {
        return this.metaAccess.lookupJavaType((Class)Object[].class);
    }

    public TypeFlow<?> getAllInstantiatedTypeFlow() {
        return this.objectType.getTypeFlow(this, true);
    }

    @Override
    public Iterable<AnalysisType> getAllInstantiatedTypes() {
        return this.getAllInstantiatedTypeFlow().getState().types(this);
    }

    public AnyPrimitiveSourceTypeFlow getAnyPrimitiveSourceTypeFlow() {
        return this.anyPrimitiveSourceTypeFlow;
    }

    @Override
    public Iterable<AnalysisType> getAllSynchronizedTypes() {
        return this.getAllInstantiatedTypes();
    }

    @Override
    public AnalysisMethod addRootMethod(Executable method, boolean invokeSpecial, Object reason, MultiMethod.MultiMethodKey ... otherRoots) {
        return this.addRootMethod(this.metaAccess.lookupJavaMethod(method), invokeSpecial, reason, otherRoots);
    }

    @Override
    public AnalysisMethod forcedAddRootMethod(AnalysisMethod method, boolean invokeSpecial, Object reason, MultiMethod.MultiMethodKey ... otherRoots) {
        AnalysisError.guarantee(this.isBaseLayerAnalysisEnabled());
        PointsToAnalysisMethod analysisMethod = PointsToAnalysis.assertPointsToAnalysisMethod(method);
        this.postTask((DebugContext ignore) -> {
            MethodTypeFlow typeFlow = analysisMethod.getTypeFlow();
            typeFlow.ensureFlowsGraphCreated(this, null);
        });
        return this.addRootMethod(analysisMethod, invokeSpecial, reason, otherRoots);
    }

    @Override
    public AnalysisMethod addRootMethod(AnalysisMethod aMethod, boolean invokeSpecial, Object reason, MultiMethod.MultiMethodKey ... otherRoots) {
        assert (!this.universe.sealed()) : "Cannot register root methods after analysis universe is sealed.";
        AnalysisError.guarantee(aMethod.isOriginalMethod());
        boolean isStatic = aMethod.isStatic();
        int paramCount = aMethod.getSignature().getParameterCount(!isStatic);
        PointsToAnalysisMethod originalPTAMethod = PointsToAnalysis.assertPointsToAnalysisMethod(aMethod);
        if (isStatic) {
            Consumer<PointsToAnalysisMethod> triggerStaticMethodFlow = pointsToMethod -> this.postTask(() -> {
                pointsToMethod.registerAsDirectRootMethod(reason);
                pointsToMethod.registerAsImplementationInvoked(reason.toString());
                MethodFlowsGraphInfo flowInfo = this.analysisPolicy.staticRootMethodGraph(this, (PointsToAnalysisMethod)pointsToMethod);
                for (int idx = 0; idx < paramCount; ++idx) {
                    AnalysisType declaredParamType = (AnalysisType)aMethod.getSignature().getParameterType(idx);
                    FormalParamTypeFlow parameter = flowInfo.getParameter(idx);
                    this.processParam(declaredParamType, parameter);
                }
            });
            triggerStaticMethodFlow.accept(originalPTAMethod);
            for (MultiMethod.MultiMethodKey key : otherRoots) {
                assert (key != MultiMethod.ORIGINAL_METHOD) : key;
                PointsToAnalysisMethod ptaMethod = PointsToAnalysis.assertPointsToAnalysisMethod(originalPTAMethod.getMultiMethod(key));
                triggerStaticMethodFlow.accept(ptaMethod);
            }
        } else {
            if (invokeSpecial && originalPTAMethod.isAbstract()) {
                throw AnalysisError.userError("Abstract methods cannot be registered as special invoke entry point.");
            }
            this.postTask(() -> {
                if (invokeSpecial) {
                    originalPTAMethod.registerAsDirectRootMethod(reason);
                } else {
                    originalPTAMethod.registerAsVirtualRootMethod(reason);
                }
                InvokeTypeFlow invoke = originalPTAMethod.initAndGetContextInsensitiveInvoke(this, null, invokeSpecial, MultiMethod.ORIGINAL_METHOD);
                for (int idx = 1; idx < paramCount; ++idx) {
                    AnalysisType declaredParamType = (AnalysisType)aMethod.getSignature().getParameterType(idx - 1);
                    TypeFlow<?> actualParameterFlow = invoke.getActualParameter(idx);
                    this.processParam(declaredParamType, actualParameterFlow);
                }
            });
        }
        return aMethod;
    }

    private void processParam(AnalysisType declaredParamType, TypeFlow<?> actualParameterFlow) {
        if (actualParameterFlow != null && this.isSupportedJavaKind(declaredParamType.getStorageKind())) {
            if (declaredParamType.getStorageKind() == JavaKind.Object) {
                TypeFlow<?> initialParameterFlow = declaredParamType.getTypeFlow(this, true);
                initialParameterFlow.addUse(this, actualParameterFlow);
            } else {
                actualParameterFlow.addState(this, TypeState.anyPrimitiveState());
            }
        }
    }

    public static PointsToAnalysisMethod assertPointsToAnalysisMethod(AnalysisMethod aMethod) {
        assert (aMethod instanceof PointsToAnalysisMethod) : "Only points-to analysis methods are supported";
        return (PointsToAnalysisMethod)aMethod;
    }

    @Override
    public AnalysisType addRootClass(Class<?> clazz, boolean addFields, boolean addArrayClass) {
        ResolvedJavaType type = this.metaAccess.lookupJavaType((Class)clazz);
        return this.addRootClass((AnalysisType)type, addFields, addArrayClass);
    }

    @Override
    public AnalysisType addRootClass(AnalysisType type, boolean addFields, boolean addArrayClass) {
        type.registerAsReachable("root class");
        for (ResolvedJavaField javaField : type.getInstanceFields(false)) {
            AnalysisField field = (AnalysisField)javaField;
            if (addFields) {
                field.registerAsAccessed("field of root class");
            }
            this.processRootField(type, field);
        }
        if (type.getSuperclass() != null) {
            this.addRootClass(type.getSuperclass(), addFields, addArrayClass);
        }
        if (addArrayClass) {
            this.addRootClass(type.getArrayClass(), false, false);
        }
        return type;
    }

    @Override
    public AnalysisType addRootField(Class<?> clazz, String fieldName) {
        AnalysisType type = this.addRootClass(clazz, false, false);
        for (ResolvedJavaField javaField : type.getInstanceFields(true)) {
            AnalysisField field = (AnalysisField)javaField;
            if (!field.getName().equals(fieldName)) continue;
            return this.addRootField(type, field);
        }
        throw JVMCIError.shouldNotReachHere((String)("field not found: " + fieldName));
    }

    @Override
    public AnalysisType addRootField(Field field) {
        AnalysisField analysisField = this.getMetaAccess().lookupJavaField(field);
        if (analysisField.isStatic()) {
            return this.addRootStaticField(analysisField);
        }
        ResolvedJavaType analysisType = this.getMetaAccess().lookupJavaType((Class)field.getDeclaringClass());
        return this.addRootField((AnalysisType)analysisType, analysisField);
    }

    private AnalysisType addRootField(AnalysisType type, AnalysisField field) {
        field.registerAsAccessed("root field");
        this.processRootField(type, field);
        return field.getType();
    }

    private void processRootField(AnalysisType type, AnalysisField field) {
        JavaKind storageKind = field.getStorageKind();
        if (this.isSupportedJavaKind(storageKind)) {
            FieldTypeFlow fieldFlow = type.getContextInsensitiveAnalysisObject().getInstanceFieldFlow(this, field, true);
            if (storageKind.isObject()) {
                TypeFlow<AnalysisField> fieldDeclaredTypeFlow = field.getType().getTypeFlow(this, true);
                fieldDeclaredTypeFlow.addUse(this, fieldFlow);
            } else {
                fieldFlow.addState(this, TypeState.anyPrimitiveState());
            }
        }
    }

    public AnalysisType addRootStaticField(Class<?> clazz, String fieldName) {
        this.addRootClass(clazz, false, false);
        try {
            Field reflectField = clazz.getField(fieldName);
            AnalysisField field = this.metaAccess.lookupJavaField(reflectField);
            return this.addRootStaticField(field);
        }
        catch (NoSuchFieldException e) {
            throw JVMCIError.shouldNotReachHere((String)("field not found: " + fieldName));
        }
    }

    private AnalysisType addRootStaticField(AnalysisField field) {
        field.registerAsAccessed("static root field");
        JavaKind storageKind = field.getStorageKind();
        if (this.isSupportedJavaKind(storageKind)) {
            if (storageKind.isObject()) {
                TypeFlow<AnalysisField> fieldFlow = field.getType().getTypeFlow(this, true);
                fieldFlow.addUse(this, field.getStaticFieldFlow());
            } else {
                field.getStaticFieldFlow().addState(this, TypeState.anyPrimitiveState());
            }
        }
        return field.getType();
    }

    @Override
    public void checkUserLimitations() {
    }

    public boolean isSupportedJavaKind(JavaKind javaKind) {
        return javaKind == JavaKind.Object || this.trackPrimitiveValues && javaKind.isNumericInteger();
    }

    @Override
    public boolean trackPrimitiveValues() {
        return this.trackPrimitiveValues;
    }

    public boolean usePredicates() {
        return this.usePredicates;
    }

    public void postFlow(final TypeFlow<?> operation) {
        assert (operation.isFlowEnabled()) : "Only enabled flows should be updated: " + String.valueOf(operation);
        if (operation.inQueue) {
            return;
        }
        operation.inQueue = true;
        this.executor.execute(new TypeFlowRunnable(){
            final /* synthetic */ PointsToAnalysis this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(DebugContext ignored) {
                PointsToStats.registerTypeFlowQueuedUpdate(this.this$0, operation);
                operation.inQueue = false;
                if (operation.isValid()) {
                    operation.update(this.this$0);
                }
            }

            public String toString() {
                return "Operation: " + String.valueOf(operation);
            }

            @Override
            public TypeFlow<?> getTypeFlow() {
                return operation;
            }
        });
    }

    @Override
    public boolean finish() throws InterruptedException {
        try (Indent indent = this.debug.logAndIndent("starting analysis in BigBang.finish");){
            boolean didSomeWork = false;
            do {
                didSomeWork |= this.doTypeflow();
                assert (this.executor.getPostedOperations() == 0L) : this.executor.getPostedOperations();
                this.universe.runAtFixedPoint();
            } while (this.executor.getPostedOperations() > 0L);
            boolean bl = didSomeWork;
            return bl;
        }
    }

    public boolean doTypeflow() throws InterruptedException {
        boolean didSomeWork;
        try (Timer.StopTimer ignored = this.typeFlowTimer.start();){
            this.executor.start();
            this.executor.complete();
            didSomeWork = this.executor.getPostedOperations() > 0L;
            this.executor.shutdown();
        }
        this.executor.init(this.timing);
        return didSomeWork;
    }

    @Override
    public void onTypeInstantiated(AnalysisType type) {
        assert (type.isInstantiated()) : type;
        AnalysisError.guarantee(type.isArray() || type.isInstanceClass() && !type.isAbstract());
        SingleTypeState typeState = TypeState.forExactType(this, type, true);
        SingleTypeState typeStateNonNull = TypeState.forExactType(this, type, false);
        type.forAllSuperTypes(t -> {
            t.instantiatedTypes.addState(this, typeState);
            t.instantiatedTypesNonNull.addState(this, typeStateNonNull);
        });
    }

    protected class AnalysisTiming
    extends BucketTiming {
        protected AnalysisTiming() {
        }

        @Override
        public void printHeader() {
            System.out.format("%5s %5s %5s  |", "graphs", "types", "nid");
            super.printHeader();
            System.out.println();
        }

        @Override
        public void print() {
            System.out.format("%5d %5d %5d  |", PointsToAnalysis.this.numParsedGraphs.get(), StreamSupport.stream(PointsToAnalysis.this.getAllInstantiatedTypes().spliterator(), false).count(), PointsToAnalysis.this.universe.getNextTypeId());
            super.print();
            System.out.println();
        }
    }

    public static class ConstantObjectsProfiler {
        static final ConcurrentHashMap<AnalysisType, MyInteger> constantTypes = new ConcurrentHashMap(2000);
        static final int PROCESSED_CONSTANTS_DUMP_THRESHOLD = 100000;
        static final int CONSTANT_COUNTER_DUMP_THRESHOLD = 1000;
        static int processedConstants;
        static final ConstantCounterEntryComparator CONSTANT_COUNTER_COMPARATOR;

        public static void registerConstant(AnalysisType type) {
            ++processedConstants;
            MyInteger counter = constantTypes.get(type);
            if (counter == null) {
                MyInteger newValue = new MyInteger();
                MyInteger oldValue = constantTypes.putIfAbsent(type, newValue);
                counter = oldValue != null ? oldValue : newValue;
            }
            counter.increment();
        }

        public static void maybeDumpConstantHistogram() {
            if (processedConstants > 100000) {
                processedConstants = 0;
                ArrayList<ConstantCounterEntry> constantCounters = new ArrayList<ConstantCounterEntry>();
                for (Map.Entry<AnalysisType, MyInteger> entry : constantTypes.entrySet()) {
                    AnalysisType type = entry.getKey();
                    Integer counter = entry.getValue().value();
                    if (counter <= 1000) continue;
                    constantCounters.add(new ConstantCounterEntry(type, counter));
                }
                Collections.sort(constantCounters, CONSTANT_COUNTER_COMPARATOR);
                System.out.println(" - - - - - - - - - - - - - - - - - - - - - - - -  ");
                System.out.println("              CONSTANT HISTOGRAM                  ");
                for (ConstantCounterEntry constantCounter : constantCounters) {
                    System.out.format("%d : %s %n", constantCounter.counter, constantCounter.type.getName());
                }
                System.out.println(" - - - - - - - - - - - - - - - - - - - - - - - -  ");
            }
        }

        static {
            CONSTANT_COUNTER_COMPARATOR = new ConstantCounterEntryComparator();
        }

        static class MyInteger {
            int myInt = 0;

            MyInteger() {
            }

            protected void increment() {
                ++this.myInt;
            }

            protected int value() {
                return this.myInt;
            }

            public String toString() {
                return "" + this.myInt;
            }
        }

        static class ConstantCounterEntry {
            protected AnalysisType type;
            protected int counter;

            ConstantCounterEntry(AnalysisType type, int counter) {
                this.type = type;
                this.counter = counter;
            }
        }

        static class ConstantCounterEntryComparator
        implements Comparator<ConstantCounterEntry> {
            ConstantCounterEntryComparator() {
            }

            @Override
            public int compare(ConstantCounterEntry o1, ConstantCounterEntry o2) {
                return Integer.compare(o2.counter, o1.counter);
            }
        }
    }

    protected static abstract class BucketTiming
    implements CompletionExecutor.Timing {
        private static final int NUM_BUCKETS = 10;
        private final AtomicLong numOperations = new AtomicLong();
        private final AtomicLong numAdded = new AtomicLong();
        private final AtomicLong numDone = new AtomicLong();
        private final AtomicLong numInQueue = new AtomicLong();
        private final AtomicLong totalTime = new AtomicLong();
        private final AtomicLongArray timeBuckets = new AtomicLongArray(10);

        protected BucketTiming() {
        }

        @Override
        public long getPrintIntervalNanos() {
            return 1000000000L;
        }

        @Override
        public void addScheduled(CompletionExecutor.DebugContextRunnable r) {
            this.numOperations.incrementAndGet();
            this.numInQueue.incrementAndGet();
            this.numAdded.incrementAndGet();
        }

        @Override
        public void addCompleted(CompletionExecutor.DebugContextRunnable r, long nanos) {
            this.numInQueue.decrementAndGet();
            this.numDone.incrementAndGet();
            this.totalTime.addAndGet(nanos);
            int bucket = 0;
            for (long bucketTime = nanos / 1000L; bucketTime != 0L && bucket < 9; bucketTime /= 10L, ++bucket) {
            }
            this.timeBuckets.incrementAndGet(bucket);
            if (nanos > 500000000L && r instanceof TypeFlowRunnable) {
                TypeFlow<?> tf = ((TypeFlowRunnable)r).getTypeFlow();
                String source = String.valueOf(tf.getSource());
                System.out.format("LONG RUNNING  %.2f  %s %x %s  state %s %x  uses %d observers %d%n", (double)nanos / 1.0E9, ClassUtil.getUnqualifiedName(tf.getClass()), System.identityHashCode(tf), source, PointsToStats.asString(tf.getRawState()), System.identityHashCode(tf.getRawState()), tf.getUses().size(), tf.getObservers().size());
            }
        }

        @Override
        public void printHeader() {
            System.out.format("%9s %6s %6s %6s %10s %8s  %5s %5s %5s %5s %5s %5s %5s %5s %5s %5s  |", "total", "qlen", "added", "done", "total us", "avg us", "<1us", ">1us", "10", "100", ">1ms", "10", "100", ">1s", "10", "100");
        }

        @Override
        public void print() {
            int i;
            long operations = this.numOperations.get();
            long queued = this.numInQueue.get();
            long scheduled = this.numAdded.getAndSet(0L);
            long completed = this.numDone.getAndSet(0L);
            long time = this.totalTime.getAndSet(0L);
            long[] buckets = new long[10];
            for (i = 0; i < 10; ++i) {
                buckets[i] = this.timeBuckets.getAndSet(i, 0L);
            }
            System.out.format("%9d %6d %6d %6d %10d %8d  ", operations, queued, scheduled, completed, time / 1000L, completed != 0L ? time / 1000L / completed : 0L);
            for (i = 0; i < 10; ++i) {
                System.out.format("%5d ", buckets[i]);
            }
            System.out.print(" |");
        }
    }

    public static interface TypeFlowRunnable
    extends CompletionExecutor.DebugContextRunnable {
        public TypeFlow<?> getTypeFlow();
    }
}

