/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.aotjs.api;

import org.graalvm.aotjs.api.JS;
import org.graalvm.aotjs.api.JSValue;

public final class JSBoolean
extends JSValue {
    JSBoolean() {
    }

    @JS(value="return true;")
    private static native JSBoolean createTrue();

    @JS(value="return false;")
    private static native JSBoolean createFalse();

    public static JSBoolean of(boolean b) {
        return b ? JSBoolean.createTrue() : JSBoolean.createFalse();
    }

    @Override
    public String typeof() {
        return "boolean";
    }

    @JS(value="return toProxy(createJavaBoolean(this));")
    private native Boolean javaBoolean();

    @Override
    protected String stringValue() {
        return String.valueOf(this.javaBoolean());
    }

    @Override
    public Boolean asBoolean() {
        return this.javaBoolean();
    }

    public boolean equals(Object that) {
        if (that instanceof JSBoolean) {
            return this.javaBoolean().equals(((JSBoolean)that).javaBoolean());
        }
        return false;
    }

    public int hashCode() {
        return this.javaBoolean().hashCode();
    }
}

