/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.google.common.jimfs;

import org.graalvm.shadowed.com.google.common.collect.ImmutableMap;
import org.graalvm.shadowed.com.google.common.jimfs.AclAttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.AttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.BasicAttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.DosAttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.OwnerAttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.PosixAttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.UnixAttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.UserDefinedAttributeProvider;
import org.jspecify.annotations.Nullable;

final class StandardAttributeProviders {
    private static final ImmutableMap<String, AttributeProvider> PROVIDERS = new ImmutableMap.Builder().put((Object)"basic", (Object)new BasicAttributeProvider()).put((Object)"owner", (Object)new OwnerAttributeProvider()).put((Object)"posix", (Object)new PosixAttributeProvider()).put((Object)"dos", (Object)new DosAttributeProvider()).put((Object)"acl", (Object)new AclAttributeProvider()).put((Object)"user", (Object)new UserDefinedAttributeProvider()).build();

    private StandardAttributeProviders() {
    }

    public static @Nullable AttributeProvider get(String view) {
        AttributeProvider provider = (AttributeProvider)PROVIDERS.get((Object)view);
        if (provider == null && view.equals("unix")) {
            return new UnixAttributeProvider();
        }
        return provider;
    }
}

