/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.google.common.jimfs;

import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.util.Objects;
import org.graalvm.shadowed.com.google.common.base.MoreObjects;
import org.graalvm.shadowed.com.google.common.base.Preconditions;
import org.graalvm.shadowed.com.google.common.jimfs.Directory;
import org.graalvm.shadowed.com.google.common.jimfs.File;
import org.graalvm.shadowed.com.google.common.jimfs.Name;
import org.graalvm.shadowed.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jspecify.annotations.Nullable;

final class DirectoryEntry {
    private final Directory directory;
    private final Name name;
    private final @Nullable File file;
    @Nullable DirectoryEntry next;

    DirectoryEntry(Directory directory, Name name, @Nullable File file) {
        this.directory = (Directory)Preconditions.checkNotNull((Object)directory);
        this.name = (Name)Preconditions.checkNotNull((Object)name);
        this.file = file;
    }

    public boolean exists() {
        return this.file != null;
    }

    @CanIgnoreReturnValue
    public DirectoryEntry requireExists(Path pathForException) throws NoSuchFileException {
        if (!this.exists()) {
            throw new NoSuchFileException(pathForException.toString());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public DirectoryEntry requireDoesNotExist(Path pathForException) throws FileAlreadyExistsException {
        if (this.exists()) {
            throw new FileAlreadyExistsException(pathForException.toString());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public DirectoryEntry requireDirectory(Path pathForException) throws NoSuchFileException, NotDirectoryException {
        this.requireExists(pathForException);
        if (!this.file().isDirectory()) {
            throw new NotDirectoryException(pathForException.toString());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public DirectoryEntry requireSymbolicLink(Path pathForException) throws NoSuchFileException, NotLinkException {
        this.requireExists(pathForException);
        if (!this.file().isSymbolicLink()) {
            throw new NotLinkException(pathForException.toString());
        }
        return this;
    }

    public Directory directory() {
        return this.directory;
    }

    public Name name() {
        return this.name;
    }

    public File file() {
        Preconditions.checkState((boolean)this.exists());
        return this.file;
    }

    public @Nullable File fileOrNull() {
        return this.file;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectoryEntry) {
            DirectoryEntry other = (DirectoryEntry)obj;
            return this.directory.equals(other.directory) && this.name.equals(other.name) && Objects.equals(this.file, other.file);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.name, this.file);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directory", (Object)this.directory).add("name", (Object)this.name).add("file", (Object)this.file).toString();
    }
}

