/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sq extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_lo = "laosisht";
        final String metaValue_mak = "makasarisht";
        final String metaValue_mn = "mongolisht";
        final String metaValue_bo = "tibetisht";
        final Object[][] data = new Object[][] {
            { "001", "Bota" },
            { "002", "Afrik\u00eb" },
            { "003", "Amerika e Veriut" },
            { "005", "Amerika e Jugut" },
            { "009", "Oqeani" },
            { "011", "Afrika Per\u00ebndimore" },
            { "013", "Amerika Qendrore" },
            { "014", "Afrika Lindore" },
            { "015", "Afrika Veriore" },
            { "017", "Afrika e Mesme" },
            { "018", "Afrika Jugore" },
            { "019", "Amerik\u00eb" },
            { "021", "Amerika Veriore" },
            { "029", "Karaibe" },
            { "030", "Azia Lindore" },
            { "034", "Azia Jugore" },
            { "035", "Azia Juglindore" },
            { "039", "Evropa Jugore" },
            { "053", "Australazia" },
            { "054", "Melanezia" },
            { "057", "Rajoni Mikronezian" },
            { "061", "Polinezia" },
            { "142", "Azi" },
            { "143", "Azia Qendrore" },
            { "145", "Azia Per\u00ebndimore" },
            { "150", "Evrop\u00eb" },
            { "151", "Evropa Lindore" },
            { "154", "Evropa Veriore" },
            { "155", "Evropa Per\u00ebndimore" },
            { "202", "Afrika Subsahariane" },
            { "419", "Amerika Latine" },
            { "AC", "Ishulli Asenshion" },
            { "AD", "Andorr\u00eb" },
            { "AE", "Emiratet e Bashkuara Arabe" },
            { "AF", "Afganistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguil\u00eb" },
            { "AL", "Shqip\u00ebri" },
            { "AM", "Armeni" },
            { "AO", "Angol\u00eb" },
            { "AQ", "Antarktik\u00eb" },
            { "AR", "Argjentin\u00eb" },
            { "AS", "Samoa Amerikane" },
            { "AT", "Austri" },
            { "AU", "Australi" },
            { "AW", "Arub\u00eb" },
            { "AX", "Ishujt Aland\u00eb" },
            { "AZ", "Azerbajxhan" },
            { "BA", "Bosnj\u00eb-Hercegovin\u00eb" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgjik\u00eb" },
            { "BF", "Burkina-Faso" },
            { "BG", "Bullgari" },
            { "BH", "Bahrejn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sen-Bartelemi" },
            { "BM", "Bermude" },
            { "BN", "Brunei" },
            { "BO", "Bolivi" },
            { "BQ", "Karaibet holandeze" },
            { "BR", "Brazil" },
            { "BS", "Bahama" },
            { "BT", "Butan" },
            { "BV", "Ishulli Bove" },
            { "BW", "Botsvan\u00eb" },
            { "BY", "Bjellorusi" },
            { "BZ", "Beliz\u00eb" },
            { "CA", "Kanada" },
            { "CC", "Ishujt Kokos" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Republika e Afrik\u00ebs Qendrore" },
            { "CG", "Kongo-Brazavil\u00eb" },
            { "CH", "Zvic\u00ebr" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Ishujt Kuk" },
            { "CL", "Kili" },
            { "CM", "Kamerun" },
            { "CN", "Kin\u00eb" },
            { "CO", "Kolumbi" },
            { "CP", "Ishulli Klip\u00ebrton" },
            { "CR", "Kosta-Rik\u00eb" },
            { "CU", "Kub\u00eb" },
            { "CV", "Kepi i Gjelb\u00ebr" },
            { "CW", "Kurasao" },
            { "CX", "Ishulli i Krishtlindjes" },
            { "CY", "Qipro" },
            { "CZ", "\u00c7eki" },
            { "DE", "Gjermani" },
            { "DG", "Diego-Garsia" },
            { "DJ", "Xhibuti" },
            { "DK", "Danimark\u00eb" },
            { "DM", "Dominik\u00eb" },
            { "DO", "Republika Dominikane" },
            { "DZ", "Algjeri" },
            { "EA", "Theuta e Melila" },
            { "EC", "Ekuador" },
            { "EE", "Estoni" },
            { "EG", "Egjipt" },
            { "EH", "Saharaja Per\u00ebndimore" },
            { "ER", "Eritre" },
            { "ES", "Spanj\u00eb" },
            { "ET", "Etiopi" },
            { "EU", "Bashkimi Evropian" },
            { "EZ", "Zona euro" },
            { "FI", "Finland\u00eb" },
            { "FJ", "Fixhi" },
            { "FK", "Ishujt Falkland" },
            { "FM", "Mikronezi" },
            { "FO", "Ishujt Faroe" },
            { "FR", "Franc\u00eb" },
            { "GA", "Gabon" },
            { "GB", "Mbret\u00ebria e Bashkuar" },
            { "GD", "Granad\u00eb" },
            { "GE", "Gjeorgji" },
            { "GF", "Guajana Franceze" },
            { "GG", "Gernsej" },
            { "GH", "Gan\u00eb" },
            { "GI", "Gjibraltar" },
            { "GL", "Gr\u00ebnland\u00eb" },
            { "GM", "Gambi" },
            { "GN", "Guine" },
            { "GP", "Guadelup\u00eb" },
            { "GQ", "Guineja Ekuatoriale" },
            { "GR", "Greqi" },
            { "GS", "Xhorxha Jugore dhe Ishujt Sendui\u00e7\u00eb t\u00eb Jugut" },
            { "GT", "Guatemal\u00eb" },
            { "GU", "Guam" },
            { "GW", "Guine-Bisau" },
            { "GY", "Guajan\u00eb" },
            { "HK", "RPA i Hong-Kongut" },
            { "HM", "Ishujt H\u00ebrd e Mekdonald" },
            { "HN", "Honduras" },
            { "HR", "Kroaci" },
            { "HT", "Haiti" },
            { "HU", "Hungari" },
            { "IC", "Ishujt Kanarie" },
            { "ID", "Indonezi" },
            { "IE", "Irland\u00eb" },
            { "IL", "Izrael" },
            { "IM", "Ishulli i Manit" },
            { "IN", "Indi" },
            { "IO", "Territori Britanik i Oqeanit Indian" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island\u00eb" },
            { "IT", "Itali" },
            { "JE", "Xhersej" },
            { "JM", "Xhamajk\u00eb" },
            { "JO", "Jordani" },
            { "JP", "Japoni" },
            { "KE", "Kenia" },
            { "KG", "Kirgizi" },
            { "KH", "Kamboxhia" },
            { "KI", "Kiribati" },
            { "KM", "Komore" },
            { "KN", "Sh\u00ebn-Kits dhe Nevis" },
            { "KP", "Kore e Veriut" },
            { "KR", "Kore e Jugut" },
            { "KW", "Kuvajt" },
            { "KY", "Ishujt Kajman" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sh\u00ebn-Lu\u00e7ia" },
            { "LI", "Lihtenshtajn" },
            { "LK", "Sri-Lank\u00eb" },
            { "LR", "Liberi" },
            { "LS", "Lesoto" },
            { "LT", "Lituani" },
            { "LU", "Luksemburg" },
            { "LV", "Letoni" },
            { "LY", "Libi" },
            { "MA", "Marok" },
            { "MC", "Monako" },
            { "MD", "Moldavi" },
            { "ME", "Mal i Zi" },
            { "MF", "Sen-Marten" },
            { "MG", "Madagaskar" },
            { "MH", "Ishujt Marshall" },
            { "MK", "Maqedonia e Veriut" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Burm\u00eb)" },
            { "MN", "Mongoli" },
            { "MO", "RPA i Makaos" },
            { "MP", "Ishujt e Marian\u00ebs Veriore" },
            { "MQ", "Martinik\u00eb" },
            { "MR", "Mauritani" },
            { "MS", "Montserat" },
            { "MT", "Malt\u00eb" },
            { "MU", "Mauritius" },
            { "MV", "Maldive" },
            { "MW", "Malavi" },
            { "MX", "Meksik\u00eb" },
            { "MY", "Malajzi" },
            { "MZ", "Mozambik" },
            { "NA", "Namibi" },
            { "NC", "Kaledoni e Re" },
            { "NE", "Niger" },
            { "NF", "Ishulli Norfolk" },
            { "NG", "Nigeri" },
            { "NI", "Nikaragua" },
            { "NL", "Holand\u00eb" },
            { "NO", "Norvegji" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Zeland\u00eb e Re" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinezia Franceze" },
            { "PG", "Guineja e Re-Papua" },
            { "PH", "Filipine" },
            { "PK", "Pakistan" },
            { "PL", "Poloni" },
            { "PM", "Sh\u00ebn-Pier dhe Mikelon" },
            { "PN", "Ishujt Pitkern" },
            { "PR", "Porto-Riko" },
            { "PS", "Territoret Palestineze" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "Oqeania e Larg\u00ebt (Lindja e Larg\u00ebt)" },
            { "RE", "Reunion" },
            { "RO", "Rumani" },
            { "RS", "Serbi" },
            { "RU", "Rusi" },
            { "RW", "Ruand\u00eb" },
            { "SA", "Arabi Saudite" },
            { "SB", "Ishujt Solomon" },
            { "SC", "Sejshelle" },
            { "SD", "Sudan" },
            { "SE", "Suedi" },
            { "SG", "Singapor" },
            { "SH", "Sh\u00ebn-Elen\u00eb" },
            { "SI", "Slloveni" },
            { "SJ", "Svalbard e Jan-Majen" },
            { "SK", "Sllovaki" },
            { "SL", "Sierra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "SR", "Surinami" },
            { "SS", "Sudani i Jugut" },
            { "ST", "Sao-Tome e Principe" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Siri" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan-da-Kuna" },
            { "TC", "Ishujt Turks dhe Kaikos" },
            { "TD", "\u00c7ad" },
            { "TF", "Territoret Jugore Franceze" },
            { "TG", "Togo" },
            { "TH", "Tajland\u00eb" },
            { "TJ", "Taxhikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunizi" },
            { "TO", "Tonga" },
            { "TR", "Turqi" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "TZ", "Tanzani" },
            { "UA", "Ukrain\u00eb" },
            { "UG", "Ugand\u00eb" },
            { "UM", "Ishujt Periferik\u00eb t\u00eb SHBA-s\u00eb" },
            { "UN", "Organizata e Kombeve t\u00eb Bashkuara" },
            { "US", "SHBA" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Sh\u00ebn-Vincent dhe Grenadine" },
            { "VE", "Venezuel\u00eb" },
            { "VG", "Ishujt e Virgj\u00ebr Britanik\u00eb" },
            { "VI", "Ishujt e Virgj\u00ebr t\u00eb SHBA-s\u00eb" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Uollis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-thekse" },
            { "XB", "Pseudo-bidi" },
            { "XK", "Kosov\u00eb" },
            { "YE", "Jemen" },
            { "YT", "Majot\u00eb" },
            { "ZA", "Afrika e Jugut" },
            { "ZM", "Zambi" },
            { "ZW", "Zimbabve" },
            { "ZZ", "I panjohur" },
            { "aa", "afarisht" },
            { "ab", "abkazisht" },
            { "af", "afrikanisht" },
            { "ak", "akanisht" },
            { "am", "amarisht" },
            { "an", "aragonezisht" },
            { "ar", "arabisht" },
            { "as", "asamezisht" },
            { "av", "avarikisht" },
            { "ay", "ajmarisht" },
            { "az", "azerbajxhanisht" },
            { "ba", "bashkirisht" },
            { "be", "bjellorusisht" },
            { "bg", "bullgarisht" },
            { "bi", "bislamisht" },
            { "bm", "bambarisht" },
            { "bn", "bengalisht" },
            { "bo", metaValue_bo },
            { "br", "bretonisht" },
            { "bs", "boshnjakisht" },
            { "ca", "katalonisht" },
            { "ce", "\u00e7e\u00e7enisht" },
            { "ch", "kamoroisht" },
            { "co", "korsikisht" },
            { "cs", "\u00e7ekisht" },
            { "cu", "sllavishte kishtare" },
            { "cv", "\u00e7uvashisht" },
            { "cy", "uellsisht" },
            { "da", "danisht" },
            { "de", "gjermanisht" },
            { "dv", "divehisht" },
            { "dz", "xhongaisht" },
            { "ee", "eveisht" },
            { "el", "greqisht" },
            { "en", "anglisht" },
            { "eo", "esperanto" },
            { "es", "spanjisht" },
            { "et", "estonisht" },
            { "eu", "baskisht" },
            { "fa", "persisht" },
            { "ff", "fulaisht" },
            { "fi", "finlandisht" },
            { "fj", "fixhianisht" },
            { "fo", "faroisht" },
            { "fr", "fr\u00ebngjisht" },
            { "fy", "frizianishte per\u00ebndimore" },
            { "ga", "irlandisht" },
            { "gd", "galishte skoceze" },
            { "gl", "galicisht" },
            { "gn", "guaranisht" },
            { "gu", "guxharatisht" },
            { "gv", "manksisht" },
            { "ha", "hausisht" },
            { "he", "hebraisht" },
            { "hi", "indisht" },
            { "hr", "kroatisht" },
            { "ht", "kreolishte e Haitit" },
            { "hu", "hungarisht" },
            { "hy", "armenisht" },
            { "hz", "hereroisht" },
            { "ia", "interlingua" },
            { "id", "indonezisht" },
            { "ie", "gjuha oksidentale" },
            { "ig", "igboisht" },
            { "ii", "sishuanisht" },
            { "io", "idoisht" },
            { "is", "islandisht" },
            { "it", "italisht" },
            { "iu", "inuktitutisht" },
            { "ja", "japonisht" },
            { "jv", "javanisht" },
            { "ka", "gjeorgjisht" },
            { "ki", "kikujuisht" },
            { "kj", "kuanjamaisht" },
            { "kk", "kazakisht" },
            { "kl", "kalalisutisht" },
            { "km", "kmerisht" },
            { "kn", "kanadisht" },
            { "ko", "koreanisht" },
            { "kr", "kanurisht" },
            { "ks", "kashmirisht" },
            { "ku", "kurdisht" },
            { "kv", "komisht" },
            { "kw", "kornisht" },
            { "ky", "kirgizisht" },
            { "la", "latinisht" },
            { "lb", "luksemburgisht" },
            { "lg", "gandaisht" },
            { "li", "limburgisht" },
            { "ln", "lingalisht" },
            { "lo", metaValue_lo },
            { "lt", "lituanisht" },
            { "lu", "luba-katangaisht" },
            { "lv", "letonisht" },
            { "mg", "madagaskarisht" },
            { "mh", "marshallisht" },
            { "mi", "maorisht" },
            { "mk", "maqedonisht" },
            { "ml", "malajalamisht" },
            { "mn", metaValue_mn },
            { "mr", "maratisht" },
            { "ms", "malajisht" },
            { "mt", "maltisht" },
            { "my", "birmanisht" },
            { "na", "nauruisht" },
            { "nb", "norvegjishte letrare" },
            { "nd", "ndebelishte veriore" },
            { "ne", "nepalisht" },
            { "ng", "ndongaisht" },
            { "nl", "holandisht" },
            { "nn", "norvegjishte nynorsk" },
            { "no", "norvegjisht" },
            { "nr", "ndebelishte jugore" },
            { "nv", "navahoisht" },
            { "ny", "nianjisht" },
            { "oc", "oksitanisht" },
            { "om", "oromoisht" },
            { "or", "odisht" },
            { "os", "osetisht" },
            { "pa", "punxhabisht" },
            { "pl", "polonisht" },
            { "ps", "pashtoisht" },
            { "pt", "portugalisht" },
            { "qu", "ke\u00e7uaisht" },
            { "rm", "retoromanisht" },
            { "rn", "rundisht" },
            { "ro", "rumanisht" },
            { "ru", "rusisht" },
            { "rw", "kiniaruandisht" },
            { "sa", "sanskritisht" },
            { "sc", "sardenjisht" },
            { "sd", "sindisht" },
            { "se", "samishte veriore" },
            { "sg", "sangoisht" },
            { "sh", "serbo-kroatisht" },
            { "si", "sinhalisht" },
            { "sk", "sllovakisht" },
            { "sl", "sllovenisht" },
            { "sm", "samoanisht" },
            { "sn", "shonisht" },
            { "so", "somalisht" },
            { "sq", "shqip" },
            { "sr", "serbisht" },
            { "ss", "suatisht" },
            { "st", "sotoishte jugore" },
            { "su", "sundanisht" },
            { "sv", "suedisht" },
            { "sw", "suahilisht" },
            { "ta", "tamilisht" },
            { "te", "teluguisht" },
            { "tg", "taxhikisht" },
            { "th", "tajlandisht" },
            { "ti", "tigrinjaisht" },
            { "tk", "turkmenisht" },
            { "tn", "cuanaisht" },
            { "to", "tonganisht" },
            { "tr", "turqisht" },
            { "ts", "congaisht" },
            { "tt", "tatarisht" },
            { "tw", "tuisht" },
            { "ty", "tahitisht" },
            { "ug", "ujgurisht" },
            { "uk", "ukrainisht" },
            { "ur", "urduisht" },
            { "uz", "uzbekisht" },
            { "ve", "vendaisht" },
            { "vi", "vietnamisht" },
            { "vo", "volapykisht" },
            { "wa", "ualunisht" },
            { "wo", "uolofisht" },
            { "xh", "xhosaisht" },
            { "yi", "jidisht" },
            { "yo", "jorubaisht" },
            { "za", "zhuangisht" },
            { "zh", "kinezisht" },
            { "zu", "zuluisht" },
            { "ace", "akinezisht" },
            { "ada", "andangmeisht" },
            { "ady", "adigisht" },
            { "agq", "agemisht" },
            { "ain", "ajnuisht" },
            { "ale", "aleutisht" },
            { "alt", "altaishte jugore" },
            { "ann", "oboloisht" },
            { "anp", "angikisht" },
            { "arn", "mapu\u00e7isht" },
            { "arp", "arapahoisht" },
            { "ars", "arabishte naxhdi" },
            { "asa", "asuisht" },
            { "ast", "asturisht" },
            { "atj", "atikamekisht" },
            { "awa", "auadhisht" },
            { "ban", "balinezisht" },
            { "bas", "basaisht" },
            { "bem", "bembaisht" },
            { "bez", "benaisht" },
            { "bgc", "harjanvisht" },
            { "bgn", "balokishte per\u00ebndimore" },
            { "bho", "boxhpurisht" },
            { "bin", "binisht" },
            { "bla", "siksikaisht" },
            { "blo", "anisht" },
            { "brx", "bodoisht" },
            { "bug", "buginezisht" },
            { "byn", "blinisht" },
            { "cay", "kajugaisht" },
            { "ccp", "\u00e7akmaisht" },
            { "ceb", "sebuanisht" },
            { "cgg", "\u00e7igisht" },
            { "chk", "\u00e7ukezisht" },
            { "chm", "marisht" },
            { "cho", "\u00e7oktauisht" },
            { "chp", "\u00e7ipeuajanisht" },
            { "chr", "\u00e7erokisht" },
            { "chy", "\u00e7ejenisht" },
            { "ckb", "kurdishte qendrore" },
            { "clc", "\u00e7ilkotinisht" },
            { "crg", "mi\u00e7ifisht" },
            { "crj", "krijishte juglindore" },
            { "crk", "krijishte fusharake" },
            { "crl", "krijishte verilindore" },
            { "crm", "krijishte e Muzit" },
            { "crr", "algonkuianishte e Karolin\u00ebs" },
            { "crs", "fr\u00ebngjishte kreole seselve" },
            { "csw", "krijishte e mo\u00e7aleve (Ontario)" },
            { "dak", "dakotisht" },
            { "dar", "darguaisht" },
            { "dav", "tajtaisht" },
            { "dgr", "dogribisht" },
            { "dje", "zarmaisht" },
            { "doi", "dogrisht" },
            { "dsb", "sorbishte e poshtme" },
            { "dua", "dualaisht" },
            { "dyo", "xhulafonjisht" },
            { "dzg", "dazagauisht" },
            { "ebu", "embuisht" },
            { "efi", "efikisht" },
            { "eka", "ekajukisht" },
            { "ewo", "euondoisht" },
            { "fil", "filipinisht" },
            { "fon", "fonisht" },
            { "frc", "fr\u00ebngjishte kajune" },
            { "frr", "frisianishte veriore" },
            { "fur", "friulianisht" },
            { "gaa", "gaisht" },
            { "gag", "gagauzisht" },
            { "gez", "gizisht" },
            { "gil", "gilbertazisht" },
            { "gor", "gorontaloisht" },
            { "gsw", "gjermanishte zvicerane" },
            { "guz", "gusisht" },
            { "gwi", "gui\u00e7inisht" },
            { "hai", "haidaisht" },
            { "haw", "havaisht" },
            { "hax", "haidaishte jugore" },
            { "hil", "hiligajnonisht" },
            { "hmn", "hmongisht" },
            { "hsb", "sorbishte e sip\u00ebrme" },
            { "hup", "hupaisht" },
            { "hur", "halkemejlemisht" },
            { "iba", "ibanisht" },
            { "ibb", "ibibioisht" },
            { "ikt", "inuktitutishte kanadeze per\u00ebndimore" },
            { "ilo", "ilokoisht" },
            { "inh", "ingushisht" },
            { "jbo", "lojbanisht" },
            { "jgo", "ngombisht" },
            { "jmc", "ma\u00e7amisht" },
            { "kab", "kabilisht" },
            { "kac", "ka\u00e7inisht" },
            { "kaj", "kajeisht" },
            { "kam", "kambaisht" },
            { "kbd", "kabardianisht" },
            { "kcg", "tjapisht" },
            { "kde", "makondisht" },
            { "kea", "kreolishte e Kepit t\u00eb Gjelb\u00ebr" },
            { "kfo", "koroisht" },
            { "kgp", "kaingangisht" },
            { "kha", "kasisht" },
            { "khq", "kojra\u00e7inisht" },
            { "kkj", "kakoisht" },
            { "kln", "kalenxhinisht" },
            { "kmb", "kimbunduisht" },
            { "koi", "komi-parmjakisht" },
            { "kok", "konkanisht" },
            { "kpe", "kpeleisht" },
            { "krc", "kara\u00e7aj-balkarisht" },
            { "krl", "karelianisht" },
            { "kru", "kurukisht" },
            { "ksb", "shambalisht" },
            { "ksf", "bafianisht" },
            { "ksh", "k\u00eblnisht" },
            { "kum", "kumikisht" },
            { "kwk", "kuakualaisht" },
            { "kxv", "kuvisht" },
            { "lad", "ladinoisht" },
            { "lag", "langisht" },
            { "lez", "lezgianisht" },
            { "lij", "ligurianisht" },
            { "lil", "lilluetisht" },
            { "lkt", "lakotisht" },
            { "lmo", "lombardisht" },
            { "lou", "kreolishte e Luizian\u00ebs" },
            { "loz", "lozisht" },
            { "lrc", "lurishte veriore" },
            { "lsm", "samisht" },
            { "lua", "luba-luluaisht" },
            { "lun", "lundaisht" },
            { "luo", "luoisht" },
            { "lus", "mizoisht" },
            { "luy", "lujaisht" },
            { "mad", "madurezisht" },
            { "mag", "magaisht" },
            { "mai", "maitilisht" },
            { "mak", metaValue_mak },
            { "mas", "masaisht" },
            { "mdf", "mokshaisht" },
            { "men", "mendisht" },
            { "mer", "meruisht" },
            { "mfe", "morisjenisht" },
            { "mgh", "makua-mitoisht" },
            { "mgo", "metaisht" },
            { "mic", "mikmakisht" },
            { "min", "minangkabauisht" },
            { "mni", "manipurisht" },
            { "moe", "inuaimunisht" },
            { "moh", "mohokisht" },
            { "mos", "mosisht" },
            { "mua", "mundangisht" },
            { "mul", "gjuh\u00eb t\u00eb shum\u00ebfishta" },
            { "mus", "krikisht" },
            { "mwl", "mirandisht" },
            { "myv", "erzjaisht" },
            { "mzn", "mazanderanisht" },
            { "nap", "napoletanisht" },
            { "naq", "namaisht" },
            { "nds", "gjermanishte e vendeve t\u00eb ul\u00ebta" },
            { "new", "neuarisht" },
            { "nia", "niasisht" },
            { "niu", "niueanisht" },
            { "nmg", "kuasisht" },
            { "nnh", "ngiembunisht" },
            { "nog", "nogajisht" },
            { "nqo", "nkoisht" },
            { "nso", "sotoishte veriore" },
            { "nus", "nuerisht" },
            { "nyn", "niankolisht" },
            { "ojb", "oxhibuaishte verilindore" },
            { "ojc", "oxhibuaishte qendrore" },
            { "ojs", "oxhikrijisht" },
            { "ojw", "oxhibuaishte per\u00ebndimore" },
            { "oka", "okanaganisht" },
            { "pag", "pangasinanisht" },
            { "pam", "pampangaisht" },
            { "pap", "papiamentisht" },
            { "pau", "paluanisht" },
            { "pcm", "pixhinishte nigeriane" },
            { "pis", "pixhinisht" },
            { "pqm", "malisit-pasamakuadisht" },
            { "prg", "prusisht" },
            { "quc", "ki\u00e7eisht" },
            { "raj", "raxhastanisht" },
            { "rap", "rapanuisht" },
            { "rar", "rarontonganisht" },
            { "rhg", "rohingiaisht" },
            { "rof", "romboisht" },
            { "rup", "vllahisht" },
            { "rwk", "ruaisht" },
            { "sad", "sandauisht" },
            { "sah", "sakaisht" },
            { "saq", "samburisht" },
            { "sat", "santalisht" },
            { "sba", "ngambajisht" },
            { "sbp", "sanguisht" },
            { "scn", "si\u00e7ilianisht" },
            { "sco", "skotisht" },
            { "sdh", "kurdishte jugore" },
            { "seh", "senaisht" },
            { "ses", "senishte kojrabore" },
            { "shi", "ta\u00e7elitisht" },
            { "shn", "shanisht" },
            { "slh", "lashutsidishte jugore" },
            { "sma", "samishte jugore" },
            { "smj", "samishte lule" },
            { "smn", "samishte inari" },
            { "sms", "samishte skolti" },
            { "snk", "soninkisht" },
            { "srn", "srananisht (sranantongoisht)" },
            { "ssy", "sahoisht" },
            { "str", "sejlishte e Ngushticave t\u00eb Rozarios" },
            { "suk", "sukumaisht" },
            { "swb", "kamorianisht" },
            { "syr", "siriakisht" },
            { "szl", "silesisht" },
            { "tce", "tatshonishte jugore" },
            { "tem", "timneisht" },
            { "teo", "tesoisht" },
            { "tet", "tetumisht" },
            { "tgx", "tagishisht" },
            { "tht", "taltanisht" },
            { "tig", "tigreisht" },
            { "tlh", "klingonisht" },
            { "tli", "tlingitisht" },
            { "tok", "tokiponaisht" },
            { "tpi", "pisinishte toku" },
            { "trv", "torokoisht" },
            { "ttm", "ta\u00e7oneishte veriore" },
            { "tum", "tumbukaisht" },
            { "tvl", "tuvaluisht" },
            { "twq", "tasavakisht" },
            { "tyv", "tuvinianisht" },
            { "tzm", "tamazajtisht e Atlasit Qendror" },
            { "udm", "udmurtisht" },
            { "umb", "umbunduisht" },
            { "und", "E panjohur" },
            { "vai", "vaisht" },
            { "vec", "venetisht" },
            { "vmw", "makuvaisht" },
            { "vun", "vunxhoisht" },
            { "wae", "ualserisht" },
            { "wal", "ulajtaisht" },
            { "war", "uarajisht" },
            { "wbp", "uarlpirisht" },
            { "wuu", "kinezishte vu" },
            { "xal", "kalmikisht" },
            { "xnr", "kangrisht" },
            { "xog", "sogisht" },
            { "yav", "jangbenisht" },
            { "ybb", "jembaisht" },
            { "yrl", "nejengatuisht" },
            { "yue", "kantonezisht" },
            { "zgh", "tamaziatishte standarde marokene" },
            { "zun", "zunisht" },
            { "zxx", "nuk ka p\u00ebrmbajtje gjuh\u00ebsore" },
            { "zza", "zazaisht" },
            { "Adlm", "adlam" },
            { "Aghb", "albanishte e Kaukazit" },
            { "Ahom", "ahomisht" },
            { "Arab", "arabik" },
            { "Aran", "nastalik" },
            { "Armi", "aramaishte perandorake" },
            { "Armn", "armen" },
            { "Avst", "avestanisht" },
            { "Bali", "bali" },
            { "Bamu", "bamu" },
            { "Bass", "basavahisht" },
            { "Batk", "batak" },
            { "Beng", "bengal" },
            { "Bhks", "baiksukisht" },
            { "Bopo", "bopomof" },
            { "Brah", "brahmisht" },
            { "Brai", "brailisht" },
            { "Bugi", "buginisht" },
            { "Buhd", "buhidisht" },
            { "Cakm", "\u00e7akma" },
            { "Cans", "rrokje t\u00eb unifikuara aborigjene kanadeze" },
            { "Cari", "karianisht" },
            { "Cham", "\u00e7am" },
            { "Cher", "\u00e7eroki" },
            { "Chrs", "korasmianisht" },
            { "Copt", "koptisht" },
            { "Cpmn", "minoishte e Qipros" },
            { "Cprt", "qipriotisht" },
            { "Cyrl", "cirilik" },
            { "Deva", "devanagar" },
            { "Diak", "divesakuruisht" },
            { "Dogr", "dograisht" },
            { "Dsrt", "deseretisht" },
            { "Dupl", "duplojanisht - form\u00eb e shkurt\u00ebr" },
            { "Egyp", "hieroglife egjiptiane" },
            { "Elba", "shkrim i Elbasanit" },
            { "Elym", "elimaisht" },
            { "Ethi", "etiopik" },
            { "Geor", "gjeorgjian" },
            { "Glag", "glagolitikisht" },
            { "Gong", "gong" },
            { "Gonm", "masaramgondisht" },
            { "Goth", "gotik" },
            { "Gran", "grantaisht" },
            { "Grek", "grek" },
            { "Gujr", "guxharat" },
            { "Guru", "gurmuk" },
            { "Hanb", "hanbik" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoisht" },
            { "Hans", "i thjeshtuar" },
            { "Hant", "tradicional" },
            { "Hatr", "hatranisht" },
            { "Hebr", "hebraik" },
            { "Hira", "hiragan" },
            { "Hluw", "hieroglife anatoliane" },
            { "Hmng", "pahauhmonisht" },
            { "Hmnp", "niakeng pua\u00e7ue hmong" },
            { "Hrkt", "alfabet rrokjesor japonez" },
            { "Hung", "hungarishte e vjet\u00ebr" },
            { "Ital", "italishte e vjet\u00ebr" },
            { "Jamo", "jamosisht" },
            { "Java", "java" },
            { "Jpan", "japonez" },
            { "Kali", "kajali" },
            { "Kana", "katakan" },
            { "Kawi", "kavi" },
            { "Khar", "karoshtisht" },
            { "Khmr", "kmer" },
            { "Khoj", "koxhkisht" },
            { "Kits", "shkrim i vog\u00ebl kitan" },
            { "Knda", "kanad" },
            { "Kore", "korean" },
            { "Kthi", "kaitisht" },
            { "Lana", "lana" },
            { "Laoo", metaValue_lo },
            { "Latn", "latin" },
            { "Lepc", "lep\u00e7a" },
            { "Limb", "limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "fraser" },
            { "Lyci", "licianisht" },
            { "Lydi", "lidianisht" },
            { "Mahj", "mahaxhanisht" },
            { "Maka", metaValue_mak },
            { "Mand", "mande" },
            { "Mani", "manikeanisht" },
            { "Marc", "markenisht" },
            { "Medf", "medefaidrinisht" },
            { "Mend", "mendeisht" },
            { "Merc", "meroitik kursiv" },
            { "Mero", "meroitik" },
            { "Mlym", "malajalam" },
            { "Modi", "modisht" },
            { "Mong", metaValue_mn },
            { "Mroo", "mroisht" },
            { "Mtei", "mitei-majek" },
            { "Mult", "multanisht" },
            { "Mymr", "birman" },
            { "Nagm", "nag mundari" },
            { "Nand", "nandigarisht" },
            { "Narb", "arabishte veriore e vjet\u00ebr" },
            { "Nbat", "nabateanisht" },
            { "Newa", "neva" },
            { "Nkoo", "nko" },
            { "Nshu", "nyshuisht" },
            { "Ogam", "ogamisht" },
            { "Olck", "ol \u00e7iki" },
            { "Orkh", "orkonisht" },
            { "Orya", "orija" },
            { "Osge", "osage" },
            { "Osma", "osmaniaisht" },
            { "Ougr", "ujgurishte e vjet\u00ebr" },
            { "Palm", "palmirenisht" },
            { "Pauc", "pausinhauisht" },
            { "Perm", "permike e vjet\u00ebr" },
            { "Phag", "fagspaisht" },
            { "Phli", "palavishte mbishkrimesh" },
            { "Phlp", "palavishte psalteri" },
            { "Phnx", "fenikisht" },
            { "Plrd", "polard fonetik" },
            { "Prti", "persishte mbishkrimesh" },
            { "Qaag", "zaugi" },
            { "Rjng", "rexhangisht" },
            { "Rohg", "hanifi" },
            { "Runr", "runike" },
            { "Samr", "samaritanisht" },
            { "Sarb", "arabishte jugore e vjet\u00ebr" },
            { "Saur", "saurashtra" },
            { "Sgnw", "shkrim sing" },
            { "Shaw", "shavianisht" },
            { "Shrd", "sharadisht" },
            { "Sidd", "sidamisht" },
            { "Sind", "kudavadisht" },
            { "Sinh", "sinhal" },
            { "Sogd", "sogdianisht" },
            { "Sogo", "sogdianishte e vjet\u00ebr" },
            { "Sora", "sorasompengisht" },
            { "Soyo", "sojomboisht" },
            { "Sund", "sundan" },
            { "Sylo", "siloti nagri" },
            { "Syrc", "siriak" },
            { "Tagb", "tagbanvaisht" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue i ri" },
            { "Taml", "tamil" },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", "telug" },
            { "Tfng", "tifinag" },
            { "Tglg", "tagalog" },
            { "Thaa", "tanisht" },
            { "Thai", "tajlandez" },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", "ugaritik" },
            { "Vaii", "vai" },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "van\u00e7o" },
            { "Xpeo", "persian i vjet\u00ebr" },
            { "Xsux", "kuneiform sumero-akadian" },
            { "Yezi", "jezidi" },
            { "Yiii", "ji" },
            { "Zanb", "katror zanabazar" },
            { "Zinh", "zin" },
            { "Zmth", "simbole matematikore" },
            { "Zsye", "emoji" },
            { "Zsym", "me simbole" },
            { "Zxxx", "i pashkruar" },
            { "Zyyy", "i zakonsh\u00ebm" },
            { "Zzzz", "i panjohur" },
            { "de_AT", "gjermanishte austriake" },
            { "de_CH", "gjermanishte zvicerane (dialekti i Alpeve)" },
            { "en_AU", "anglishte australiane" },
            { "en_CA", "anglishte kanadeze" },
            { "en_GB", "anglishte britanike" },
            { "en_US", "anglishte amerikane" },
            { "es_ES", "spanjishte evropiane" },
            { "es_MX", "spanjishte meksikane" },
            { "fa_AF", "darisht" },
            { "fr_CA", "fr\u00ebngjishte kanadeze" },
            { "fr_CH", "fr\u00ebngjishte zvicerane" },
            { "nl_BE", "flamandisht" },
            { "pt_BR", "portugalishte braziliane" },
            { "pt_PT", "portugalishte evropiane" },
            { "ro_MD", "moldavisht" },
            { "sw_CD", "suahilishte kongoleze" },
            { "ar_001", "arabishte standarde moderne" },
            { "es_419", "spanjishte amerikano-latine" },
            { "key.ca", "Kalendari" },
            { "key.cf", "Formati valutor" },
            { "key.co", "Radhitja" },
            { "key.cu", "Valuta" },
            { "key.hc", "Cikli orar (12 - 24)" },
            { "key.lb", "Stili i gjer\u00ebsis\u00eb s\u00eb rreshtave" },
            { "key.ms", "Sistemi i nj\u00ebsive mat\u00ebse" },
            { "key.nu", "Numrat/shifrat" },
            { "nds_NL", "gjermanishte saksone e vendeve t\u00eb ul\u00ebta" },
            { "hi_Latn", "hindisht (latine)" },
            { "zh_Hans", "kinezishte e thjeshtuar" },
            { "zh_Hant", "kinezishte tradicionale" },
            { "type.ca.roc", "kalendar minguo" },
            { "type.co.eor", "Rregulla evropiane radhitjeje" },
            { "type.hc.h11", "sistem 12-or\u00ebsh (0 - 11)" },
            { "type.hc.h12", "sistem 12-or\u00ebsh (1 - 12)" },
            { "type.hc.h23", "sistem 24-or\u00ebsh (0 - 23)" },
            { "type.hc.h24", "sistem 24-or\u00ebsh (1 - 24)" },
            { "type.nu.ahom", "shifra ahom" },
            { "type.nu.arab", "shifra indo-arabe" },
            { "type.nu.armn", "numra armen\u00eb" },
            { "type.nu.bali", "shifra bali" },
            { "type.nu.beng", "shifra bengali" },
            { "type.nu.brah", "shifra brahmi" },
            { "type.nu.cakm", "shifra \u00e7akma" },
            { "type.nu.cham", "shifra \u00e7am" },
            { "type.nu.cyrl", "numra cirilik\u00eb" },
            { "type.nu.deva", "shifra devanagari" },
            { "type.nu.diak", "shifra dives akuru" },
            { "type.nu.ethi", "numra etiopian\u00eb" },
            { "type.nu.geor", "numra gjeorgjian\u00eb" },
            { "type.nu.gong", "shifra gunxhala gondi" },
            { "type.nu.gonm", "shifra masaram gondi" },
            { "type.nu.grek", "numra grek\u00eb" },
            { "type.nu.gujr", "shifra guxharati" },
            { "type.nu.guru", "shifra gurmuki" },
            { "type.nu.hans", "numra t\u00eb kinezishtes s\u00eb thjeshtuar" },
            { "type.nu.hant", "numra t\u00eb kinezishtes tradicionale" },
            { "type.nu.hebr", "numra hebraik\u00eb" },
            { "type.nu.hmng", "shifra pahau hmong" },
            { "type.nu.hmnp", "shifra niakeng pua\u00e7ue hmong" },
            { "type.nu.java", "shifra java" },
            { "type.nu.jpan", "numra japonez\u00eb" },
            { "type.nu.kali", "shifra kaja li" },
            { "type.nu.kawi", "shifra kavi" },
            { "type.nu.khmr", "shifra kmere" },
            { "type.nu.knda", "shifra kanade" },
            { "type.nu.lana", "shifra tai tam hora" },
            { "type.nu.laoo", "shifra lao" },
            { "type.nu.latn", "shifra latino-per\u00ebndimore" },
            { "type.nu.lepc", "shifra lep\u00e7a" },
            { "type.nu.limb", "shifra limbu" },
            { "type.nu.mlym", "shifra malajalame" },
            { "type.nu.modi", "shifra modi" },
            { "type.nu.mong", "shifra mongole" },
            { "type.nu.mroo", "shifra mro" },
            { "type.nu.mtei", "shifra mitei-majeke" },
            { "type.nu.mymr", "shifra mianmari" },
            { "type.nu.nagm", "shifra nag mundan" },
            { "type.nu.nkoo", "shifra nko" },
            { "type.nu.olck", "shifra ol-\u00e7ikike" },
            { "type.nu.orya", "shifra orije" },
            { "type.nu.osma", "shifra osmania" },
            { "type.nu.rohg", "shifra hanifi rohingia" },
            { "type.nu.saur", "shifra saurashtra" },
            { "type.nu.shrd", "shifra sharada" },
            { "type.nu.sind", "shifra kudavadi" },
            { "type.nu.sinh", "shifra sinala lit" },
            { "type.nu.sora", "shifra sora sompeng" },
            { "type.nu.sund", "shifra sundan" },
            { "type.nu.takr", "shifra takri" },
            { "type.nu.talu", "shifra t\u00eb reja tai lue" },
            { "type.nu.taml", "numra tamil\u00eb tradicional\u00eb" },
            { "type.nu.telu", "shifra teluguje" },
            { "type.nu.thai", "shifra tajlandeze" },
            { "type.nu.tibt", "shifra tibetiane" },
            { "type.nu.tirh", "shifra tirhuta" },
            { "type.nu.tnsa", "shifra tangsa" },
            { "type.nu.vaii", "shifra vai" },
            { "type.nu.wara", "shifra varang citi" },
            { "type.nu.wcho", "shifra van\u00e7o" },
            { "type.ca.dangi", "kalendar dangi" },
            { "type.co.ducet", "radhitje unikode e parazgjedhur" },
            { "type.co.emoji", "Radhitje Emoji" },
            { "type.lb.loose", "stil i gjer\u00ebsis\u00eb s\u00eb rreshtave - i larguar" },
            { "type.nu.roman", "numra romak\u00eb" },
            { "type.ca.coptic", "kalendar koptik" },
            { "type.ca.hebrew", "kalendar hebraik" },
            { "type.ca.indian", "Kalendari Komb\u00ebtar Indian" },
            { "type.co.compat", "Radhitja e m\u00ebparshme, p\u00ebr pajtueshm\u00ebri" },
            { "type.co.pinyin", "Radhitje pinini" },
            { "type.co.search", "k\u00ebrkim i p\u00ebrgjithsh\u00ebm" },
            { "type.co.stroke", "radhitje me vij\u00ebzim" },
            { "type.co.unihan", "radhitje me vij\u00ebzim radikal" },
            { "type.co.zhuyin", "radhitje zhujin" },
            { "type.lb.normal", "stil i gjer\u00ebsis\u00eb s\u00eb rreshtave - normal" },
            { "type.lb.strict", "stil i gjer\u00ebsis\u00eb s\u00eb rreshtave - i ngushtuar" },
            { "type.ms.metric", "sistem metrik" },
            { "type.ca.chinese", "kalendar kinez" },
            { "type.ca.islamic", "kalendar islam" },
            { "type.ca.iso8601", "kalendar ISO-8601" },
            { "type.ca.persian", "kalendar persian" },
            { "type.cf.account", "format valutor llogarit\u00ebs" },
            { "type.co.big5han", "Radhitje e kinezishtes tradicionale - Big5" },
            { "type.nu.arabext", "shifra indo-arabe t\u00eb zgjatura" },
            { "type.nu.armnlow", "numra armen\u00eb t\u00eb vegj\u00ebl" },
            { "type.nu.greklow", "numra grek\u00eb t\u00eb vegj\u00ebl" },
            { "type.nu.hanidec", "numra dhjetor\u00eb kinez\u00eb" },
            { "type.nu.hansfin", "numra financiar\u00eb t\u00eb kinezishtes s\u00eb thjeshtuar" },
            { "type.nu.hantfin", "numra financiar\u00eb t\u00eb kinezishtes tradicionale" },
            { "type.nu.jpanfin", "numra financiar\u00eb japonez\u00eb" },
            { "type.nu.mathdbl", "shifra matematike me dy kalime" },
            { "type.nu.tamldec", "shifra tamile" },
            { "type.ca.buddhist", "kalendar budist" },
            { "type.ca.ethiopic", "kalendari etiopik" },
            { "type.ca.japanese", "kalendar japonez" },
            { "type.cf.standard", "format valutor standard" },
            { "type.co.searchjl", "k\u00ebrkim sipas bashk\u00ebting\u00ebllores fillestare hangul" },
            { "type.co.standard", "radhitje standarde" },
            { "type.ms.uksystem", "sistem imperial (britanik) i nj\u00ebsive mat\u00ebse" },
            { "type.ms.ussystem", "sistem amerikan i nj\u00ebsive mat\u00ebse" },
            { "type.nu.fullwide", "shifra me larg\u00ebsi t\u00eb brendshme" },
            { "type.nu.lanatham", "shifra tai tam tam" },
            { "type.nu.mathbold", "shifra t\u00eb trasha matematike" },
            { "type.nu.mathmono", "shifra matematike monohap\u00ebsire" },
            { "type.nu.mathsanb", "shifra t\u00eb trasha matematike sans-serif" },
            { "type.nu.mathsans", "shifra matematike sans-serif" },
            { "type.nu.mymrshan", "shifra mianmar-shan" },
            { "type.nu.mymrtlng", "shifra mianmar tai lang" },
            { "type.nu.romanlow", "numra romak\u00eb t\u00eb vegj\u00ebl" },
            { "type.ca.gregorian", "kalendar gregorian" },
            { "type.co.gb2312han", "Radhitje e kinezishtes s\u00eb thjesht\u00ebsuar - GB2312" },
            { "type.co.phonebook", "Radhitje libri telefonik" },
            { "type.co.dictionary", "Radhitje fjalori" },
            { "type.co.traditional", "radhitje tradicionale" },
            { "type.ca.islamic-rgsa", "kalendar islamik (Arabi Saudite, shikim)" },
            { "type.ca.islamic-tbla", "kalendar islam (tabelor, epoka astronomike)" },
            { "type.ca.islamic-civil", "kalendar islam (tabelor, epoka civile)" },
            { "type.ca.islamic-umalqura", "kalendar islam (um al-qura)" },
            { "type.ca.ethiopic-amete-alem", "kalendar etiopik amete-alem" },
        };
        return data;
    }
}
