/*
 * Copyright (c) 1996, 2001, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package sun.rmi.transport;

import java.rmi.RemoteException;

public interface Channel {

    /**
     * Generates a new connection to the endpoint of the address space
     * for which this is a channel.
     */
    public Connection newConnection() throws RemoteException;

    /**
     * Returns the endpoint of the address space for which this is a
     * channel.
     */
    public Endpoint getEndpoint();

    /**
     * Free the connection generated by this channel.
     * @param conn The connection.
     * @param reuse If true, the connection is in a state in which it
     *        can be reused for another method call.
     */
    public void free(Connection conn, boolean reuse) throws RemoteException;
}
