/*
 * Copyright (c) 2022, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.internal.classfile.impl;

import java.lang.classfile.BootstrapMethodEntry;
import java.lang.classfile.constantpool.*;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.Objects;

public final class TemporaryConstantPool implements ConstantPoolBuilder {

    private TemporaryConstantPool() {}

    public static final TemporaryConstantPool INSTANCE = new TemporaryConstantPool();

    @Override
    public Utf8Entry utf8Entry(String s) {
        return new AbstractPoolEntry.Utf8EntryImpl(this, -1, s);
    }

    @Override
    public IntegerEntry intEntry(int value) {
        return new AbstractPoolEntry.IntegerEntryImpl(this, -1, value);
    }

    @Override
    public FloatEntry floatEntry(float value) {
        return new AbstractPoolEntry.FloatEntryImpl(this, -1, value);
    }

    @Override
    public LongEntry longEntry(long value) {
        return new AbstractPoolEntry.LongEntryImpl(this, -1, value);
    }

    @Override
    public DoubleEntry doubleEntry(double value) {
        return new AbstractPoolEntry.DoubleEntryImpl(this, -1, value);
    }

    @Override
    public ClassEntry classEntry(Utf8Entry name) {
        return new AbstractPoolEntry.ClassEntryImpl(this, -2, (AbstractPoolEntry.Utf8EntryImpl) name);
    }

    @Override
    public PackageEntry packageEntry(Utf8Entry name) {
        return new AbstractPoolEntry.PackageEntryImpl(this, -2, (AbstractPoolEntry.Utf8EntryImpl) name);
    }

    @Override
    public ModuleEntry moduleEntry(Utf8Entry name) {
        return new AbstractPoolEntry.ModuleEntryImpl(this, -2, (AbstractPoolEntry.Utf8EntryImpl) name);
    }

    @Override
    public NameAndTypeEntry nameAndTypeEntry(Utf8Entry nameEntry, Utf8Entry typeEntry) {
        return new AbstractPoolEntry.NameAndTypeEntryImpl(this, -3,
                                                          (AbstractPoolEntry.Utf8EntryImpl) nameEntry,
                                                          (AbstractPoolEntry.Utf8EntryImpl) typeEntry);
    }

    @Override
    public FieldRefEntry fieldRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        return new AbstractPoolEntry.FieldRefEntryImpl(this, -3,
                                                       (AbstractPoolEntry.ClassEntryImpl) owner,
                                                       (AbstractPoolEntry.NameAndTypeEntryImpl) nameAndType);
    }

    @Override
    public MethodRefEntry methodRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        return new AbstractPoolEntry.MethodRefEntryImpl(this, -3,
                                                        (AbstractPoolEntry.ClassEntryImpl) owner,
                                                        (AbstractPoolEntry.NameAndTypeEntryImpl) nameAndType);
    }

    @Override
    public InterfaceMethodRefEntry interfaceMethodRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        return new AbstractPoolEntry.InterfaceMethodRefEntryImpl(this, -3,
                                                                 (AbstractPoolEntry.ClassEntryImpl) owner,
                                                                 (AbstractPoolEntry.NameAndTypeEntryImpl) nameAndType);
    }

    @Override
    public MethodTypeEntry methodTypeEntry(MethodTypeDesc descriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodTypeEntry methodTypeEntry(Utf8Entry descriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodHandleEntry methodHandleEntry(int refKind, MemberRefEntry reference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InvokeDynamicEntry invokeDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, NameAndTypeEntry nameAndType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConstantDynamicEntry constantDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, NameAndTypeEntry nameAndType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringEntry stringEntry(Utf8Entry utf8) {
        return new AbstractPoolEntry.StringEntryImpl(this, -2, (AbstractPoolEntry.Utf8EntryImpl) utf8);
    }

    @Override
    public BootstrapMethodEntry bsmEntry(MethodHandleEntry methodReference, List<LoadableConstantEntry> arguments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PoolEntry entryByIndex(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends PoolEntry> T entryByIndex(int index, Class<T> cls) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BootstrapMethodEntry bootstrapMethodEntry(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int bootstrapMethodCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWriteDirect(ConstantPool constantPool) {
        Objects.requireNonNull(constantPool);
        return false;
    }
}
