/*
 * Copyright (c) 2021, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

const Long64 = {
    Zero: () => $t["com.oracle.svm.aotjs.longemulation.a"].$f["LongZero"],

    fromInt: (n) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["fromInt"](n);
    },

    fromDouble: (number) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["fromDouble"](number);
    },

    add: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["add"](left, right);
    },

    sub: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["sub"](left, right);
    },

    mul: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["mul"](left, right);
    },

    div: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["div"](left, right);
    },

    and: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["and"](left, right);
    },

    or: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["or"](left, right);
    },

    not: (left) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["not"](left);
    },

    xor: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["xor"](left, right);
    },

    mod: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["mod"](left, right);
    },

    sl: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["sl"](left, right);
    },

    sr: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["sr"](left, right);
    },

    usr: (left, right) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["usr"](left, right);
    },

    slFromNum: (left, num) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["slFromNum"](left, num);
    },

    srFromNum: (left, num) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["srFromNum"](left, num);
    },

    usrFromNum: (left, num) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["usrFromNum"](left, num);
    },

    negate: (left) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["negate"](left);
    },

    equal: (l, r) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["equal"](l, r);
    },

    lessThan: (l, r) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["lessThan"](l, r);
    },

    belowThan: (l, r) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["belowThan"](l, r);
    },

    test: (l, r) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["test"](l, r);
    },

    fromTwoInt: (low, high) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["fromTwoInt"](low, high);
    },

    fromZeroExtend: (a) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["fromZeroExtend"](a);
    },

    lowBits: (a) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["lowBits"](a);
    },

    highBits: (a) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["highBits"](a);
    },

    compare: (a, b) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["compare"](a, b);
    },

    compareUnsigned: (a, b) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["compareUnsigned"](a, b);
    },

    toNumber: (a) => {
        return $t["com.oracle.svm.aotjs.longemulation.a"].$m["toNumber"](a);
    },

    instanceof: (other) => {
        return other instanceof $t["com.oracle.svm.aotjs.longemulation.a"];
    },
};
