/*
 * Copyright (c) 2013, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.StaticFieldsSupport;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;

/**
 * The field interface which is both used in the hosted and substrate worlds.
 */
public interface SharedField extends ResolvedJavaField {

    int LOC_UNINITIALIZED = -1;

    /**
     * The offset or index of the field. The value depends on the kind of field:
     * <ul>
     * <li>instance fields: the offset (in bytes) from the origin of the instance.
     * <li>static fields of primitive type: the offset (in bytes) into the static primitive data
     * array {@link StaticFieldsSupport#getStaticPrimitiveFields()}.
     * <li>static reference fields: the offset (in bytes) into the static object data array
     * {@link StaticFieldsSupport#getStaticObjectFields()}.
     * <li>static fields that are never written (including but not limited to static final fields):
     * unused, this method must not be called.
     * </ul>
     */
    int getLocation();

    boolean isAccessed();

    boolean isReachable();

    boolean isWritten();

    /**
     * Returns true if the field's value is available at the time of querying. For unknown fields
     * this depends on the image build stage when the value is computed.
     */
    boolean isValueAvailable();

    JavaKind getStorageKind();

    /** Returns true if this field is defined in a base layer. */
    boolean isInBaseLayer();

    JavaConstant getStaticFieldBase();
}
