/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.PrimitiveComparison;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class PrimitiveFilterTypeFlow
extends TypeFlow<BytecodePosition> {
    private final TypeFlow<?> left;
    private final TypeFlow<?> right;
    private final PrimitiveComparison comparison;

    public PrimitiveFilterTypeFlow(BytecodePosition position, AnalysisType declaredType, TypeFlow<?> left, TypeFlow<?> right, PrimitiveComparison comparison) {
        super(position, declaredType);
        this.left = left;
        this.right = right;
        this.comparison = comparison;
    }

    private PrimitiveFilterTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, PrimitiveFilterTypeFlow original) {
        super(original, methodFlows);
        this.left = methodFlows.lookupCloneOf(bb, original.left);
        this.right = methodFlows.lookupCloneOf(bb, original.right);
        this.comparison = original.comparison;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new PrimitiveFilterTypeFlow(bb, methodFlows, this);
    }

    @Override
    public boolean addState(PointsToAnalysis bb, TypeState add) {
        return super.addState(bb, this.eval(bb));
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        super.addState(bb, this.eval(bb));
    }

    private TypeState eval(PointsToAnalysis bb) {
        TypeState leftState = this.left.getOutputState(bb);
        TypeState rightState = this.right.getOutputState(bb);
        assert (leftState.isPrimitive() || leftState.isEmpty()) : this.left;
        assert (rightState.isPrimitive() || rightState.isEmpty()) : this.right;
        return TypeState.filter(leftState, this.comparison, rightState);
    }

    public PrimitiveComparison getComparison() {
        return this.comparison;
    }

    public TypeFlow<?> getLeft() {
        return this.left;
    }
}

