/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.PrimitiveTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import jdk.vm.ci.code.BytecodePosition;

public class ConditionalFlow
extends TypeFlow<BytecodePosition> {
    private final TypeFlow<?> condition;
    private final TypeFlow<?> trueValue;
    private final TypeFlow<?> falseValue;

    public ConditionalFlow(BytecodePosition source, AnalysisType declaredType, TypeFlow<?> condition, TypeFlow<?> trueValue, TypeFlow<?> falseValue) {
        super(source, declaredType);
        assert (condition.isPrimitiveFlow()) : condition;
        this.condition = condition;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    private ConditionalFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, ConditionalFlow original) {
        super(original, methodFlows);
        this.condition = methodFlows.lookupCloneOf(bb, original.condition);
        this.trueValue = methodFlows.lookupCloneOf(bb, original.trueValue);
        this.falseValue = methodFlows.lookupCloneOf(bb, original.falseValue);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new ConditionalFlow(bb, methodFlows, this);
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        super.addState(bb, this.eval(bb));
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        super.addState(bb, this.eval(bb));
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        super.addState(bb, this.eval(bb));
    }

    @Override
    public boolean addState(PointsToAnalysis bb, TypeState add) {
        return super.addState(bb, this.eval(bb));
    }

    private TypeState eval(PointsToAnalysis bb) {
        TypeState trueState = this.trueValue.getOutputState(bb);
        TypeState falseState = this.falseValue.getOutputState(bb);
        if (this.condition.isSaturated()) {
            return TypeState.forUnion(bb, trueState, falseState);
        }
        TypeState conditionValue = this.condition.getOutputState(bb);
        if (conditionValue.isEmpty()) {
            return TypeState.forEmpty();
        }
        if (conditionValue instanceof PrimitiveTypeState) {
            PrimitiveTypeState prim = (PrimitiveTypeState)conditionValue;
            boolean canBeTrue = prim.canBeTrue();
            boolean canBeFalse = prim.canBeFalse();
            if (canBeTrue && !canBeFalse) {
                return trueState;
            }
            if (!canBeTrue && canBeFalse) {
                return falseState;
            }
            return TypeState.forUnion(bb, trueState, falseState);
        }
        throw AnalysisError.shouldNotReachHere("Unexpected non-primitive type state of the condition: " + String.valueOf(conditionValue) + ", at flow " + String.valueOf(this));
    }
}

