/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.enterprise.profiling.ProfilingJsonUtils;
import com.oracle.svm.enterprise.profiling.framework.InstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.PGOData;
import com.oracle.svm.enterprise.profiling.framework.PGOInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.PGOSamplingData;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.ProfilingMethod;
import com.oracle.svm.enterprise.profiling.framework.ProfilingType;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.enterprise.profiling.loaders.ArrayBackedStorage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.util.json.JsonParser;

public final class GenerateIprofFromPerf
extends ConfigurationCommand {
    private static final String SOURCE_MAPPINGS_NOT_AS_EXPECTED = "Source mappings not as expected";
    private static final String PERF_DATA_NOT_AS_EXPECTED = "Perf data not as expected";
    public static final String SOURCE_MAPPING_VERSION = "0.0.1";

    public String getName() {
        return "generate-iprof-from-perf";
    }

    public void apply(Iterator<String> argumentsIterator) throws IOException {
        Args args = GenerateIprofFromPerf.parseArgs(argumentsIterator);
        SourceMappingData sourceMappingData = GenerateIprofFromPerf.parseSourceMappingData(args);
        PerfData perfData = GenerateIprofFromPerf.parsePerfData(args);
        PGOSamplingData pgoSamplingData = GenerateIprofFromPerf.decodeSamplingData(perfData, sourceMappingData);
        PGOData pgoData = new PGOData(sourceMappingData.metadataBuilder.build(), new PGOInstrumentationData((InstrumentationData.Storage)new ArrayBackedStorage()), pgoSamplingData, ProfileData.ProfileSource.PROFILED);
        ProfileDumper.dumpToFile((ProfileDumper)ProfileDumper.createDefault((ProfileDumper.DumpableData)pgoData, Function.identity(), (boolean)false), (Path)args.output, (boolean)false);
    }

    private static PGOSamplingData decodeSamplingData(PerfData perfData, SourceMappingData sourceMappingData) {
        PGOSamplingData pgoSamplingData = new PGOSamplingData();
        for (NativeSample sample : perfData.samples) {
            CallingContext[] callingContext = new CallingContext[]{CallingContext.empty()};
            block1: for (NativeFrame nativeFrame : sample.frames) {
                CompilationResultMapping sourceMapping = sourceMappingData.sourceMappings.get(nativeFrame.uniqueShortName);
                if (sourceMapping == null) continue;
                for (SourceMapping mapping : sourceMapping.mappings) {
                    if (!mapping.contains(nativeFrame.offset)) continue;
                    mapping.callingContext.traverseFromCallee(codePosition -> {
                        callingContext[0] = CallingContext.withCaller((CallingContext)callingContext[0], (CodePosition)codePosition);
                    });
                    continue block1;
                }
            }
            if (callingContext[0].isEmpty()) continue;
            pgoSamplingData.addSample(callingContext[0], 1L);
        }
        return pgoSamplingData;
    }

    private static PerfData parsePerfData(Args args) throws IOException {
        PerfData perfData = new PerfData(new ArrayList<NativeSample>());
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(args.perf.toFile()));){
            String ignored = bufferedReader.readLine();
            while (ignored != null) {
                NativeSample nativeSample = GenerateIprofFromPerf.nativeSample(bufferedReader);
                if (nativeSample != null && !nativeSample.frames.isEmpty()) {
                    perfData.samples.add(nativeSample);
                }
                ignored = bufferedReader.readLine();
            }
        }
        return perfData;
    }

    private static NativeSample nativeSample(BufferedReader bufferedReader) throws IOException {
        NativeSample nativeSample = new NativeSample();
        String line = bufferedReader.readLine();
        while (!line.isEmpty()) {
            NativeFrame nativeFrame = NativeFrame.parse(line);
            if (nativeFrame != null) {
                nativeSample.frames.add(nativeFrame);
            } else if (!nativeSample.frames.isEmpty()) {
                while (!line.isEmpty()) {
                    line = bufferedReader.readLine();
                }
                return null;
            }
            line = bufferedReader.readLine();
        }
        return nativeSample;
    }

    private static SourceMappingData parseSourceMappingData(Args args) throws IOException {
        Object sourceMappingsJson = GenerateIprofFromPerf.parseSourceMappings(args.sourceMappings);
        Object version = ProfilingJsonUtils.getValue((Object)sourceMappingsJson, (String)"version");
        if (!version.equals(SOURCE_MAPPING_VERSION)) {
            throw new IllegalArgumentException("Source mappings not as expected: Unexpected version, expected 0.0.1, got " + String.valueOf(version) + ".");
        }
        Metadata.Builder metadataBuilder = new Metadata.Builder();
        Object metadataJson = ProfilingJsonUtils.getValue((Object)sourceMappingsJson, (String)"metadata");
        GenerateIprofFromPerf.addTypesToMetadataBuilder(metadataJson, metadataBuilder);
        Map<Integer, ProfilingMethod> methods = GenerateIprofFromPerf.addMethodsToMetadataBuilder(metadataJson, metadataBuilder);
        Map<String, CompilationResultMapping> sourceMappings = GenerateIprofFromPerf.parseSourceMappings(sourceMappingsJson, methods);
        return new SourceMappingData(metadataBuilder, sourceMappings);
    }

    private static Map<String, CompilationResultMapping> parseSourceMappings(Object sourceMappingsJson, Map<Integer, ProfilingMethod> methods) {
        HashMap<String, CompilationResultMapping> sourceMappings = new HashMap<String, CompilationResultMapping>();
        for (Object sourceMappingJson : GenerateIprofFromPerf.ensureList(ProfilingJsonUtils.getValue((Object)sourceMappingsJson, (String)"sourceMappings"))) {
            ProfilingMethod method = methods.get((int)((Integer)ProfilingJsonUtils.getValue(sourceMappingJson, (String)"id")));
            String uniqueShortName = GenerateIprofFromPerf.ensureString(ProfilingJsonUtils.getValue(sourceMappingJson, (String)"uniqueShortName"));
            List<?> mappingsJson = GenerateIprofFromPerf.ensureList(ProfilingJsonUtils.getValue(sourceMappingJson, (String)"mappings"));
            CompilationResultMapping sourceMapping = new CompilationResultMapping(method, uniqueShortName, new ArrayList<SourceMapping>());
            for (Object mapping : mappingsJson) {
                int start = (Integer)ProfilingJsonUtils.getValue(mapping, (String)"start");
                int end = (Integer)ProfilingJsonUtils.getValue(mapping, (String)"end");
                List<?> positions = GenerateIprofFromPerf.ensureList(ProfilingJsonUtils.getValue(mapping, (String)"positions"));
                CallingContext callingContext = CallingContext.empty();
                for (Object position : positions) {
                    int id = (Integer)ProfilingJsonUtils.getValue(position, (String)"id");
                    int bci = (Integer)ProfilingJsonUtils.getValue(position, (String)"bci");
                    callingContext = CallingContext.withCaller((CallingContext)callingContext, (CodePosition)new CodePosition(id, bci));
                }
                sourceMapping.mappings.add(new SourceMapping(start, end, callingContext));
            }
            sourceMappings.put(uniqueShortName, sourceMapping);
        }
        return sourceMappings;
    }

    private static Map<Integer, ProfilingMethod> addMethodsToMetadataBuilder(Object metadataJson, Metadata.Builder metadataBuilder) {
        List<?> methodsJson = GenerateIprofFromPerf.ensureList(ProfilingJsonUtils.getValue((Object)metadataJson, (String)"methods"));
        HashMap<Integer, ProfilingMethod> methods = new HashMap<Integer, ProfilingMethod>();
        for (Object methodJson : methodsJson) {
            int id = (Integer)ProfilingJsonUtils.getValue(methodJson, (String)"id");
            String name = GenerateIprofFromPerf.ensureString(ProfilingJsonUtils.getValue(methodJson, (String)"name"));
            int[] signature = (int[])ProfilingJsonUtils.getPrimitiveArray(methodJson, (String)"signature", int[].class);
            ProfilingMethod profilingMethod = new ProfilingMethod(id, name, signature);
            metadataBuilder.add(profilingMethod);
            methods.put(profilingMethod.id(), profilingMethod);
        }
        return methods;
    }

    private static void addTypesToMetadataBuilder(Object metadataJson, Metadata.Builder metadataBuilder) {
        List<?> typesJson = GenerateIprofFromPerf.ensureList(ProfilingJsonUtils.getValue((Object)metadataJson, (String)"types"));
        for (Object typeJson : typesJson) {
            int id = (Integer)ProfilingJsonUtils.getValue(typeJson, (String)"id");
            String name = GenerateIprofFromPerf.ensureString(ProfilingJsonUtils.getValue(typeJson, (String)"name"));
            ProfilingType profilingType = new ProfilingType(id, name);
            metadataBuilder.add(profilingType);
        }
    }

    private static String ensureString(Object signatureTypeName) {
        if (signatureTypeName instanceof String) {
            String s = (String)signatureTypeName;
            return s;
        }
        throw new IllegalArgumentException(SOURCE_MAPPINGS_NOT_AS_EXPECTED);
    }

    private static Object parseSourceMappings(Path sourceMappings) throws IOException {
        return new JsonParser((Reader)new FileReader(sourceMappings.toFile())).parse();
    }

    private static List<?> ensureList(Object json) {
        if (json instanceof List) {
            List list = (List)json;
            return list;
        }
        throw new IllegalArgumentException(SOURCE_MAPPINGS_NOT_AS_EXPECTED);
    }

    private static Args parseArgs(Iterator<String> argumentsIterator) throws IOException {
        Path outputFilePath = null;
        Path perfFilePath = null;
        Path sourceMappingsPath = null;
        block10: while (argumentsIterator.hasNext()) {
            String argument = argumentsIterator.next();
            String[] optionValue = argument.split("=");
            if (optionValue.length != 2) {
                throw new ConfigurationUsageException(String.format("Format is not valid: %s. Options should be in format --<option>=<value>. ", argument));
            }
            String option = optionValue[0];
            String value = optionValue[1];
            switch (option) {
                case "--perf": {
                    perfFilePath = GenerateIprofFromPerf.getOrCreateFile((String)option, (String)value);
                    continue block10;
                }
                case "--source-mappings": {
                    sourceMappingsPath = GenerateIprofFromPerf.getOrCreateFile((String)option, (String)value);
                    continue block10;
                }
                case "--output-file": {
                    outputFilePath = GenerateIprofFromPerf.getOrCreateFile((String)option, (String)value);
                    continue block10;
                }
            }
            throw new ConfigurationUsageException("Unknown option: " + option);
        }
        if (perfFilePath == null || sourceMappingsPath == null || outputFilePath == null) {
            throw new IllegalArgumentException("All three options are required: --perf (currently set to %s), --source-mappings (currently set to %s) and --output-file (currently set to %s)".formatted(perfFilePath, sourceMappingsPath, outputFilePath));
        }
        return new Args(perfFilePath, sourceMappingsPath, outputFilePath);
    }

    protected String getDescription0() {
        return "Experimental feature, not for use in production.";
    }

    record Args(Path perf, Path sourceMappings, Path output) {
        Args(Path perf, Path sourceMappings, Path output) {
            this.perf = Objects.requireNonNull(perf);
            this.sourceMappings = Objects.requireNonNull(sourceMappings);
            this.output = Objects.requireNonNull(output);
        }
    }

    private record SourceMappingData(Metadata.Builder metadataBuilder, Map<String, CompilationResultMapping> sourceMappings) {
    }

    record PerfData(List<NativeSample> samples) {
    }

    record NativeSample(List<NativeFrame> frames) {
        NativeSample() {
            this(new ArrayList<NativeFrame>());
        }
    }

    record NativeFrame(String uniqueShortName, long offset) {
        public static NativeFrame parse(String line) {
            if (!line.startsWith("\t")) {
                throw new IllegalArgumentException(GenerateIprofFromPerf.PERF_DATA_NOT_AS_EXPECTED);
            }
            String[] parts = line.strip().split(" ");
            String[] symbolAndOffset = parts[1].split("\\+");
            if (symbolAndOffset.length != 2) {
                assert (false) : "Native frame format not as expected " + line;
                return null;
            }
            String uniqueShortName = symbolAndOffset[0];
            if (uniqueShortName.equals("[unknown]")) {
                return null;
            }
            long offset = Long.parseLong(symbolAndOffset[1].split("x")[1], 16);
            return new NativeFrame(uniqueShortName, offset);
        }
    }

    record CompilationResultMapping(ProfilingMethod method, String uniqueShortName, List<SourceMapping> mappings) {
    }

    record SourceMapping(long start, long end, CallingContext callingContext) {
        boolean contains(long offset) {
            return this.start <= offset && offset < this.end;
        }
    }
}

