/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.provider;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.common.Version;
import com.oracle.jipher.internal.openssl.OpenSslValidator;
import com.oracle.jipher.internal.openssl.OpenSslVersion;
import com.oracle.jipher.internal.spi.AeadCipher;
import com.oracle.jipher.internal.spi.AesKeyGenerator;
import com.oracle.jipher.internal.spi.CipherParameters;
import com.oracle.jipher.internal.spi.DESedeKeyGenerator;
import com.oracle.jipher.internal.spi.DhKeyFactory;
import com.oracle.jipher.internal.spi.DhParameters;
import com.oracle.jipher.internal.spi.Digest;
import com.oracle.jipher.internal.spi.Drbg;
import com.oracle.jipher.internal.spi.DsaDigestSig;
import com.oracle.jipher.internal.spi.DsaKeyFactory;
import com.oracle.jipher.internal.spi.DsaParamGenerator;
import com.oracle.jipher.internal.spi.DsaParameters;
import com.oracle.jipher.internal.spi.EcKeyFactory;
import com.oracle.jipher.internal.spi.EcParameters;
import com.oracle.jipher.internal.spi.EcdsaDigestSig;
import com.oracle.jipher.internal.spi.FeedbackCipher;
import com.oracle.jipher.internal.spi.GcmParameters;
import com.oracle.jipher.internal.spi.Hmac;
import com.oracle.jipher.internal.spi.HmacKeyGenerator;
import com.oracle.jipher.internal.spi.KeyAgree;
import com.oracle.jipher.internal.spi.KeyPairGen;
import com.oracle.jipher.internal.spi.NoDigestSig;
import com.oracle.jipher.internal.spi.OaepParameters;
import com.oracle.jipher.internal.spi.PbMac;
import com.oracle.jipher.internal.spi.PbeCipher;
import com.oracle.jipher.internal.spi.PbeKeyFactory;
import com.oracle.jipher.internal.spi.PbeParameters;
import com.oracle.jipher.internal.spi.Pbes2Parameters;
import com.oracle.jipher.internal.spi.Pbkdf2KeyFactory;
import com.oracle.jipher.internal.spi.PssParameters;
import com.oracle.jipher.internal.spi.RsaCipher;
import com.oracle.jipher.internal.spi.RsaDigestSig;
import com.oracle.jipher.internal.spi.RsaKeyFactory;
import com.oracle.jipher.internal.spi.RsaPssDigestSig;
import com.oracle.jipher.internal.spi.RsaPssGeneralSig;
import com.oracle.jipher.internal.spi.SymmKeyFactory;
import com.oracle.jipher.internal.spi.TlsKeyMaterialGenerator;
import com.oracle.jipher.internal.spi.TlsMasterSecretGenerator;
import com.oracle.jipher.internal.spi.TlsPrfGenerator;
import com.oracle.jipher.internal.spi.TlsRsaPremasterSecretGenerator;
import com.oracle.jipher.internal.spi.WrapCipher;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JipherJCE
extends Provider {
    private static final Debug DEBUG_PROV = Debug.getInstance("provider");
    private static final Debug DEBUG_ALG = Debug.getInstance("algorithms");
    public static final String PROVIDER_NAME = "JipherJCE";

    private static String info() {
        return JipherJCE.info(true);
    }

    private static String info(boolean withOpenSSLVersion) {
        return "JipherJCE Provider " + Version.version() + (withOpenSSLVersion ? "[" + OpenSslVersion.get() + "]" : "") + " (implements AES, DESede, Diffie-Hellman, DSA, ECDSA, ECDH, HMAC, PBKDF2, RSA, SHA-1, SHA-2, SHA-3)";
    }

    public static boolean isAvailable() {
        return OpenSslValidator.isAvailable();
    }

    public static ProviderException loadingException() {
        return OpenSslValidator.loadingException();
    }

    public JipherJCE() {
        super(PROVIDER_NAME, Version.versionDouble(), JipherJCE.info());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JipherJCE.this.addServices();
                return null;
            }
        });
    }

    private void addServices() {
        this.putService("MessageDigest", "SHA-1", Digest.Sha1.class.getName(), "SHA1", "SHA", "OID.1.3.14.3.2.26", "1.3.14.3.2.26");
        this.putService("MessageDigest", "SHA-224", Digest.Sha224.class.getName(), "SHA224", "OID.2.16.840.1.101.3.4.2.4", "2.16.840.1.101.3.4.2.4");
        this.putService("MessageDigest", "SHA-256", Digest.Sha256.class.getName(), "SHA256", "OID.2.16.840.1.101.3.4.2.1", "2.16.840.1.101.3.4.2.1");
        this.putService("MessageDigest", "SHA-384", Digest.Sha384.class.getName(), "SHA384", "OID.2.16.840.1.101.3.4.2.2", "2.16.840.1.101.3.4.2.2");
        this.putService("MessageDigest", "SHA-512", Digest.Sha512.class.getName(), "SHA512", "OID.2.16.840.1.101.3.4.2.3", "2.16.840.1.101.3.4.2.3");
        this.putService("MessageDigest", "SHA3-224", Digest.Sha3_224.class.getName(), "OID.2.16.840.1.101.3.4.2.7", "2.16.840.1.101.3.4.2.7");
        this.putService("MessageDigest", "SHA3-256", Digest.Sha3_256.class.getName(), "OID.2.16.840.1.101.3.4.2.8", "2.16.840.1.101.3.4.2.8");
        this.putService("MessageDigest", "SHA3-384", Digest.Sha3_384.class.getName(), "OID.2.16.840.1.101.3.4.2.9", "2.16.840.1.101.3.4.2.9");
        this.putService("MessageDigest", "SHA3-512", Digest.Sha3_512.class.getName(), "OID.2.16.840.1.101.3.4.2.10", "2.16.840.1.101.3.4.2.10");
        this.putService("Cipher", "AES", FeedbackCipher.AES.class.getName(), "Rijndael", "OID.2.16.840.1.101.3.4.1", "2.16.840.1.101.3.4.1");
        this.putService("Cipher", "AES/GCM/NoPadding", AeadCipher.AesGcm.class.getName(), new String[0]);
        this.putService("Cipher", "DESede", FeedbackCipher.DESEDE.class.getName(), "TripleDES");
        this.putService("Cipher", "AES_128/ECB/NoPadding", FeedbackCipher.Aes128EcbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.1", "2.16.840.1.101.3.4.1.1");
        this.putService("Cipher", "AES_192/ECB/NoPadding", FeedbackCipher.Aes192EcbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.21", "2.16.840.1.101.3.4.1.21");
        this.putService("Cipher", "AES_256/ECB/NoPadding", FeedbackCipher.Aes256EcbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.41", "2.16.840.1.101.3.4.1.41");
        this.putService("Cipher", "AES_128/CBC/PKCS5Padding", FeedbackCipher.Aes128CbcPkcs5Pad.class.getName(), "AES_128/CBC/PKCS7Padding", "OID.2.16.840.1.101.3.4.1.2", "2.16.840.1.101.3.4.1.2");
        this.putService("Cipher", "AES_192/CBC/PKCS5Padding", FeedbackCipher.Aes192CbcPkcs5Pad.class.getName(), "AES_192/CBC/PKCS7Padding", "OID.2.16.840.1.101.3.4.1.22", "2.16.840.1.101.3.4.1.22");
        this.putService("Cipher", "AES_256/CBC/PKCS5Padding", FeedbackCipher.Aes256CbcPkcs5Pad.class.getName(), "AES_256/CBC/PKCS7Padding", "OID.2.16.840.1.101.3.4.1.42", "2.16.840.1.101.3.4.1.42");
        this.putService("Cipher", "AES_128/OFB/NoPadding", FeedbackCipher.Aes128OfbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.3", "2.16.840.1.101.3.4.1.3");
        this.putService("Cipher", "AES_192/OFB/NoPadding", FeedbackCipher.Aes192OfbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.23", "2.16.840.1.101.3.4.1.23");
        this.putService("Cipher", "AES_256/OFB/NoPadding", FeedbackCipher.Aes256OfbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.43", "2.16.840.1.101.3.4.1.43");
        this.putService("Cipher", "AES_128/CFB/NoPadding", FeedbackCipher.Aes128CfbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.4", "2.16.840.1.101.3.4.1.4");
        this.putService("Cipher", "AES_192/CFB/NoPadding", FeedbackCipher.Aes192CfbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.24", "2.16.840.1.101.3.4.1.24");
        this.putService("Cipher", "AES_256/CFB/NoPadding", FeedbackCipher.Aes256CfbNoPad.class.getName(), "OID.2.16.840.1.101.3.4.1.44", "2.16.840.1.101.3.4.1.44");
        this.putService("Cipher", "AES_128/GCM/NoPadding", AeadCipher.Aes128Gcm.class.getName(), "OID.2.16.840.1.101.3.4.1.6", "2.16.840.1.101.3.4.1.6");
        this.putService("Cipher", "AES_192/GCM/NoPadding", AeadCipher.Aes192Gcm.class.getName(), "OID.2.16.840.1.101.3.4.1.26", "2.16.840.1.101.3.4.1.26");
        this.putService("Cipher", "AES_256/GCM/NoPadding", AeadCipher.Aes256Gcm.class.getName(), "OID.2.16.840.1.101.3.4.1.46", "2.16.840.1.101.3.4.1.46");
        this.putService("Cipher", "DESede/CBC/PKCS5Padding", FeedbackCipher.DesEdeCbcPkcs5Pad.class.getName(), "DESede/CBC/PKCS7Padding", "OID.1.2.840.113549.3.7", "1.2.840.113549.3.7");
        this.putService("Cipher", "AES/KW/NoPadding", WrapCipher.AesWrap.class.getName(), "AESWrap", "AES-KW");
        this.putService("Cipher", "AES_128/KW/NoPadding", WrapCipher.AesWrap128.class.getName(), "AESWrap_128", "OID.2.16.840.1.101.3.4.1.5", "2.16.840.1.101.3.4.1.5");
        this.putService("Cipher", "AES_192/KW/NoPadding", WrapCipher.AesWrap192.class.getName(), "AESWrap_192", "OID. 2.16.840.1.101.3.4.1.25", "2.16.840.1.101.3.4.1.25");
        this.putService("Cipher", "AES_256/KW/NoPadding", WrapCipher.AesWrap256.class.getName(), "AESWrap_256", "OID.2.16.840.1.101.3.4.1.45", "2.16.840.1.101.3.4.1.45");
        this.putService("Cipher", "AES/KWP/NoPadding", WrapCipher.AesWrapPad.class.getName(), "AESWrapPad", "AES-KWP");
        this.putService("Cipher", "AES_128/KWP/NoPadding", WrapCipher.AesWrapPad128.class.getName(), "AESWrapPad_128", "OID.2.16.840.1.101.3.4.1.8", "2.16.840.1.101.3.4.1.8");
        this.putService("Cipher", "AES_192/KWP/NoPadding", WrapCipher.AesWrapPad192.class.getName(), "AESWrapPad_192", "OID.2.16.840.1.101.3.4.1.28", "2.16.840.1.101.3.4.1.28");
        this.putService("Cipher", "AES_256/KWP/NoPadding", WrapCipher.AesWrapPad256.class.getName(), "AESWrapPad_256", "OID.2.16.840.1.101.3.4.1.48", "2.16.840.1.101.3.4.1.48");
        this.putService("Cipher", "PBEWithHmacSHA1AndAES_128", PbeCipher.PBEWithHmacSHA1AndAES128.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA224AndAES_128", PbeCipher.PBEWithHmacSHA224AndAES128.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA256AndAES_128", PbeCipher.PBEWithHmacSHA256AndAES128.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA384AndAES_128", PbeCipher.PBEWithHmacSHA384AndAES128.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA512AndAES_128", PbeCipher.PBEWithHmacSHA512AndAES128.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA1AndAES_256", PbeCipher.PBEWithHmacSHA1AndAES256.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA224AndAES_256", PbeCipher.PBEWithHmacSHA224AndAES256.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA256AndAES_256", PbeCipher.PBEWithHmacSHA256AndAES256.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA384AndAES_256", PbeCipher.PBEWithHmacSHA384AndAES256.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithHmacSHA512AndAES_256", PbeCipher.PBEWithHmacSHA512AndAES256.class.getName(), new String[0]);
        this.putService("Cipher", "PBEWithSHA1AndDESede", PbeCipher.PBEWithSHA1AndDESede.class.getName(), "OID.1.2.840.113549.1.12.1.3", "1.2.840.113549.1.12.1.3");
        this.putService("Cipher", "RSA/ECB/PKCS1Padding", RsaCipher.RsaPkcs1.class.getName(), "RSA");
        this.putService("Cipher", "RSA/ECB/NoPadding", RsaCipher.RsaNoPad.class.getName(), new String[0]);
        this.putService("Cipher", "RSA/ECB/OAEPPadding", RsaCipher.RsaOaep.class.getName(), new String[0]);
        this.putService("Cipher", "RSA/ECB/OAEPWithSHA-1andMGF1Padding", RsaCipher.RsaOaepSha1.class.getName(), "RSA/ECB/OAEPWithSHA1andMGF1Padding");
        this.putService("Cipher", "RSA/ECB/OAEPWithSHA-224andMGF1Padding", RsaCipher.RsaOaepSha224.class.getName(), "RSA/ECB/OAEPWithSHA224andMGF1Padding");
        this.putService("Cipher", "RSA/ECB/OAEPWithSHA-256andMGF1Padding", RsaCipher.RsaOaepSha256.class.getName(), "RSA/ECB/OAEPWithSHA256andMGF1Padding");
        this.putService("Cipher", "RSA/ECB/OAEPWithSHA-384andMGF1Padding", RsaCipher.RsaOaepSha384.class.getName(), "RSA/ECB/OAEPWithSHA384andMGF1Padding");
        this.putService("Cipher", "RSA/ECB/OAEPWithSHA-512andMGF1Padding", RsaCipher.RsaOaepSha512.class.getName(), "RSA/ECB/OAEPWithSHA512andMGF1Padding");
        this.putService("KeyFactory", "RSA", RsaKeyFactory.class.getName(), "OID.1.2.840.113549.1.1", "1.2.840.113549.1.1", "OID.1.2.840.113549.1.1.1", "1.2.840.113549.1.1.1");
        this.putService("KeyFactory", "RSASSA-PSS", RsaKeyFactory.class.getName(), "PSS", "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10");
        this.putService("KeyFactory", "EC", EcKeyFactory.class.getName(), "EllipticCurve", "OID.1.2.840.10045.2.1", "1.2.840.10045.2.1");
        this.putService("KeyFactory", "DSA", DsaKeyFactory.class.getName(), "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12");
        this.putService("KeyFactory", "DH", DhKeyFactory.class.getName(), "DiffieHellman", "OID.1.2.840.113549.1.3.1", "1.2.840.113549.1.3.1");
        this.putService("Signature", "SHA1withRSA", RsaDigestSig.Sha1WithRsa.class.getName(), "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5", "OID.1.3.14.3.2.29", "1.3.14.3.2.29");
        this.putService("Signature", "SHA224withRSA", RsaDigestSig.Sha224WithRsa.class.getName(), "OID.1.2.840.113549.1.1.14", "1.2.840.113549.1.1.14");
        this.putService("Signature", "SHA256withRSA", RsaDigestSig.Sha256WithRsa.class.getName(), "OID.1.2.840.113549.1.1.11", "1.2.840.113549.1.1.11");
        this.putService("Signature", "SHA384withRSA", RsaDigestSig.Sha384WithRsa.class.getName(), "OID.1.2.840.113549.1.1.12", "1.2.840.113549.1.1.12");
        this.putService("Signature", "SHA512withRSA", RsaDigestSig.Sha512WithRsa.class.getName(), "OID.1.2.840.113549.1.1.13", "1.2.840.113549.1.1.13");
        this.putService("Signature", "NONEwithRSA", NoDigestSig.NoneWithRsa.class.getName(), new String[0]);
        this.putService("Signature", "SHA1withRSAandMGF1", RsaPssDigestSig.RsaPssSha1.class.getName(), new String[0]);
        this.putService("Signature", "SHA224withRSAandMGF1", RsaPssDigestSig.RsaPssSha224.class.getName(), "SHA224withRSA/PSS");
        this.putService("Signature", "SHA256withRSAandMGF1", RsaPssDigestSig.RsaPssSha256.class.getName(), "SHA256withRSA/PSS");
        this.putService("Signature", "SHA384withRSAandMGF1", RsaPssDigestSig.RsaPssSha384.class.getName(), "SHA384withRSA/PSS");
        this.putService("Signature", "SHA512withRSAandMGF1", RsaPssDigestSig.RsaPssSha512.class.getName(), "SHA512withRSA/PSS");
        this.putService("Signature", "RSASSA-PSS", RsaPssGeneralSig.class.getName(), "PSS", "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10");
        this.putService("Signature", "NONEwithECDSA", NoDigestSig.NoneWithEcdsa.class.getName(), new String[0]);
        this.putService("Signature", "SHA1withECDSA", EcdsaDigestSig.Sha1WithEcdsa.class.getName(), "OID.1.2.840.10045.4.1", "1.2.840.10045.4.1");
        this.putService("Signature", "SHA224withECDSA", EcdsaDigestSig.Sha224WithEcdsa.class.getName(), "OID.1.2.840.10045.4.3.1", "1.2.840.10045.4.3.1");
        this.putService("Signature", "SHA256withECDSA", EcdsaDigestSig.Sha256WithEcdsa.class.getName(), "OID.1.2.840.10045.4.3.2", "1.2.840.10045.4.3.2");
        this.putService("Signature", "SHA384withECDSA", EcdsaDigestSig.Sha384WithEcdsa.class.getName(), "OID.1.2.840.10045.4.3.3", "1.2.840.10045.4.3.3");
        this.putService("Signature", "SHA512withECDSA", EcdsaDigestSig.Sha512WithEcdsa.class.getName(), "OID.1.2.840.10045.4.3.4", "1.2.840.10045.4.3.4");
        this.putService("Signature", "NONEwithDSA", NoDigestSig.NoneWithDsa.class.getName(), "RawDSA");
        this.putService("Signature", "SHA1withDSA", DsaDigestSig.Sha1WithDsa.class.getName(), "DSA", "DSS", "SHA/DSA", "SHA-1/DSA", "SHA1/DSA", "SHAwithDSA", "DSAWithSHA1", "OID.1.2.840.10040.4.3", "1.2.840.10040.4.3", "OID.1.3.14.3.2.13", "1.3.14.3.2.13", "OID.1.3.14.3.2.27", "1.3.14.3.2.27");
        this.putService("Signature", "SHA224withDSA", DsaDigestSig.Sha224WithDsa.class.getName(), "OID.2.16.840.1.101.3.4.3.1", "2.16.840.1.101.3.4.3.1");
        this.putService("Signature", "SHA256withDSA", DsaDigestSig.Sha256WithDsa.class.getName(), "OID.2.16.840.1.101.3.4.3.2", "2.16.840.1.101.3.4.3.2");
        this.putService("Signature", "SHA384withDSA", DsaDigestSig.Sha384WithDsa.class.getName(), "OID.2.16.840.1.101.3.4.3.3", "2.16.840.1.101.3.4.3.3");
        this.putService("Signature", "SHA512withDSA", DsaDigestSig.Sha512WithDsa.class.getName(), "OID.2.16.840.1.101.3.4.3.4", "2.16.840.1.101.3.4.3.4");
        this.putService("Mac", "HmacSHA1", Hmac.HmacSha1.class.getName(), "OID.1.2.840.113549.2.7", "1.2.840.113549.2.7");
        this.putService("Mac", "HmacSHA224", Hmac.HmacSha224.class.getName(), "OID.1.2.840.113549.2.8", "1.2.840.113549.2.8");
        this.putService("Mac", "HmacSHA256", Hmac.HmacSha256.class.getName(), "OID.1.2.840.113549.2.9", "1.2.840.113549.2.9");
        this.putService("Mac", "HmacSHA384", Hmac.HmacSha384.class.getName(), "OID.1.2.840.113549.2.10", "1.2.840.113549.2.10");
        this.putService("Mac", "HmacSHA512", Hmac.HmacSha512.class.getName(), "OID.1.2.840.113549.2.11", "1.2.840.113549.2.11");
        this.putService("Mac", "HmacPBESHA1", PbMac.HmacPbeSha1.class.getName(), new String[0]);
        this.putService("Mac", "HmacPBESHA224", PbMac.HmacPbeSha224.class.getName(), new String[0]);
        this.putService("Mac", "HmacPBESHA256", PbMac.HmacPbeSha256.class.getName(), new String[0]);
        this.putService("Mac", "HmacPBESHA384", PbMac.HmacPbeSha384.class.getName(), new String[0]);
        this.putService("Mac", "HmacPBESHA512", PbMac.HmacPbeSha512.class.getName(), new String[0]);
        this.putService("KeyGenerator", "HmacSHA1", HmacKeyGenerator.HmacSha1.class.getName(), "OID.1.2.840.113549.2.7", "1.2.840.113549.2.7");
        this.putService("KeyGenerator", "HmacSHA224", HmacKeyGenerator.HmacSha224.class.getName(), "OID.1.2.840.113549.2.8", "1.2.840.113549.2.8");
        this.putService("KeyGenerator", "HmacSHA256", HmacKeyGenerator.HmacSha256.class.getName(), "OID.1.2.840.113549.2.9", "1.2.840.113549.2.9");
        this.putService("KeyGenerator", "HmacSHA384", HmacKeyGenerator.HmacSha384.class.getName(), "OID.1.2.840.113549.2.10", "1.2.840.113549.2.10");
        this.putService("KeyGenerator", "HmacSHA512", HmacKeyGenerator.HmacSha512.class.getName(), "OID.1.2.840.113549.2.11", "1.2.840.113549.2.11");
        this.putService("AlgorithmParameters", "EC", EcParameters.class.getName(), "OID.1.2.840.10045.2.1", "1.2.840.10045.2.1");
        this.putService("AlgorithmParameters", "DSA", DsaParameters.class.getName(), "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12");
        this.putService("AlgorithmParameters", "AES", CipherParameters.AesParameters.class.getName(), "OID.2.16.840.1.101.3.4.1", "2.16.840.1.101.3.4.1", "OID.2.16.840.1.101.3.4.1.2", "2.16.840.1.101.3.4.1.2", "OID.2.16.840.1.101.3.4.1.3", "2.16.840.1.101.3.4.1.3", "OID.2.16.840.1.101.3.4.1.4", "2.16.840.1.101.3.4.1.4", "OID.2.16.840.1.101.3.4.1.6", "2.16.840.1.101.3.4.1.6", "OID.2.16.840.1.101.3.4.1.22", "2.16.840.1.101.3.4.1.22", "OID.2.16.840.1.101.3.4.1.23", "2.16.840.1.101.3.4.1.23", "OID.2.16.840.1.101.3.4.1.24", "2.16.840.1.101.3.4.1.24", "OID.2.16.840.1.101.3.4.1.26", "2.16.840.1.101.3.4.1.26", "OID.2.16.840.1.101.3.4.1.42", "2.16.840.1.101.3.4.1.42", "OID.2.16.840.1.101.3.4.1.43", "2.16.840.1.101.3.4.1.43", "OID.2.16.840.1.101.3.4.1.44", "2.16.840.1.101.3.4.1.44", "OID.2.16.840.1.101.3.4.1.46", "2.16.840.1.101.3.4.1.46");
        this.putService("AlgorithmParameters", "DESede", CipherParameters.DESedeParameters.class.getName(), "OID.1.2.840.113549.3.7", "1.2.840.113549.3.7");
        this.putService("AlgorithmParameters", "GCM", GcmParameters.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "OAEP", OaepParameters.class.getName(), "OID.1.2.840.113549.1.1.7", "1.2.840.113549.1.1.7");
        this.putService("AlgorithmParameters", "RSASSA-PSS", PssParameters.class.getName(), "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10");
        this.putService("AlgorithmParameters", "DH", DhParameters.class.getName(), "DiffieHellman", "OID.1.2.840.113549.1.3.1", "1.2.840.113549.1.3.1");
        this.putService("AlgorithmParameters", "PBES2", Pbes2Parameters.PBES2.class.getName(), "OID.1.2.840.113549.1.5.13", " 1.2.840.113549.1.5.13");
        this.putService("AlgorithmParameters", "PBEWithHmacSHA1AndAES_128", Pbes2Parameters.PBEWithHmacSHA1AndAES128.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA224AndAES_128", Pbes2Parameters.PBEWithHmacSHA224AndAES128.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA256AndAES_128", Pbes2Parameters.PBEWithHmacSHA256AndAES128.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA384AndAES_128", Pbes2Parameters.PBEWithHmacSHA384AndAES128.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA512AndAES_128", Pbes2Parameters.PBEWithHmacSHA512AndAES128.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA1AndAES_256", Pbes2Parameters.PBEWithHmacSHA1AndAES256.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA224AndAES_256", Pbes2Parameters.PBEWithHmacSHA224AndAES256.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA256AndAES_256", Pbes2Parameters.PBEWithHmacSHA256AndAES256.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA384AndAES_256", Pbes2Parameters.PBEWithHmacSHA384AndAES256.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithHmacSHA512AndAES_256", Pbes2Parameters.PBEWithHmacSHA512AndAES256.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBE", PbeParameters.class.getName(), new String[0]);
        this.putService("AlgorithmParameters", "PBEWithSHA1AndDESede", PbeParameters.class.getName(), "OID.1.2.840.113549.1.12.1.3", "1.2.840.113549.1.12.1.3");
        this.putService("KeyPairGenerator", "RSA", KeyPairGen.Rsa.class.getName(), "OID.1.2.840.113549.1.1", "1.2.840.113549.1.1", "OID.1.2.840.113549.1.1.1", "1.2.840.113549.1.1.1");
        this.putService("KeyPairGenerator", "RSASSA-PSS", KeyPairGen.Rsa.class.getName(), "PSS", "OID.1.2.840.113549.1.1.10", "1.2.840.113549.1.1.10");
        this.putService("KeyPairGenerator", "EC", KeyPairGen.Ec.class.getName(), "EllipticCurve", "OID.1.2.840.10045.2.1", "1.2.840.10045.2.1");
        this.putService("KeyPairGenerator", "DSA", KeyPairGen.Dsa.class.getName(), "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12");
        this.putService("KeyPairGenerator", "DH", KeyPairGen.Dh.class.getName(), "DiffieHellman", "OID.1.2.840.113549.1.3.1", "1.2.840.113549.1.3.1");
        this.putService("AlgorithmParameterGenerator", "DSA", DsaParamGenerator.class.getName(), "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12");
        this.putService("SecretKeyFactory", "AES", SymmKeyFactory.AES.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "DESede", SymmKeyFactory.DESede.class.getName(), "TripleDES");
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA1", Pbkdf2KeyFactory.SHA1.class.getName(), "PBKDF2WithSHA1", "OID.1.2.840.113549.1.5.12", "1.2.840.113549.1.5.12");
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA224", Pbkdf2KeyFactory.SHA224.class.getName(), "PBKDF2WithSHA224");
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA256", Pbkdf2KeyFactory.SHA256.class.getName(), "PBKDF2WithSHA256");
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA384", Pbkdf2KeyFactory.SHA384.class.getName(), "PBKDF2WithSHA384");
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA512", Pbkdf2KeyFactory.SHA512.class.getName(), "PBKDF2WithSHA512");
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA1and8BIT", Pbkdf2KeyFactory.SHA1_8BIT.class.getName(), "PBKDF2withASCII", "PBKDF2with8BIT");
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA224and8BIT", Pbkdf2KeyFactory.SHA224_8BIT.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA256and8BIT", Pbkdf2KeyFactory.SHA256_8BIT.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA384and8BIT", Pbkdf2KeyFactory.SHA384_8BIT.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBKDF2WithHmacSHA512and8BIT", Pbkdf2KeyFactory.SHA512_8BIT.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBES2", PbeKeyFactory.PBES2.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA1AndAES_128", PbeKeyFactory.PBEWithHmacSHA1AndAES128.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA224AndAES_128", PbeKeyFactory.PBEWithHmacSHA224AndAES128.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA256AndAES_128", PbeKeyFactory.PBEWithHmacSHA256AndAES128.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA384AndAES_128", PbeKeyFactory.PBEWithHmacSHA384AndAES128.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA512AndAES_128", PbeKeyFactory.PBEWithHmacSHA512AndAES128.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA1AndAES_256", PbeKeyFactory.PBEWithHmacSHA1AndAES256.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA224AndAES_256", PbeKeyFactory.PBEWithHmacSHA224AndAES256.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA256AndAES_256", PbeKeyFactory.PBEWithHmacSHA256AndAES256.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA384AndAES_256", PbeKeyFactory.PBEWithHmacSHA384AndAES256.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithHmacSHA512AndAES_256", PbeKeyFactory.PBEWithHmacSHA512AndAES256.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBE", PbeKeyFactory.PBE.class.getName(), new String[0]);
        this.putService("SecretKeyFactory", "PBEWithSHA1AndDESede", PbeKeyFactory.PBEWithSHA1AndDESede.class.getName(), "OID.1.2.840.113549.1.12.1.3", "1.2.840.113549.1.12.1.3");
        this.putService("KeyGenerator", "AES", AesKeyGenerator.class.getName(), "Rijndael", "OID.2.16.840.1.101.3.4.1", "2.16.840.1.101.3.4.1");
        this.putService("KeyGenerator", "AES_128/ECB/NoPadding", AesKeyGenerator.Aes128.class.getName(), "OID.2.16.840.1.101.3.4.1.1", "2.16.840.1.101.3.4.1.1");
        this.putService("KeyGenerator", "AES_192/ECB/NoPadding", AesKeyGenerator.Aes192.class.getName(), "OID.2.16.840.1.101.3.4.1.21", "2.16.840.1.101.3.4.1.21");
        this.putService("KeyGenerator", "AES_256/ECB/NoPadding", AesKeyGenerator.Aes256.class.getName(), "OID.2.16.840.1.101.3.4.1.41", "2.16.840.1.101.3.4.1.41");
        this.putService("KeyGenerator", "AES_128/CBC/PKCS5Padding", AesKeyGenerator.Aes128.class.getName(), "AES_128/CBC/PKCS7Padding", "OID.2.16.840.1.101.3.4.1.2", "2.16.840.1.101.3.4.1.2");
        this.putService("KeyGenerator", "AES_192/CBC/PKCS5Padding", AesKeyGenerator.Aes192.class.getName(), "AES_192/CBC/PKCS7Padding", "OID.2.16.840.1.101.3.4.1.22", "2.16.840.1.101.3.4.1.22");
        this.putService("KeyGenerator", "AES_256/CBC/PKCS5Padding", AesKeyGenerator.Aes256.class.getName(), "AES_256/CBC/PKCS7Padding", "OID.2.16.840.1.101.3.4.1.42", "2.16.840.1.101.3.4.1.42");
        this.putService("KeyGenerator", "AES_128/OFB/NoPadding", AesKeyGenerator.Aes128.class.getName(), "OID.2.16.840.1.101.3.4.1.3", "2.16.840.1.101.3.4.1.3");
        this.putService("KeyGenerator", "AES_192/OFB/NoPadding", AesKeyGenerator.Aes192.class.getName(), "OID.2.16.840.1.101.3.4.1.23", "2.16.840.1.101.3.4.1.23");
        this.putService("KeyGenerator", "AES_256/OFB/NoPadding", AesKeyGenerator.Aes256.class.getName(), "OID.2.16.840.1.101.3.4.1.43", "2.16.840.1.101.3.4.1.43");
        this.putService("KeyGenerator", "AES_128/CFB/NoPadding", AesKeyGenerator.Aes128.class.getName(), "OID.2.16.840.1.101.3.4.1.4", "2.16.840.1.101.3.4.1.4");
        this.putService("KeyGenerator", "AES_192/CFB/NoPadding", AesKeyGenerator.Aes192.class.getName(), "OID.2.16.840.1.101.3.4.1.24", "2.16.840.1.101.3.4.1.24");
        this.putService("KeyGenerator", "AES_256/CFB/NoPadding", AesKeyGenerator.Aes256.class.getName(), "OID.2.16.840.1.101.3.4.1.44", "2.16.840.1.101.3.4.1.44");
        this.putService("KeyGenerator", "AES_128/GCM/NoPadding", AesKeyGenerator.Aes128.class.getName(), "OID.2.16.840.1.101.3.4.1.6", "2.16.840.1.101.3.4.1.6");
        this.putService("KeyGenerator", "AES_192/GCM/NoPadding", AesKeyGenerator.Aes192.class.getName(), "OID.2.16.840.1.101.3.4.1.26", "2.16.840.1.101.3.4.1.26");
        this.putService("KeyGenerator", "AES_256/GCM/NoPadding", AesKeyGenerator.Aes256.class.getName(), "OID.2.16.840.1.101.3.4.1.46", "2.16.840.1.101.3.4.1.46");
        this.putService("KeyGenerator", "DESede", DESedeKeyGenerator.class.getName(), "TripleDES", "OID.1.2.840.113549.3.7", "1.2.840.113549.3.7");
        this.putService("KeyGenerator", "SunTls12Prf", TlsPrfGenerator.class.getName(), "IbmTls12Prf");
        this.putService("KeyGenerator", "SunTlsMasterSecret", TlsMasterSecretGenerator.class.getName(), "SunTls12MasterSecret", "SunTlsExtendedMasterSecret", "IbmTlsMasterSecret", "IbmTls12MasterSecret", "IbmTlsExtendedMasterSecret");
        this.putService("KeyGenerator", "SunTlsKeyMaterial", TlsKeyMaterialGenerator.class.getName(), "SunTls12KeyMaterial", "IbmTlsKeyMaterial", "IbmTls12KeyMaterial");
        this.putService("KeyGenerator", "SunTlsRsaPremasterSecret", TlsRsaPremasterSecretGenerator.class.getName(), "SunTls12RsaPremasterSecret", "IbmTlsRsaPremasterSecret", "IbmTls12RsaPremasterSecret");
        this.putService("KeyAgreement", "ECDH", KeyAgree.ECDH.class.getName(), new HashMap<String, String>(), new String[0]);
        this.putService("KeyAgreement", "DH", KeyAgree.DH.class.getName(), "DiffieHellman", "OID.1.2.840.113549.1.3.1", "1.2.840.113549.1.3.1");
        HashMap<String, String> threadSafeAttr = new HashMap<String, String>();
        threadSafeAttr.put("ThreadSafe", "true");
        this.putService("SecureRandom", "DRBG", Drbg.class.getName(), threadSafeAttr, "Default", "DefaultRandom", "SHA1PRNG", "CTRDRBG", "CTRDRBG128", "NativePRNG", "NativePRNGNonBlocking");
        this.putKeyStore();
    }

    private void putKeyStore() {
        try {
            Class<?> clz = Class.forName("com.oracle.jipher.pki.internal.Pkcs12KeyStoreSpi");
            this.putService("KeyStore", "PKCS12", clz.getName(), new String[0]);
        }
        catch (ClassNotFoundException e) {
            DEBUG_PROV.println("No PKCS12 KeyStore to add since com.oracle.jipher.pki.internal.Pkcs12KeyStoreSpi class not found");
        }
    }

    private void putService(String type, String alg, String className, String ... aliases) {
        if (type.equals("SecureRandom")) {
            this.putLegacy(type, alg, className, Arrays.asList(aliases), new HashMap<String, String>());
        } else {
            this.putService(new Provider.Service(this, type, alg, className, Arrays.asList(aliases), null));
        }
    }

    private void putService(String type, String alg, String className, Map<String, String> attrs, String ... aliases) {
        if (type.equals("SecureRandom")) {
            this.putLegacy(type, alg, className, Arrays.asList(aliases), attrs);
        } else {
            this.putService(new Provider.Service(this, type, alg, className, Arrays.asList(aliases), attrs));
        }
    }

    private void putLegacy(String type, String alg, String className, List<String> aliases, Map<String, String> attrs) {
        this.put(type + "." + alg, className);
        aliases.forEach((? super T alias) -> this.put("Alg.Alias." + type + "." + alias, alg));
        attrs.forEach((? super K key, ? super V value) -> this.put(type + "." + alg + " " + key, value));
    }

    public boolean runSelfTest() {
        return OpenSslValidator.runSelfTest();
    }

    public boolean isFipsValid() {
        return OpenSslValidator.isFipsValid();
    }

    @Override
    public Provider.Service getService(String type, String algorithm) {
        Provider.Service service = super.getService(type, algorithm);
        DEBUG_ALG.println(() -> "Getting algorithm: " + (service != null ? service.toString() : type + "." + algorithm + " (not supported)"));
        return service;
    }

    public static void main(String[] args) {
        try {
            System.out.println(new JipherJCE().getInfo());
        }
        catch (ProviderException e) {
            System.out.println(JipherJCE.info(false));
            System.err.print("OpenSSL version information unavailable due to ");
            e.printStackTrace();
        }
    }
}

