/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import com.oracle.jipher.internal.spi.DigestSignature;
import com.oracle.jipher.internal.spi.RsaKeyFactory;

public abstract class RsaDigestSig
extends DigestSignature {
    RsaDigestSig(MdAlg md) {
        super(md);
    }

    @Override
    AsymKeyFactory getKeyFactory() {
        return new RsaKeyFactory();
    }

    public static final class Sha512WithRsa
    extends RsaDigestSig {
        public Sha512WithRsa() {
            super(MdAlg.SHA512);
        }
    }

    public static final class Sha384WithRsa
    extends RsaDigestSig {
        public Sha384WithRsa() {
            super(MdAlg.SHA384);
        }
    }

    public static final class Sha256WithRsa
    extends RsaDigestSig {
        public Sha256WithRsa() {
            super(MdAlg.SHA256);
        }
    }

    public static final class Sha224WithRsa
    extends RsaDigestSig {
        public Sha224WithRsa() {
            super(MdAlg.SHA224);
        }
    }

    public static final class Sha1WithRsa
    extends RsaDigestSig {
        public Sha1WithRsa() {
            super(MdAlg.SHA1);
        }
    }
}

