/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.spi.RsaParameters;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public final class PssParameters
extends RsaParameters {
    private PSSParameterSpec pssSpec;

    @Override
    protected byte[] engineGetEncoded() {
        Asn1BerValue hashAlgorithm = this.hashAlgToBer(this.pssSpec.getDigestAlgorithm());
        Asn1BerValue maskGenAlgorithm = this.mgfToBer((MGF1ParameterSpec)this.pssSpec.getMGFParameters());
        Asn1BerValue saltLength = null;
        if (this.pssSpec.getSaltLength() != 20) {
            saltLength = Asn1.explicit(2).newInteger(this.pssSpec.getSaltLength());
        }
        Asn1BerValue trailerField = null;
        if (this.pssSpec.getTrailerField() != 1) {
            trailerField = Asn1.explicit(3).newInteger(this.pssSpec.getTrailerField());
        }
        Asn1BerValue rsaPssParams = Asn1.newSequence(hashAlgorithm, maskGenAlgorithm, saltLength, trailerField);
        return rsaPssParams.encodeDerOctets();
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            Asn1BerValue[] pssParams = PssParameters.decodeParams(4, params);
            String hash = this.getHashAlg(pssParams[0]);
            MGF1ParameterSpec mgfSpec = this.getMgf1Spec(pssParams[1]);
            Asn1BerValue saltLength = pssParams[2];
            int saltLen = saltLength == null ? 20 : saltLength.getInteger().intValueExact();
            Asn1BerValue trailerField = pssParams[3];
            int tf = trailerField == null ? 1 : trailerField.getInteger().intValueExact();
            this.pssSpec = new PSSParameterSpec(hash, "MGF1", mgfSpec, saltLen, tf);
        }
        catch (Asn1DecodeException ex) {
            throw new IOException("Invalid PSS parameters", ex);
        }
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec != null && paramSpec.isAssignableFrom(PSSParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.pssSpec));
        }
        throw new InvalidParameterSpecException("Expected ParameterSpec class to be assignable from PSSParameterSpec");
    }

    @Override
    protected String engineToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RSASSA-PSS Parameters [ ");
        sb.append(this.pssSpec.toString());
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter spec, expected PSSParameterSpec");
        }
        PSSParameterSpec pSpec = (PSSParameterSpec)paramSpec;
        if (!pSpec.getMGFAlgorithm().equals("MGF1")) {
            throw new InvalidParameterSpecException("Only MGF1 supported.");
        }
        if (!(pSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Unsupported MGF parameters: only MGF1ParameterSpec supported.");
        }
        this.pssSpec = pSpec;
    }
}

