/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.key.JceDsaPrivateKey;
import com.oracle.jipher.internal.key.JceDsaPublicKey;
import com.oracle.jipher.internal.key.JceEcPrivateKey;
import com.oracle.jipher.internal.key.JceEcPublicKey;
import com.oracle.jipher.internal.key.JceRsaPrivateKey;
import com.oracle.jipher.internal.key.JceRsaPublicKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyCtx;
import com.oracle.jipher.internal.spi.DsaKeyFactory;
import com.oracle.jipher.internal.spi.EcKeyFactory;
import com.oracle.jipher.internal.spi.RsaKeyFactory;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public abstract class NoDigestSig
extends SignatureSpi {
    private ByteArrayOutputStream tbs;
    private Pkey lastPkey;

    void doInit(Pkey pkey) {
        this.cleanup();
        this.lastPkey = pkey;
        this.tbs = new ByteArrayOutputStream();
    }

    private void cleanup() {
        this.tbs = null;
    }

    private void initIfRequired() {
        if (this.tbs == null) {
            this.doInit(this.lastPkey);
        }
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        this.initIfRequired();
        this.tbs.write(data, off, len);
    }

    @Override
    protected void engineUpdate(byte b) {
        this.engineUpdate(new byte[]{b}, 0, 1);
    }

    @Override
    public byte[] engineSign() throws SignatureException {
        byte[] byArray;
        this.initIfRequired();
        PkeyCtx.Signature ctx = null;
        try {
            ctx = new PkeyCtx.Signature(this.lastPkey);
            byte[] bb = this.tbs.toByteArray();
            if (bb.length == 0) {
                throw new SignatureException("No input bytes.");
            }
            ctx.signInit();
            byArray = ctx.sign(bb, 0, bb.length);
        }
        catch (InvalidKeyException e) {
            try {
                throw new SignatureException(e);
            }
            catch (Throwable throwable) {
                PkeyCtx.free(ctx);
                this.cleanup();
                throw throwable;
            }
        }
        PkeyCtx.free(ctx);
        this.cleanup();
        return byArray;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] sigBytes, int offset, int len) {
        boolean bl;
        this.initIfRequired();
        PkeyCtx.Signature ctx = null;
        try {
            ctx = new PkeyCtx.Signature(this.lastPkey);
            byte[] bb = this.tbs.toByteArray();
            ctx.verifyInit();
            bl = ctx.verify(sigBytes, offset, len, bb, 0, bb.length);
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                PkeyCtx.free(ctx);
                this.cleanup();
                throw throwable;
            }
            PkeyCtx.free(ctx);
            this.cleanup();
            return bl2;
        }
        PkeyCtx.free(ctx);
        this.cleanup();
        return bl;
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        return this.engineVerify(sigBytes, 0, sigBytes.length);
    }

    public static final class NoneWithDsa
    extends NoDigestSig {
        private final DsaKeyFactory kf = new DsaKeyFactory();

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            JceDsaPrivateKey prv = (JceDsaPrivateKey)this.kf.engineTranslateKey(privateKey);
            this.doInit(prv.getPkey());
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            JceDsaPublicKey pub = (JceDsaPublicKey)this.kf.engineTranslateKey(publicKey);
            this.doInit(pub.getPkey());
        }
    }

    public static final class NoneWithEcdsa
    extends NoDigestSig {
        private final EcKeyFactory kf = new EcKeyFactory();

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            JceEcPrivateKey prv = (JceEcPrivateKey)this.kf.engineTranslateKey(privateKey);
            this.doInit(prv.getPkey());
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            JceEcPublicKey pub = (JceEcPublicKey)this.kf.engineTranslateKey(publicKey);
            this.doInit(pub.getPkey());
        }
    }

    public static final class NoneWithRsa
    extends NoDigestSig {
        private final RsaKeyFactory kf = new RsaKeyFactory();

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            JceRsaPrivateKey prv = (JceRsaPrivateKey)this.kf.engineTranslateKey(privateKey);
            this.doInit(prv.getPkey());
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            JceRsaPublicKey pub = (JceRsaPublicKey)this.kf.engineTranslateKey(publicKey);
            this.doInit(pub.getPkey());
        }
    }
}

