/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.InputChecks;
import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Fips;
import com.oracle.jipher.internal.key.JceDhPrivateKey;
import com.oracle.jipher.internal.key.JceDhPublicKey;
import com.oracle.jipher.internal.key.JceDsaPrivateKey;
import com.oracle.jipher.internal.key.JceDsaPublicKey;
import com.oracle.jipher.internal.key.JceEcPrivateKey;
import com.oracle.jipher.internal.key.JceEcPublicKey;
import com.oracle.jipher.internal.key.JceRsaPrivateKey;
import com.oracle.jipher.internal.key.JceRsaPublicKey;
import com.oracle.jipher.internal.openssl.EcCurve;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyCtx;
import com.oracle.jipher.internal.spi.DhParamCache;
import com.oracle.jipher.internal.spi.DsaParamCache;
import com.oracle.jipher.internal.spi.KeySizeConfiguration;
import com.oracle.jipher.internal.spi.NamedCurves;
import com.oracle.jipher.provider.DHFIPSParameterSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public abstract class KeyPairGen
extends KeyPairGenerator {
    KeyPairGen(String alg) {
        super(alg);
    }

    abstract PkeyCtx.KeyGen createKeyGen();

    abstract PublicKey createPublicKey(Pkey var1) throws InvalidKeyException;

    abstract PrivateKey createPrivateKey(Pkey var1) throws InvalidKeyException;

    @Override
    public KeyPair generateKeyPair() {
        PkeyCtx.KeyGen ctx = this.createKeyGen();
        Pkey[] privPubKp = null;
        try {
            privPubKp = ctx.generate();
            KeyPair keyPair = new KeyPair(this.createPublicKey(privPubKp[1]), this.createPrivateKey(privPubKp[0]));
            return keyPair;
        }
        catch (InvalidKeyException e) {
            Pkey.free(privPubKp);
            throw new ProviderException(e);
        }
        finally {
            ctx.free();
        }
    }

    protected void validate(String algo, int ... keySize) {
        try {
            Fips.enforcement().checkStrength(CryptoOp.KEYGEN, algo, keySize);
        }
        catch (ProviderException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    public static final class Dh
    extends KeyPairGen {
        private DHParameterSpec dhParams;

        public Dh() {
            super("DH");
            this.initialize(KeySizeConfiguration.getDHKeySize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        PkeyCtx.KeyGen createKeyGen() {
            PkeyCtx.DhKeyGen dhKeyGen;
            Pkey pkey = null;
            try {
                DHParameterSpec dhSpec;
                if (this.dhParams instanceof DHFIPSParameterSpec) {
                    dhSpec = (DHFIPSParameterSpec)this.dhParams;
                    byte[] q = ((DHFIPSParameterSpec)dhSpec).getQ() == null ? null : ((DHFIPSParameterSpec)dhSpec).getQ().toByteArray();
                    pkey = Pkey.newDhParams(dhSpec.getP().toByteArray(), q, dhSpec.getG().toByteArray());
                } else {
                    dhSpec = this.dhParams;
                    pkey = Pkey.newDhParams(dhSpec.getP().toByteArray(), null, dhSpec.getG().toByteArray());
                }
                dhKeyGen = new PkeyCtx.DhKeyGen(pkey);
            }
            catch (Throwable throwable) {
                Pkey.free(pkey);
                throw throwable;
            }
            Pkey.free(pkey);
            return dhKeyGen;
        }

        @Override
        PrivateKey createPrivateKey(Pkey priv) throws InvalidKeyException {
            return new JceDhPrivateKey(priv);
        }

        @Override
        PublicKey createPublicKey(Pkey pub) throws InvalidKeyException {
            return new JceDhPublicKey(pub, null);
        }

        @Override
        public void initialize(int keysize, SecureRandom random) {
            this.dhParams = DhParamCache.get(keysize);
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params == null) {
                throw new InvalidAlgorithmParameterException();
            }
            if (params instanceof DHParameterSpec) {
                DHParameterSpec spec = (DHParameterSpec)params;
                if (InputChecks.isNullOrZero(spec.getP(), spec.getG())) {
                    throw new InvalidAlgorithmParameterException("P, G must be non-null, non-zero values.");
                }
                this.validate("DH", spec.getP().bitLength());
                this.dhParams = spec;
            } else if (params instanceof DSAParameterSpec) {
                DSAParameterSpec dsaParams = (DSAParameterSpec)params;
                if (InputChecks.isNullOrZero(dsaParams.getP(), dsaParams.getG(), dsaParams.getQ())) {
                    throw new InvalidAlgorithmParameterException("P, Q, G must be non-null, non-zero values.");
                }
                this.validate("DSA", dsaParams.getP().bitLength(), dsaParams.getQ().bitLength());
                this.dhParams = new DHFIPSParameterSpec(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
            } else {
                throw new InvalidAlgorithmParameterException("Expected DHParameterSpec or DSAParameterSpec");
            }
        }
    }

    public static final class Dsa
    extends KeyPairGen {
        private DSAParameterSpec dsaParams;

        public Dsa() {
            super("DSA");
            this.initialize(KeySizeConfiguration.getDSAKeySize());
        }

        @Override
        PkeyCtx.KeyGen createKeyGen() {
            PkeyCtx.DsaKeyGen dsaKeyGen;
            Pkey pkey = null;
            try {
                pkey = Pkey.newDsaParams(this.dsaParams.getP().toByteArray(), this.dsaParams.getQ().toByteArray(), this.dsaParams.getG().toByteArray());
                dsaKeyGen = new PkeyCtx.DsaKeyGen(pkey);
            }
            catch (Throwable throwable) {
                Pkey.free(pkey);
                throw throwable;
            }
            Pkey.free(pkey);
            return dsaKeyGen;
        }

        @Override
        PrivateKey createPrivateKey(Pkey priv) throws InvalidKeyException {
            return new JceDsaPrivateKey(priv);
        }

        @Override
        PublicKey createPublicKey(Pkey pub) throws InvalidKeyException {
            return new JceDsaPublicKey(pub, null);
        }

        @Override
        public void initialize(int keysize, SecureRandom random) {
            this.validate("DSA", keysize);
            this.dsaParams = DsaParamCache.get(keysize);
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            DSAParameterSpec dsaParams;
            if (params == null) {
                throw new InvalidAlgorithmParameterException();
            }
            if (params instanceof DSAParameterSpec) {
                dsaParams = (DSAParameterSpec)params;
                if (InputChecks.isNullOrZero(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG())) {
                    throw new InvalidAlgorithmParameterException("P, Q and G must all be non-null and non-zero values");
                }
            } else {
                throw new InvalidAlgorithmParameterException("Expected DSAParameterSpec");
            }
            this.validate("DSA", dsaParams.getP().bitLength(), dsaParams.getQ().bitLength());
            this.dsaParams = (DSAParameterSpec)params;
        }
    }

    public static final class Ec
    extends KeyPairGen {
        private EcCurve curveId;

        public Ec() {
            super("EC");
            this.initialize(KeySizeConfiguration.getECKeySize(), null);
        }

        @Override
        PkeyCtx.KeyGen createKeyGen() {
            PkeyCtx.EcKeyGen ecKeyGen;
            Pkey pkey = null;
            try {
                pkey = Pkey.newEcParams(this.curveId);
                ecKeyGen = new PkeyCtx.EcKeyGen(pkey);
            }
            catch (Throwable throwable) {
                Pkey.free(pkey);
                throw throwable;
            }
            Pkey.free(pkey);
            return ecKeyGen;
        }

        @Override
        PublicKey createPublicKey(Pkey pub) throws InvalidKeyException {
            return new JceEcPublicKey(pub, null);
        }

        @Override
        PrivateKey createPrivateKey(Pkey priv) throws InvalidKeyException {
            return new JceEcPrivateKey(priv);
        }

        @Override
        public void initialize(int keysize, SecureRandom random) {
            this.validate("EC", keysize);
            this.curveId = this.determineCurve(keysize);
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params == null) {
                throw new InvalidAlgorithmParameterException();
            }
            this.curveId = this.determineCurve(params);
            if (this.curveId == null) {
                throw new InvalidAlgorithmParameterException("curve not supported");
            }
            this.validate("EC", this.curveId.keyBits());
        }

        EcCurve determineCurve(int keySize) throws InvalidParameterException {
            switch (keySize) {
                case 224: {
                    return EcCurve.secp224r1;
                }
                case 256: {
                    return EcCurve.secp256r1;
                }
                case 384: {
                    return EcCurve.secp384r1;
                }
                case 521: {
                    return EcCurve.secp521r1;
                }
            }
            throw new InvalidParameterException("No EC parameters available for key size " + keySize + ", supported=224,256,384,521");
        }

        EcCurve determineCurve(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
            if (spec instanceof ECGenParameterSpec) {
                return NamedCurves.lookup((ECGenParameterSpec)spec);
            }
            if (spec instanceof ECParameterSpec) {
                return NamedCurves.lookup((ECParameterSpec)spec);
            }
            throw new InvalidAlgorithmParameterException("Only ECGenParameterSpec and ECParameterSpec supported.");
        }
    }

    public static final class Rsa
    extends KeyPairGen {
        private int modulusSize = KeySizeConfiguration.getRSAKeySize();
        private BigInteger pubExp;

        public Rsa() {
            super("RSA");
        }

        @Override
        PkeyCtx.KeyGen createKeyGen() {
            PkeyCtx.RsaKeyGen ctx = new PkeyCtx.RsaKeyGen();
            ctx.setParams(this.modulusSize, this.pubExp == null ? null : this.pubExp.toByteArray());
            return ctx;
        }

        @Override
        PublicKey createPublicKey(Pkey pub) throws InvalidKeyException {
            return new JceRsaPublicKey(pub, null);
        }

        @Override
        PrivateKey createPrivateKey(Pkey priv) throws InvalidKeyException {
            return new JceRsaPrivateKey(priv);
        }

        @Override
        public void initialize(int keysize, SecureRandom random) {
            if (keysize <= 0) {
                throw new InvalidParameterException("invalid key size");
            }
            this.validate("RSA", keysize);
            this.modulusSize = keysize;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params == null) {
                throw new InvalidAlgorithmParameterException();
            }
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            RSAKeyGenParameterSpec kgParams = (RSAKeyGenParameterSpec)params;
            if (kgParams.getKeysize() <= 0) {
                throw new InvalidAlgorithmParameterException("invalid key size");
            }
            this.validate("RSA", kgParams.getKeysize());
            this.modulusSize = kgParams.getKeysize();
            this.pubExp = kgParams.getPublicExponent();
        }
    }
}

