/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceEcPrivateKey;
import com.oracle.jipher.internal.key.JceEcPublicKey;
import com.oracle.jipher.internal.openssl.EcCurve;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyType;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import com.oracle.jipher.internal.spi.NamedCurves;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import com.oracle.jipher.internal.tools.asn1.UniversalTag;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class EcKeyFactory
extends AsymKeyFactory {
    private static final Asn1BerValue ID_EC_PUBLIC_KEY = Asn1.newOid("1.2.840.10045.2.1");
    private static final int POINT_INFINITY = 0;
    private static final int UNCOMPRESSED = 4;

    @Override
    PkeyType getPkeyType() {
        return PkeyType.EC;
    }

    @Override
    PrivateKey createPrivateKey(Pkey pkey) throws InvalidKeyException {
        return new JceEcPrivateKey(pkey);
    }

    @Override
    PublicKey createPublicKey(Pkey pkey, byte[] pubDer) throws InvalidKeyException {
        return new JceEcPublicKey(pkey, pubDer);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec ecSpec = (ECPrivateKeySpec)keySpec;
            try {
                return this.generatePrivateInternal(ecSpec.getS(), Optional.empty(), ecSpec.getParams());
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        return super.engineGeneratePrivate(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateKey generatePrivateInternal(BigInteger priv, Optional<ECPoint> point, ECParameterSpec params) throws InvalidKeyException {
        Pkey pkey;
        EcCurve curve = NamedCurves.lookup(params);
        if (curve == null) {
            throw new InvalidKeyException("Unsupported ECParameterSpec");
        }
        byte[] privVal = priv.toByteArray();
        try {
            pkey = Pkey.newEcPriv(curve, privVal);
        }
        finally {
            Util.clearArray(privVal);
        }
        return new JceEcPrivateKey(pkey, priv, point, params);
    }

    @Override
    PrivateKey generatePrivateInternal(byte[] privDer) throws InvalidKeyException {
        ECPrivateKeyWithPublicSpec ecPrivKeySpec;
        try {
            ecPrivKeySpec = EcKeyFactory.ecPrivDerDecode(privDer);
        }
        finally {
            Util.clearArray(privDer);
        }
        return this.generatePrivateInternal(ecPrivKeySpec.getS(), ecPrivKeySpec.getPublicPoint(), ecPrivKeySpec.getParams());
    }

    private static ECPrivateKeyWithPublicSpec ecPrivDerDecode(byte[] privDer) throws InvalidKeyException {
        try {
            Optional<ECPoint> point;
            String innerCurveOid;
            Asn1BerValue ecPrivKey = Asn1.decodeOne(privDer).count(3);
            Util.assertAllUniversal(ecPrivKey);
            List<Asn1BerValue> ecPrivKeyValues = ecPrivKey.sequence();
            BigInteger privKeyInfoVer = ecPrivKeyValues.get(0).getInteger();
            if (!privKeyInfoVer.equals(BigInteger.ZERO)) {
                throw new Asn1DecodeException("Invalid PrivateKeyInfo version; was: " + privKeyInfoVer + ", expected: 0");
            }
            List<Asn1BerValue> algId = ecPrivKeyValues.get(1).count(2).sequence();
            Asn1BerValue algorithm = algId.get(0);
            if (!algorithm.equals(ID_EC_PUBLIC_KEY)) {
                throw new Asn1DecodeException("Unsupported key algorithm; was: " + algorithm.getOid() + ", expected: " + ID_EC_PUBLIC_KEY.getOid());
            }
            String curveOid = algId.get(1).getOid();
            ECParameterSpec params = NamedCurves.lookup(curveOid);
            if (params == null) {
                throw new InvalidKeyException("Unsupported EC curve: " + curveOid);
            }
            Asn1BerValue ecPrivateKey = Asn1.decodeOne(ecPrivKeyValues.get(2).getOctetString()).count(2, 4);
            Util.assertUniversal(ecPrivateKey);
            List<Asn1BerValue> keyValues = ecPrivateKey.sequence();
            BigInteger ecPrivKeyVer = keyValues.get(0).tag(UniversalTag.INTEGER).getInteger();
            if (!ecPrivKeyVer.equals(BigInteger.ONE)) {
                throw new InvalidKeyException("Invalid ECPrivateKey version; was: " + ecPrivKeyVer + ", expected: 1");
            }
            BigInteger priv = EcKeyFactory.decodePrivateValue(keyValues.get(1).tag(UniversalTag.OCTET_STRING).getOctetString(), params);
            int index = 2;
            if (index < keyValues.size() && keyValues.get(index).hasTag(0) && !(innerCurveOid = keyValues.get(index++).explicit().tag(UniversalTag.OBJECT_IDENTIFIER).getOid()).equals(curveOid)) {
                throw new InvalidKeyException("ECPrivateKey curve OID " + innerCurveOid + " doesn't match PKCS #8 curve OID " + curveOid);
            }
            if (index < keyValues.size() && keyValues.get(index).hasTag(1)) {
                byte[] encodedPoint = keyValues.get(index++).explicit().tag(UniversalTag.BIT_STRING).getBitStringOctets();
                point = Optional.of(EcKeyFactory.decodePoint(encodedPoint, params));
            } else {
                point = Optional.empty();
            }
            if (index != keyValues.size()) {
                throw new InvalidKeyException("Invalid ECPrivateKey encoding; unsupported elements");
            }
            return new ECPrivateKeyWithPublicSpec(priv, point, params);
        }
        catch (Asn1DecodeException ex) {
            throw new InvalidKeyException("Unable to decode EC Private Key", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigInteger decodePrivateValue(byte[] privateValue, ECParameterSpec params) throws InvalidKeyException {
        try {
            int pLen = (params.getOrder().bitLength() + 7) / 8;
            if (privateValue.length != pLen) {
                throw new InvalidKeyException("Invalid privateKey length; expected " + pLen + ", was " + privateValue.length);
            }
            BigInteger bigInteger = new BigInteger(1, privateValue);
            return bigInteger;
        }
        finally {
            Util.clearArray(privateValue);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPublicKeySpec) {
            ECPublicKeySpec ecSpec = (ECPublicKeySpec)keySpec;
            try {
                return this.generatePublicInternal(ecSpec.getW(), ecSpec.getParams(), null);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        return super.engineGeneratePublic(keySpec);
    }

    PublicKey generatePublicInternal(ECPoint point, ECParameterSpec params, byte[] pubDer) throws InvalidKeyException {
        EcCurve curve = NamedCurves.lookup(params);
        if (curve == null) {
            throw new InvalidKeyException("Unsupported ECParameterSpec");
        }
        Pkey pkey = Pkey.newEcPub(curve, point.getAffineX().toByteArray(), point.getAffineY().toByteArray());
        return new JceEcPublicKey(pkey, point, params, pubDer);
    }

    @Override
    PublicKey generatePublicInternal(byte[] pubDer) throws InvalidKeyException {
        ECPublicKeySpec ecPubKeySpec = EcKeyFactory.ecPubDerDecode(pubDer);
        return this.generatePublicInternal(ecPubKeySpec.getW(), ecPubKeySpec.getParams(), pubDer);
    }

    private static ECPublicKeySpec ecPubDerDecode(byte[] pubDer) throws InvalidKeyException {
        try {
            Asn1BerValue ecPubKey = Asn1.decodeOne(pubDer).count(2);
            Util.assertAllUniversal(ecPubKey);
            List<Asn1BerValue> ecPubKeyValues = ecPubKey.sequence();
            List<Asn1BerValue> algId = ecPubKeyValues.get(0).count(2).sequence();
            Asn1BerValue algorithm = algId.get(0);
            if (!algorithm.equals(ID_EC_PUBLIC_KEY)) {
                throw new Asn1DecodeException("Unsupported key algorithm; was: " + algorithm.getOid() + ", expected: " + ID_EC_PUBLIC_KEY.getOid());
            }
            String curveOid = algId.get(1).getOid();
            ECParameterSpec params = NamedCurves.lookup(curveOid);
            if (params == null) {
                throw new InvalidKeyException("Unsupported EC curve: " + curveOid);
            }
            byte[] encodedPoint = ecPubKeyValues.get(1).getBitStringOctets();
            return new ECPublicKeySpec(EcKeyFactory.decodePoint(encodedPoint, params), params);
        }
        catch (Asn1DecodeException ex) {
            throw new InvalidKeyException("Unable to decode EC Public Key", ex);
        }
    }

    private static ECPoint decodePoint(byte[] encodedPoint, ECParameterSpec params) throws InvalidKeyException {
        int fLen = (params.getCurve().getField().getFieldSize() + 7) / 8;
        if (encodedPoint.length == 1 && encodedPoint[0] == 0) {
            return ECPoint.POINT_INFINITY;
        }
        if (encodedPoint.length == 1 + fLen) {
            throw new InvalidKeyException("Compressed EC Point format is not supported");
        }
        if (encodedPoint.length == 1 + 2 * fLen && encodedPoint[0] == 4) {
            byte[] x = Arrays.copyOfRange(encodedPoint, 1, 1 + fLen);
            byte[] y = Arrays.copyOfRange(encodedPoint, 1 + fLen, encodedPoint.length);
            return new ECPoint(new BigInteger(1, x), new BigInteger(1, y));
        }
        throw new InvalidKeyException("Unsupported or invalid public EC point encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        Key osslKey;
        try {
            osslKey = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException var4) {
            throw new InvalidKeySpecException(var4);
        }
        if (osslKey instanceof ECPublicKey) {
            if (keySpec != null && keySpec.isAssignableFrom(ECPublicKeySpec.class)) {
                return (T)((KeySpec)keySpec.cast(new ECPublicKeySpec(((ECPublicKey)osslKey).getW(), ((ECPublicKey)osslKey).getParams())));
            }
            if (keySpec != null && keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(osslKey.getEncoded())));
            }
            throw new InvalidKeySpecException("Expected KeySpec class to be assignable from either ECPublicKeySpec or X509EncodedKeySpec");
        }
        if (osslKey instanceof ECPrivateKey) {
            if (keySpec != null && keySpec.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                byte[] der = key.getEncoded();
                try {
                    KeySpec keySpec2 = (KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(der));
                    return (T)keySpec2;
                }
                finally {
                    Util.clearArray(der);
                }
            }
            if (keySpec != null && keySpec.isAssignableFrom(ECPrivateKeySpec.class)) {
                return (T)((KeySpec)keySpec.cast(new ECPrivateKeySpec(((ECPrivateKey)osslKey).getS(), ((ECPrivateKey)osslKey).getParams())));
            }
            throw new InvalidKeySpecException("Expected KeySpec class to be assignable from either PKCS8EncodedKeySpec or ECPrivateKeySpec");
        }
        throw new InvalidKeySpecException("Could not getKeySpec for given key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof JceEcPublicKey || key instanceof JceEcPrivateKey) {
            return key;
        }
        if (key instanceof PrivateKey) {
            return this.translatePrivate((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return this.translatePublic((PublicKey)key);
        }
        throw new InvalidKeyException("Could not translate to EC key");
    }

    static class ECPrivateKeyWithPublicSpec
    extends ECPrivateKeySpec {
        private final Optional<ECPoint> point;

        ECPrivateKeyWithPublicSpec(BigInteger s, Optional<ECPoint> point, ECParameterSpec params) {
            super(s, params);
            this.point = point;
        }

        Optional<ECPoint> getPublicPoint() {
            return this.point;
        }
    }
}

