/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.InputChecks;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceDsaPrivateKey;
import com.oracle.jipher.internal.key.JceDsaPublicKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyType;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import com.oracle.jipher.internal.tools.asn1.UniversalTag;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;

public final class DsaKeyFactory
extends AsymKeyFactory {
    private static final Asn1BerValue ID_DSA = Asn1.newOid("1.2.840.10040.4.1");

    @Override
    PkeyType getPkeyType() {
        return PkeyType.DSA;
    }

    @Override
    PrivateKey createPrivateKey(Pkey pkey) throws InvalidKeyException {
        return new JceDsaPrivateKey(pkey);
    }

    @Override
    PublicKey createPublicKey(Pkey pkey, byte[] pubDer) throws InvalidKeyException {
        return new JceDsaPublicKey(pkey, pubDer);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec spec = (DSAPrivateKeySpec)keySpec;
            if (InputChecks.isNullOrZero(spec.getP(), spec.getQ(), spec.getG(), spec.getX())) {
                throw new InvalidKeySpecException("Key spec parameters must not be null or ZERO");
            }
            try {
                return this.generatePrivateInternal(spec);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        return super.engineGeneratePrivate(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateKey generatePrivateInternal(DSAPrivateKeySpec spec) throws InvalidKeyException {
        Pkey pkey;
        byte[] privVal = spec.getX().toByteArray();
        try {
            pkey = Pkey.newDsaPriv(spec.getP().toByteArray(), spec.getQ().toByteArray(), spec.getG().toByteArray(), privVal);
        }
        finally {
            Util.clearArray(privVal);
        }
        DSAParameterSpec dsaParameterSpec = new DSAParameterSpec(spec.getP(), spec.getQ(), spec.getG());
        return new JceDsaPrivateKey(pkey, spec.getX(), dsaParameterSpec);
    }

    @Override
    PrivateKey generatePrivateInternal(byte[] privDer) throws InvalidKeyException {
        DSAPrivateKeySpec dsaPrivKeySpec;
        try {
            dsaPrivKeySpec = DsaKeyFactory.dsaPrivDerDecode(privDer);
        }
        finally {
            Util.clearArray(privDer);
        }
        return this.generatePrivateInternal(dsaPrivKeySpec);
    }

    private static DSAPrivateKeySpec dsaPrivDerDecode(byte[] privDer) throws InvalidKeyException {
        try {
            Asn1BerValue dsaPrivKey = Asn1.decodeOne(privDer).count(3);
            Util.assertAllUniversal(dsaPrivKey);
            List<Asn1BerValue> dsaPrivKeyValues = dsaPrivKey.sequence();
            BigInteger privKeyInfoVer = dsaPrivKeyValues.get(0).getInteger();
            if (!privKeyInfoVer.equals(BigInteger.ZERO)) {
                throw new Asn1DecodeException("Invalid PrivateKeyInfo version; was: " + privKeyInfoVer + ", expected: 0");
            }
            List<Asn1BerValue> algId = dsaPrivKeyValues.get(1).count(2).sequence();
            Asn1BerValue algorithm = algId.get(0);
            if (!algorithm.equals(ID_DSA)) {
                throw new Asn1DecodeException("Unsupported key algorithm; was: " + algorithm.getOid() + ", expected: " + ID_DSA.getOid());
            }
            List<Asn1BerValue> dsaParamValues = algId.get(1).count(3).sequence();
            BigInteger p = dsaParamValues.get(0).getInteger();
            BigInteger q = dsaParamValues.get(1).getInteger();
            BigInteger g = dsaParamValues.get(2).getInteger();
            BigInteger x = Asn1.decodeOne(dsaPrivKeyValues.get(2).getOctetString()).tag(UniversalTag.INTEGER).getInteger();
            return new DSAPrivateKeySpec(x, p, q, g);
        }
        catch (Asn1DecodeException ex) {
            throw new InvalidKeyException("Unable to decode DSA Private Key", ex);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec spec = (DSAPublicKeySpec)keySpec;
            if (InputChecks.isNullOrZero(spec.getP(), spec.getQ(), spec.getG(), spec.getY())) {
                throw new InvalidKeySpecException("Key spec parameters must not be null or ZERO");
            }
            try {
                return this.generatePublicInternal(spec, null);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        return super.engineGeneratePublic(keySpec);
    }

    PublicKey generatePublicInternal(DSAPublicKeySpec spec, byte[] pubDer) throws InvalidKeyException {
        Pkey pkey = Pkey.newDsaPub(spec.getP().toByteArray(), spec.getQ().toByteArray(), spec.getG().toByteArray(), spec.getY().toByteArray());
        DSAParameterSpec dsaParameterSpec = new DSAParameterSpec(spec.getP(), spec.getQ(), spec.getG());
        return new JceDsaPublicKey(pkey, spec.getY(), dsaParameterSpec, pubDer);
    }

    @Override
    PublicKey generatePublicInternal(byte[] pubDer) throws InvalidKeyException {
        DSAPublicKeySpec dsaPubKeySpec = DsaKeyFactory.dsaPubDerDecode(pubDer);
        return this.generatePublicInternal(dsaPubKeySpec, pubDer);
    }

    private static DSAPublicKeySpec dsaPubDerDecode(byte[] pubDer) throws InvalidKeyException {
        try {
            Asn1BerValue dsaPubKey = Asn1.decodeOne(pubDer).count(2);
            Util.assertAllUniversal(dsaPubKey);
            List<Asn1BerValue> dsaPubKeyValues = dsaPubKey.sequence();
            List<Asn1BerValue> algId = dsaPubKeyValues.get(0).count(2).sequence();
            Asn1BerValue algorithm = algId.get(0);
            if (!algorithm.equals(ID_DSA)) {
                throw new Asn1DecodeException("Unsupported key algorithm; was: " + algorithm.getOid() + ", expected: " + ID_DSA.getOid());
            }
            List<Asn1BerValue> dsaParamValues = algId.get(1).count(3).sequence();
            BigInteger p = dsaParamValues.get(0).getInteger();
            BigInteger q = dsaParamValues.get(1).getInteger();
            BigInteger g = dsaParamValues.get(2).getInteger();
            BigInteger y = Asn1.decodeOne(dsaPubKeyValues.get(1).getBitStringOctets()).tag(UniversalTag.INTEGER).getInteger();
            return new DSAPublicKeySpec(y, p, q, g);
        }
        catch (Asn1DecodeException ex) {
            throw new InvalidKeyException("Unable to decode DSA Public Key", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        Key osslKey;
        try {
            osslKey = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException var4) {
            throw new InvalidKeySpecException(var4);
        }
        if (osslKey instanceof DSAPublicKey) {
            if (keySpec != null && keySpec.isAssignableFrom(DSAPublicKeySpec.class)) {
                DSAParams dsaParams = ((DSAPublicKey)osslKey).getParams();
                return (T)((KeySpec)keySpec.cast(new DSAPublicKeySpec(((DSAPublicKey)osslKey).getY(), dsaParams.getP(), dsaParams.getQ(), dsaParams.getG())));
            }
            if (keySpec != null && keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(osslKey.getEncoded())));
            }
            throw new InvalidKeySpecException("Expected KeySpec class to be assignable from either DSAPublicKeySpec or X509EncodedKeySpec");
        }
        if (osslKey instanceof DSAPrivateKey) {
            if (keySpec != null && keySpec.isAssignableFrom(DSAPrivateKeySpec.class)) {
                DSAParams dsaParams = ((DSAPrivateKey)osslKey).getParams();
                return (T)((KeySpec)keySpec.cast(new DSAPrivateKeySpec(((DSAPrivateKey)osslKey).getX(), dsaParams.getP(), dsaParams.getQ(), dsaParams.getG())));
            }
            if (keySpec != null && keySpec.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                byte[] der = key.getEncoded();
                try {
                    KeySpec keySpec2 = (KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(der));
                    return (T)keySpec2;
                }
                finally {
                    Util.clearArray(der);
                }
            }
            throw new InvalidKeySpecException("Expected KeySpec class to be assignable from either DSAPrivateKeySpec or PKCS8EncodedKeySpec");
        }
        throw new InvalidKeySpecException("Could not getKeySpec for given key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof JceDsaPublicKey || key instanceof JceDsaPrivateKey) {
            return key;
        }
        if (key instanceof PrivateKey) {
            return this.translatePrivate((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return this.translatePublic((PublicKey)key);
        }
        throw new InvalidKeyException("Could not translate to DSA key");
    }
}

