/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;

public final class JceDsaPublicKey
extends JceOsslKey
implements DSAPublicKey {
    static final String ALG = "DSA";
    private static final Asn1BerValue ID_DSA = Asn1.newOid("1.2.840.10040.4.1");
    private final BigInteger pub;
    private final DSAParameterSpec params;

    public JceDsaPublicKey(Pkey pkey, BigInteger pub, DSAParameterSpec params, byte[] encoding) {
        super(ALG, pkey, encoding);
        this.pub = pub;
        this.params = params;
    }

    public JceDsaPublicKey(Pkey pkey, byte[] encoding) throws InvalidKeyException {
        super(ALG, pkey, encoding);
        byte[] pubVal = this.pkey.getDsaPublicKey();
        this.pub = new BigInteger(1, pubVal);
        byte[][] vals = this.pkey.getDsaParams();
        this.params = new DSAParameterSpec(new BigInteger(1, vals[0]), new BigInteger(1, vals[1]), new BigInteger(1, vals[2]));
    }

    @Override
    public BigInteger getY() {
        return this.pub;
    }

    @Override
    public DSAParameterSpec getParams() {
        return this.params;
    }

    @Override
    byte[] derEncode() throws InvalidKeyException {
        Asn1BerValue dsaPubKey = Asn1.newSequence(Asn1.newSequence(ID_DSA, Asn1.newSequence(Asn1.newInteger(this.params.getP()), Asn1.newInteger(this.params.getQ()), Asn1.newInteger(this.params.getG()))), Asn1.newBitString(Asn1.newInteger(this.pub).encodeDerOctets()));
        return dsaPubKey.encodeDerOctets();
    }

    public String toString() {
        return "DsaPublicKey: params=[P=" + this.params.getP() + ",Q=" + this.params.getQ() + ",G=" + this.params.getG() + "],pubValue=" + this.pub;
    }
}

