/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.DerHelper;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.provider.DHFIPSParameterSpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public final class JceDhPublicKey
extends JceOsslKey
implements DHPublicKey {
    static final String ALG = "DH";
    private final BigInteger pub;
    private final DHParameterSpec params;

    public JceDhPublicKey(Pkey pkey, BigInteger pub, DHParameterSpec params, byte[] encoding) {
        super(ALG, pkey, encoding);
        this.pub = pub;
        this.params = params;
    }

    public JceDhPublicKey(Pkey pkey, byte[] encoding) throws InvalidKeyException {
        super(ALG, pkey, encoding);
        byte[] pubVal = this.pkey.getDhPublicKey();
        this.pub = new BigInteger(1, pubVal);
        byte[][] vals = this.pkey.getDhParams();
        BigInteger p = new BigInteger(1, vals[0]);
        BigInteger g = new BigInteger(1, vals[2]);
        this.params = vals[1] == null ? new DHParameterSpec(p, g) : new DHFIPSParameterSpec(p, new BigInteger(1, vals[1]), g);
    }

    @Override
    public BigInteger getY() {
        return this.pub;
    }

    @Override
    public DHParameterSpec getParams() {
        return this.params;
    }

    @Override
    byte[] derEncode() throws InvalidKeyException {
        try {
            return DerHelper.pubDerEncode(this.pkey);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public String toString() {
        return "DHPublicKey: params=[P=" + this.params.getP() + ",G=" + this.params.getG() + "],pubValue=" + this.pub;
    }
}

