/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import com.oracle.jipher.internal.common.ToolkitProperties;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class Platform {
    private final String platformName;

    private Platform(String platName) {
        this.platformName = platName;
    }

    public static Platform getPlatform() {
        String osName = Platform.systemProperty("os.name");
        String osArch = Platform.systemProperty("os.arch");
        if (osName.toLowerCase().contains("windows")) {
            return new WindowsX64();
        }
        if (osName.equalsIgnoreCase("SunOS")) {
            if (osArch.toLowerCase().contains("sparc")) {
                return new Sparc64();
            }
            return new SolarisX64();
        }
        if (osName.toLowerCase().contains("hp-ux")) {
            return new HpUxia64();
        }
        if (osName.toLowerCase().contains("aix")) {
            return new AixPpc64();
        }
        if (osName.toLowerCase().contains("linux")) {
            if (osArch.toLowerCase().contains("s390")) {
                return new ZLinux();
            }
            if (osArch.toLowerCase().contains("aarch64")) {
                return new LinuxArm64();
            }
            return new LinuxX64();
        }
        if (osName.toLowerCase().contains("mac")) {
            return new Mac64();
        }
        throw new Error("Unsupported Platform detected");
    }

    private static String systemProperty(final String prop) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(prop);
            }
        });
    }

    public String getOpensslCnfFile() {
        return "openssl.cnf";
    }

    public abstract String getFipsLibFile();

    public List<String> getLibFiles() {
        ArrayList<String> libFiles = new ArrayList<String>(3);
        libFiles.add(this.getJipherLibFile());
        libFiles.add(this.getFipsLibFile());
        return libFiles;
    }

    public String getLoadLibName() {
        return this.getJipherLibName();
    }

    public String getLoadLibFile() {
        return this.getJipherLibFile();
    }

    public abstract String getJipherLibFile();

    String getJipherLibName() {
        return "jipher";
    }

    public String getResourcePath(String libFile) {
        return "libs/" + this.platformName + "/" + libFile;
    }

    public String getResourcePathChecksum(String libFile) {
        return this.getResourcePath(libFile) + ".crc32";
    }

    public abstract FileAttribute<?> getTempDirAttributes();

    public abstract FileAttribute<?> getTempFileAttributes();

    public static class WindowsX64
    extends Platform {
        WindowsX64() {
            super("windows_x64");
        }

        @Override
        public String getJipherLibFile() {
            return "jipher.dll";
        }

        @Override
        public FileAttribute<?> getTempDirAttributes() {
            return this.getAclAttributes(this.getAclEntry(this.getAdministrators(), AclEntryPermission.values()), this.getAclEntry(this.getCurrentUser(), AclEntryPermission.values()));
        }

        @Override
        public FileAttribute<?> getTempFileAttributes() {
            return this.getAclAttributes(this.getAclEntry(this.getAdministrators(), AclEntryPermission.values()), this.getAclEntry(this.getCurrentUser(), AclEntryPermission.READ_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.EXECUTE, AclEntryPermission.DELETE_CHILD, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.DELETE, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_OWNER, AclEntryPermission.SYNCHRONIZE));
        }

        UserPrincipal getAdministrators() {
            try {
                return FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByGroupName("Administrators");
            }
            catch (IOException e) {
                throw new ProviderException("Failed to get Administrators group for setting permissions on temporary lib files.", e);
            }
        }

        UserPrincipal getCurrentUser() {
            try {
                return FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(ToolkitProperties.getUserName());
            }
            catch (IOException e) {
                throw new ProviderException("Failed to get user principal for setting permissions on temporary lib files.", e);
            }
        }

        AclEntry getAclEntry(UserPrincipal principal, AclEntryPermission ... perms) {
            return AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(principal).setPermissions(perms).build();
        }

        FileAttribute<List<AclEntry>> getAclAttributes(final AclEntry ... entries) {
            return new FileAttribute<List<AclEntry>>(){

                @Override
                public String name() {
                    return "acl:acl";
                }

                @Override
                public List<AclEntry> value() {
                    return Arrays.asList(entries);
                }
            };
        }

        @Override
        public String getFipsLibFile() {
            return "fips.dll";
        }
    }

    public static class Mac64
    extends Unix {
        Mac64() {
            super("mac_64");
        }

        @Override
        public String getJipherLibFile() {
            return "libjipher.dylib";
        }

        @Override
        public String getFipsLibFile() {
            return "fips.dylib";
        }
    }

    public static class HpUxia64
    extends Unix {
        HpUxia64() {
            super("hpux_ia64");
        }
    }

    public static class Sparc64
    extends Unix {
        Sparc64() {
            super("solaris_sparc64");
        }
    }

    public static class SolarisX64
    extends Unix {
        SolarisX64() {
            super("solaris_x64");
        }
    }

    public static class AixPpc64
    extends Unix {
        AixPpc64() {
            super("aix_ppc64");
        }
    }

    public static class ZLinux
    extends Unix {
        ZLinux() {
            super("zlinux_64");
        }
    }

    public static class LinuxArm64
    extends Unix {
        LinuxArm64() {
            super("linux_arm64");
        }
    }

    public static class LinuxX64
    extends Unix {
        LinuxX64() {
            super("linux_x64");
        }
    }

    public static abstract class Unix
    extends Platform {
        Unix(String name) {
            super(name);
        }

        @Override
        public String getJipherLibFile() {
            return "libjipher.so";
        }

        @Override
        public FileAttribute<?> getTempDirAttributes() {
            return PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        }

        @Override
        public FileAttribute<?> getTempFileAttributes() {
            return PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("r-x------"));
        }

        @Override
        public String getFipsLibFile() {
            return "fips.so";
        }
    }
}

