/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Debug {
    private static final Debug NONE = new Debug(null){

        @Override
        public void println(String msg) {
        }

        @Override
        public void println(Printer p) {
        }
    };
    private final String typeName;

    private Debug(String type) {
        this.typeName = type;
    }

    public static boolean isEnabled(String type) {
        String debugVal = System.getSecurityManager() == null ? System.getProperty("java.security.debug") : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.security.debug");
            }
        });
        if (debugVal == null) {
            return false;
        }
        return debugVal.toLowerCase().contains(type.toLowerCase()) || debugVal.toLowerCase().contains("all");
    }

    public static Debug getInstance(String type) {
        if (Debug.isEnabled(type)) {
            return new Debug(type.toLowerCase());
        }
        return NONE;
    }

    public void println(Printer p) {
        this.println(p.print());
    }

    public void println(String msg) {
        System.err.print(this.typeName + ": ");
        System.err.println(msg);
    }

    public static interface Printer {
        public String print();
    }
}

