/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import java.util.ArrayList;

class BuildStackTraceVisitor
extends JavaStackFrameVisitor {
    private final boolean filterExceptions;
    final ArrayList<StackTraceElement> trace;
    final int limit;

    BuildStackTraceVisitor(boolean filterExceptions, int limit) {
        this.filterExceptions = filterExceptions;
        this.trace = new ArrayList();
        this.limit = limit;
    }

    @Override
    public boolean visitFrame(FrameSourceInfo frameSourceInfo) {
        if (!StackTraceUtils.shouldShowFrame(frameSourceInfo)) {
            return true;
        }
        if (this.filterExceptions && this.trace.size() == 0 && Throwable.class.isAssignableFrom(frameSourceInfo.getSourceClass())) {
            return true;
        }
        StackTraceElement sourceReference = frameSourceInfo.getSourceReference();
        this.trace.add(sourceReference);
        return this.trace.size() != this.limit;
    }
}

