/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.log.Log;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

class HeapChunkLogging {
    private static final int MAX_CHUNKS_TO_PRINT = 65536;

    HeapChunkLogging() {
    }

    public static void logChunks(Log log, AlignedHeapChunk.AlignedHeader firstChunk, String shortSpaceName, boolean isToSpace) {
        if (firstChunk.isNonNull()) {
            int i;
            AlignedHeapChunk.AlignedHeader chunk = firstChunk;
            for (i = 0; chunk.isNonNull() && i < 65536; ++i) {
                Pointer bottom = AlignedHeapChunk.getObjectsStart(chunk);
                Pointer top = HeapChunk.getTopPointer(chunk);
                Pointer end = AlignedHeapChunk.getObjectsEnd(chunk);
                HeapChunkLogging.logChunk(log, chunk, bottom, top, end, true, shortSpaceName, isToSpace);
                chunk = HeapChunk.getNext(chunk);
            }
            if (chunk.isNonNull()) {
                assert (i == 65536);
                log.newline().string("... (truncated)");
            }
        }
    }

    public static void logChunks(Log log, UnalignedHeapChunk.UnalignedHeader firstChunk, String shortSpaceName, boolean isToSpace) {
        if (firstChunk.isNonNull()) {
            int i;
            UnalignedHeapChunk.UnalignedHeader chunk = firstChunk;
            for (i = 0; chunk.isNonNull() && i < 65536; ++i) {
                Pointer bottom = UnalignedHeapChunk.getObjectStart(chunk);
                Pointer top = HeapChunk.getTopPointer(chunk);
                Pointer end = UnalignedHeapChunk.getObjectEnd(chunk);
                HeapChunkLogging.logChunk(log, chunk, bottom, top, end, false, shortSpaceName, isToSpace);
                chunk = HeapChunk.getNext(chunk);
            }
            if (chunk.isNonNull()) {
                assert (i == 65536);
                log.newline().string("... (truncated)");
            }
        }
    }

    private static void logChunk(Log log, HeapChunk.Header<?> chunk, Pointer bottom, Pointer top, Pointer end, boolean isAligned, String shortSpaceName, boolean isToSpace) {
        Pointer used = top.subtract((UnsignedWord)bottom);
        Pointer capacity = end.subtract((UnsignedWord)bottom);
        UnsignedWord usedPercent = used.multiply(100).unsignedDivide((UnsignedWord)capacity);
        log.string("|").zhex((WordBase)chunk).string("|").zhex((WordBase)bottom).string(", ").zhex((WordBase)top).string(", ").zhex((WordBase)end);
        log.string("|").unsigned((WordBase)usedPercent, 3, 2).string("%");
        log.string("|").string(shortSpaceName, 3, 2);
        log.string("|").string(isAligned ? "A" : "U");
        log.string("|").string(isToSpace ? "T" : "");
        log.newline();
    }
}

