/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.util.BasedOnJDKFile;
import java.nio.charset.StandardCharsets;
import jdk.internal.vm.VMSupport;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/hotspot/share/services/diagnosticCommand.hpp#L84-L95")
public class VMSystemPropertiesDCmd
extends AbstractDCmd {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMSystemPropertiesDCmd() {
        super("VM.system_properties", "Print system properties.", DCmd.Impact.Low);
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/attachListener.cpp#L67-L109")
    public String execute(DCmdArguments args) throws Throwable {
        byte[] bytes = VMSupport.serializePropertiesToByteArray();
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }
}

