/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.aotjs.api;

import java.math.BigInteger;
import org.graalvm.aotjs.api.JS;
import org.graalvm.aotjs.api.JSValue;

public final class JSNumber
extends JSValue {
    JSNumber() {
    }

    @JS(value="return extractJavaScriptNumber(d[runtime.symbol.javaNative]);")
    public static native JSNumber of(double var0);

    @Override
    public String typeof() {
        return "number";
    }

    @JS(value="return toProxy(createJavaDouble(this));")
    private native Double javaDouble();

    @Override
    protected String stringValue() {
        return String.valueOf(this.javaDouble());
    }

    @Override
    public Byte asByte() {
        return this.javaDouble().byteValue();
    }

    @Override
    public Short asShort() {
        return this.javaDouble().shortValue();
    }

    @Override
    public Character asChar() {
        return Character.valueOf((char)this.javaDouble().intValue());
    }

    @Override
    public Integer asInt() {
        return this.javaDouble().intValue();
    }

    @Override
    public Float asFloat() {
        return Float.valueOf(this.javaDouble().floatValue());
    }

    @Override
    public Long asLong() {
        return this.javaDouble().longValue();
    }

    @Override
    public Double asDouble() {
        return (double)this.javaDouble();
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.javaDouble().longValue());
    }

    public boolean equals(Object that) {
        if (that instanceof JSNumber) {
            return this.javaDouble().equals(((JSNumber)that).javaDouble());
        }
        return super.equals(that);
    }

    public int hashCode() {
        return this.javaDouble().hashCode();
    }
}

