/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ProxyConfigurationTypeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.phases.common.LazyValue;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

class ReflectionProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;
    private boolean trackReflectionMetadata = true;

    ReflectionProcessor(AccessAdvisor advisor) {
        this.advisor = advisor;
    }

    public void setTrackReflectionMetadata(boolean trackReflectionMetadata) {
        this.trackReflectionMetadata = trackReflectionMetadata;
    }

    @Override
    public void processEntry(EconomicMap<String, ?> entry, ConfigurationSet configurationSet) {
        boolean isLoadClass;
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        UnresolvedConfigurationCondition condition = UnresolvedConfigurationCondition.alwaysTrue();
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get((Object)"function");
        List args = (List)entry.get((Object)"args");
        ResourceConfiguration resourceConfiguration = configurationSet.getResourceConfiguration();
        switch (function) {
            case "findResource": 
            case "findResourceAsStream": {
                ReflectionProcessor.expectSize(args, 2);
                String module = (String)args.get(0);
                String resource = (String)args.get(1);
                if (!AccessAdvisor.shouldIgnoreResourceLookup(LazyValueUtils.lazyValue(resource))) {
                    resourceConfiguration.addGlobPattern(condition, resource, module);
                }
                return;
            }
            case "getResource": 
            case "getSystemResource": 
            case "getSystemResourceAsStream": 
            case "getResources": 
            case "getSystemResources": {
                String literal = (String)ReflectionProcessor.singleElement(args);
                if (!AccessAdvisor.shouldIgnoreResourceLookup(LazyValueUtils.lazyValue(literal))) {
                    resourceConfiguration.addGlobPattern(condition, literal, null);
                }
                return;
            }
        }
        TypeConfiguration configuration = configurationSet.getReflectionConfiguration();
        String callerClass = (String)entry.get((Object)"caller_class");
        boolean bl = isLoadClass = function.equals("loadClass") || function.equals("findSystemClass");
        if (isLoadClass || function.equals("forName") || function.equals("findClass")) {
            String name = (String)ReflectionProcessor.singleElement(args);
            if (isLoadClass) {
                name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
            }
            if (!(this.advisor.shouldIgnore(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass)) || isLoadClass && this.advisor.shouldIgnoreLoadClass(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass)))) {
                configuration.getOrCreateType(condition, name);
            }
            return;
        }
        if (function.equals("methodTypeDescriptor")) {
            List typeNames = (List)ReflectionProcessor.singleElement(args);
            for (String type : typeNames) {
                if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue(type), LazyValueUtils.lazyValue(callerClass))) continue;
                configuration.getOrCreateType(condition, type);
            }
            return;
        }
        ConfigurationTypeDescriptor clazz = ReflectionProcessor.descriptorForClass(entry.get((Object)"class"));
        for (String className : clazz.getAllQualifiedJavaNames()) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(className), LazyValueUtils.lazyValue(callerClass))) continue;
            return;
        }
        ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration = ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC;
        ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility = ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED;
        ConfigurationTypeDescriptor clazzOrDeclaringClass = entry.containsKey((Object)"declaring_class") ? ReflectionProcessor.descriptorForClass(entry.get((Object)"declaring_class")) : clazz;
        switch (function) {
            case "getDeclaredFields": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredFields(ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
                break;
            }
            case "getFields": {
                configuration.getOrCreateType(condition, clazz).setAllPublicFields(ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
                break;
            }
            case "getDeclaredMethods": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredMethods(accessibility);
                break;
            }
            case "asInterfaceInstance": {
                accessibility = ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED;
            }
            case "getMethods": {
                configuration.getOrCreateType(condition, clazz).setAllPublicMethods(accessibility);
                break;
            }
            case "getDeclaredConstructors": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredConstructors(accessibility);
                break;
            }
            case "getConstructors": {
                configuration.getOrCreateType(condition, clazz).setAllPublicConstructors(accessibility);
                break;
            }
            case "getDeclaredClasses": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredClasses();
                break;
            }
            case "getRecordComponents": {
                configuration.getOrCreateType(condition, clazz).setAllRecordComponents();
                break;
            }
            case "getPermittedSubclasses": {
                configuration.getOrCreateType(condition, clazz).setAllPermittedSubclasses();
                break;
            }
            case "getNestMembers": {
                configuration.getOrCreateType(condition, clazz).setAllNestMembers();
                break;
            }
            case "getSigners": {
                configuration.getOrCreateType(condition, clazz).setAllSigners();
                break;
            }
            case "getClasses": {
                configuration.getOrCreateType(condition, clazz).setAllPublicClasses();
                break;
            }
            case "objectFieldOffset": 
            case "findFieldHandle": 
            case "unreflectField": 
            case "getDeclaredField": {
                declaration = "findFieldHandle".equals(function) ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT : ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED;
            }
            case "getField": {
                configuration.getOrCreateType(condition, clazzOrDeclaringClass).addField((String)ReflectionProcessor.singleElement(args), declaration, false);
                if (clazzOrDeclaringClass.equals((Object)clazz)) break;
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "getDeclaredMethod": 
            case "findMethodHandle": 
            case "invokeMethod": {
                declaration = "getDeclaredMethod".equals(function) ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED : ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT;
            }
            case "getMethod": {
                ReflectionProcessor.expectSize(args, 2);
                accessibility = !this.trackReflectionMetadata || function.equals("invokeMethod") || function.equals("findMethodHandle") ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED;
                String name = (String)args.get(0);
                List parameterTypes = (List)args.get(1);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                if (accessibility == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED) {
                    configuration.getOrCreateType(condition, clazzOrDeclaringClass).addMethod(name, SignatureUtil.toInternalSignature(parameterTypes), declaration, accessibility);
                }
                if (accessibility != ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED && (this.trackReflectionMetadata || clazzOrDeclaringClass.equals((Object)clazz))) break;
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "getDeclaredConstructor": 
            case "findConstructorHandle": 
            case "invokeConstructor": {
                declaration = "getDeclaredConstructor".equals(function) ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED : ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT;
            }
            case "getConstructor": {
                accessibility = !this.trackReflectionMetadata || function.equals("invokeConstructor") || function.equals("findConstructorHandle") ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED;
                List parameterTypes = (List)ReflectionProcessor.singleElement(args);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                String signature = SignatureUtil.toInternalSignature(parameterTypes);
                assert (clazz.equals((Object)clazzOrDeclaringClass)) : "Constructor can only be accessed via declaring class";
                ConfigurationType configurationType = configuration.getOrCreateType(condition, clazzOrDeclaringClass);
                if (accessibility != ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED) break;
                configurationType.addMethod("<init>", signature, declaration, accessibility);
                break;
            }
            case "getProxyClass": {
                ReflectionProcessor.expectSize(args, 2);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass), configuration);
                break;
            }
            case "newProxyInstance": {
                ReflectionProcessor.expectSize(args, 3);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass), configuration);
                break;
            }
            case "newMethodHandleProxyInstance": {
                ReflectionProcessor.expectSize(args, 1);
                this.addDynamicProxyUnchecked((List)args.get(0), Collections.singletonList("sun.invoke.WrapperInstance"), LazyValueUtils.lazyValue(callerClass), configuration);
                break;
            }
            case "getEnclosingConstructor": 
            case "getEnclosingMethod": {
                String result = (String)entry.get((Object)"result");
                ReflectionProcessor.addFullyQualifiedDeclaredMethod(result, configuration);
                break;
            }
            case "newInstance": {
                if (clazz.toString().equals("java.lang.reflect.Array")) {
                    configuration.getOrCreateType(condition, (ConfigurationTypeDescriptor)new NamedConfigurationTypeDescriptor((String)args.get(0)));
                    break;
                }
                configuration.getOrCreateType(condition, clazz).addMethod("<init>", "()V", ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
                break;
            }
            case "getBundleImpl": {
                ReflectionProcessor.expectSize(args, 5);
                String baseName = (String)args.get(2);
                String queriedLocale = (String)args.get(3);
                if (baseName == null) break;
                resourceConfiguration.addBundle(condition, baseName, queriedLocale);
                break;
            }
            case "allocateInstance": {
                configuration.getOrCreateType(condition, clazz).setUnsafeAllocated();
                break;
            }
            default: {
                System.err.println("Unsupported reflection method: " + function);
            }
        }
    }

    private static ConfigurationTypeDescriptor descriptorForClass(Object clazz) {
        if (clazz instanceof List) {
            return new ProxyConfigurationTypeDescriptor((List)clazz);
        }
        return new NamedConfigurationTypeDescriptor((String)clazz);
    }

    private static void addFullyQualifiedDeclaredMethod(String descriptor, TypeConfiguration configuration) {
        int sigbegin = descriptor.indexOf(40);
        int classend = descriptor.lastIndexOf(46, sigbegin - 1);
        String qualifiedClass = descriptor.substring(0, classend);
        String methodName = descriptor.substring(classend + 1, sigbegin);
        String signature = descriptor.substring(sigbegin);
        configuration.getOrCreateType(UnresolvedConfigurationCondition.alwaysTrue(), qualifiedClass).addMethod(methodName, signature, ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
    }

    private void addDynamicProxy(List<?> interfaceList, LazyValue<String> callerClass, TypeConfiguration configuration) {
        ConfigurationTypeDescriptor typeDescriptor = ReflectionProcessor.descriptorForClass(interfaceList);
        for (String iface : typeDescriptor.getAllQualifiedJavaNames()) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass)) continue;
            return;
        }
        configuration.getOrCreateType(UnresolvedConfigurationCondition.alwaysTrue(), typeDescriptor);
    }

    private void addDynamicProxyUnchecked(List<?> checkedInterfaceList, List<?> uncheckedInterfaceList, LazyValue<String> callerClass, TypeConfiguration configuration) {
        List<?> checkedInterfaces = checkedInterfaceList;
        for (String iface : checkedInterfaces) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass)) continue;
            return;
        }
        List<?> uncheckedInterfaces = uncheckedInterfaceList;
        ArrayList interfaces = new ArrayList();
        interfaces.addAll(checkedInterfaces);
        interfaces.addAll(uncheckedInterfaces);
        configuration.getOrCreateType(UnresolvedConfigurationCondition.alwaysTrue(), ReflectionProcessor.descriptorForClass(interfaces));
    }
}

