/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public final class ProxyConfiguration
extends ConfigurationBase<ProxyConfiguration, Predicate> {
    private final Set<ConditionalElement<List<String>>> interfaceLists = ConcurrentHashMap.newKeySet();

    public ProxyConfiguration() {
    }

    public ProxyConfiguration(ProxyConfiguration other) {
        for (ConditionalElement<List<String>> interfaceList : other.interfaceLists) {
            this.interfaceLists.add((ConditionalElement<List<String>>)new ConditionalElement(interfaceList.condition(), new ArrayList((Collection)interfaceList.element())));
        }
    }

    @Override
    public ProxyConfiguration copy() {
        return new ProxyConfiguration(this);
    }

    @Override
    protected void merge(ProxyConfiguration other) {
        for (ConditionalElement<List<String>> interfaceList : other.interfaceLists) {
            this.interfaceLists.add((ConditionalElement<List<String>>)new ConditionalElement(interfaceList.condition(), new ArrayList((Collection)interfaceList.element())));
        }
    }

    @Override
    protected void intersect(ProxyConfiguration other) {
        this.interfaceLists.retainAll(other.interfaceLists);
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.interfaceLists.removeIf(predicate::testProxyInterfaceList);
    }

    @Override
    public void subtract(ProxyConfiguration other) {
        this.interfaceLists.removeAll(other.interfaceLists);
    }

    @Override
    public void mergeConditional(UnresolvedConfigurationCondition condition, ProxyConfiguration other) {
        for (ConditionalElement<List<String>> interfaceList : other.interfaceLists) {
            this.add(condition, new ArrayList<String>((Collection)interfaceList.element()));
        }
    }

    public void add(UnresolvedConfigurationCondition condition, List<String> interfaceList) {
        this.interfaceLists.add((ConditionalElement<List<String>>)new ConditionalElement(condition, interfaceList));
    }

    public boolean contains(UnresolvedConfigurationCondition condition, List<String> interfaceList) {
        return this.interfaceLists.contains(new ConditionalElement(condition, interfaceList));
    }

    public boolean contains(UnresolvedConfigurationCondition condition, String ... interfaces) {
        return this.contains(condition, Arrays.asList(interfaces));
    }

    public void printJson(JsonWriter writer) throws IOException {
        ArrayList<ConditionalElement<List<String>>> lists = new ArrayList<ConditionalElement<List<String>>>(this.interfaceLists.size());
        lists.addAll(this.interfaceLists);
        ProxyConfiguration.printProxyInterfaces(writer, lists);
    }

    public static void printProxyInterfaces(JsonWriter writer, List<ConditionalElement<List<String>>> lists) throws IOException {
        lists.sort(ConditionalElement.comparator(ProxyConfiguration::compareList));
        writer.appendArrayStart();
        boolean firstProxy = true;
        for (ConditionalElement<List<String>> list : lists) {
            if (firstProxy) {
                firstProxy = false;
            } else {
                writer.appendSeparator();
            }
            writer.appendObjectStart();
            ConfigurationConditionPrintable.printConditionAttribute(list.condition(), writer, false);
            writer.quote("interfaces").appendFieldSeparator().appendArrayStart();
            boolean firstType = true;
            for (String type : (List)list.element()) {
                if (firstType) {
                    firstType = false;
                } else {
                    writer.appendSeparator();
                }
                writer.quote(type);
            }
            writer.appendArrayEnd();
            writer.appendObjectEnd();
        }
        writer.appendArrayEnd();
    }

    @Override
    public ConfigurationParser createParser(boolean strictMetadata) {
        VMError.guarantee((!strictMetadata ? 1 : 0) != 0, (String)"Independent proxy configuration is not supported with strict metadata");
        return new ProxyConfigurationParser(ConfigurationConditionResolver.identityResolver(), true, (cond, interfaces) -> this.interfaceLists.add((ConditionalElement<List<String>>)new ConditionalElement(cond, interfaces)));
    }

    @Override
    public boolean isEmpty() {
        return this.interfaceLists.isEmpty();
    }

    @Override
    public boolean supportsCombinedFile() {
        return false;
    }

    private static <T extends Comparable<T>> int compareList(List<T> l1, List<T> l2) {
        for (int i = 0; i < l1.size() && i < l2.size(); ++i) {
            int c = ((Comparable)l1.get(i)).compareTo((Comparable)l2.get(i));
            if (c == 0) continue;
            return c;
        }
        return l1.size() - l2.size();
    }

    public static interface Predicate {
        public boolean testProxyInterfaceList(ConditionalElement<List<String>> var1);
    }
}

