/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.FieldInfo;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.SignatureUtil;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonPrinter;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public class ConfigurationType
implements JsonPrintable {
    private final UnresolvedConfigurationCondition condition;
    private final ConfigurationTypeDescriptor typeDescriptor;
    private Map<String, FieldInfo> fields;
    private Map<ConfigurationMethod, ConfigurationMemberInfo> methods;
    private boolean allDeclaredClasses;
    private boolean allRecordComponents;
    private boolean allPermittedSubclasses;
    private boolean allNestMembers;
    private boolean allSigners;
    private boolean allPublicClasses;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allDeclaredFieldsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allPublicFieldsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private boolean unsafeAllocated;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allDeclaredMethodsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allPublicMethodsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allDeclaredConstructorsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allPublicConstructorsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;

    static ConfigurationType copyAndSubtract(ConfigurationType type, ConfigurationType subtractType) {
        if (type.equals(subtractType)) {
            return null;
        }
        ConfigurationType copy = new ConfigurationType(type);
        if (subtractType == null) {
            return copy;
        }
        assert (type.sameTypeAndCondition(subtractType));
        copy.removeAll(subtractType);
        return copy.isEmpty() ? null : copy;
    }

    static ConfigurationType copyAndIntersect(ConfigurationType type, ConfigurationType toIntersect) {
        ConfigurationType copy = new ConfigurationType(type);
        if (copy.equals(toIntersect)) {
            return copy;
        }
        assert (type.sameTypeAndCondition(toIntersect));
        copy.intersectWith(toIntersect);
        return copy;
    }

    static ConfigurationType copyAndMerge(ConfigurationType type, ConfigurationType toMerge) {
        ConfigurationType copy = new ConfigurationType(type);
        copy.mergeFrom(toMerge);
        return copy;
    }

    public ConfigurationType(UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean includeAllElements) {
        this.condition = condition;
        this.typeDescriptor = typeDescriptor;
        this.allNestMembers = this.allSigners = includeAllElements;
        this.allPermittedSubclasses = this.allSigners;
        this.allRecordComponents = this.allSigners;
        this.allPublicClasses = this.allSigners;
        this.allDeclaredClasses = this.allSigners;
        this.allPublicConstructorsAccess = includeAllElements ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
        this.allDeclaredConstructorsAccess = this.allPublicConstructorsAccess;
        this.allPublicMethodsAccess = this.allPublicConstructorsAccess;
        this.allDeclaredMethodsAccess = this.allPublicConstructorsAccess;
        this.allPublicFieldsAccess = this.allPublicConstructorsAccess;
        this.allDeclaredFieldsAccess = this.allPublicConstructorsAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationType(ConfigurationType other, UnresolvedConfigurationCondition condition) {
        ConfigurationType configurationType = other;
        synchronized (configurationType) {
            this.typeDescriptor = other.typeDescriptor;
            this.condition = condition;
            this.mergeFrom(other);
        }
    }

    ConfigurationType(ConfigurationType other) {
        this(other, other.condition);
    }

    void mergeFrom(ConfigurationType other) {
        assert (this.sameTypeAndCondition(other));
        this.mergeFlagsFrom(other);
        this.mergeFieldsFrom(other);
        this.mergeMethodsFrom(other);
    }

    private boolean sameTypeAndCondition(ConfigurationType otherType) {
        return this.condition.equals((Object)otherType.condition) && this.typeDescriptor.equals((Object)otherType.typeDescriptor);
    }

    private void mergeFlagsFrom(ConfigurationType other) {
        this.setFlagsFromOther(other, (our, their) -> our != false || their != false, ConfigurationMemberInfo.ConfigurationMemberAccessibility::combine);
    }

    private void mergeFieldsFrom(ConfigurationType other) {
        if (other.fields != null) {
            if (this.fields == null) {
                this.fields = new HashMap<String, FieldInfo>();
            }
            for (Map.Entry<String, FieldInfo> fieldInfoEntry : other.fields.entrySet()) {
                this.fields.compute(fieldInfoEntry.getKey(), (key, value) -> {
                    if (value == null) {
                        return (FieldInfo)fieldInfoEntry.getValue();
                    }
                    return value.newMergedWith((FieldInfo)fieldInfoEntry.getValue());
                });
            }
        }
        this.maybeRemoveFields(this.allDeclaredFieldsAccess, this.allPublicFieldsAccess);
    }

    private void maybeRemoveFields(ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllDeclaredFields, ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllPublicFields) {
        if (hasAllDeclaredFields != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, hasAllDeclaredFields);
        }
        if (hasAllPublicFields != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, hasAllPublicFields);
        }
    }

    private void mergeMethodsFrom(ConfigurationType other) {
        if (other.methods != null) {
            if (this.methods == null) {
                this.methods = new HashMap<ConfigurationMethod, ConfigurationMemberInfo>();
            }
            for (Map.Entry<ConfigurationMethod, ConfigurationMemberInfo> methodEntry : other.methods.entrySet()) {
                this.methods.compute(methodEntry.getKey(), (key, value) -> {
                    if (value != null) {
                        return value.intersect((ConfigurationMemberInfo)methodEntry.getValue());
                    }
                    return (ConfigurationMemberInfo)methodEntry.getValue();
                });
            }
        }
        this.maybeRemoveMethods(this.allDeclaredMethodsAccess, this.allPublicMethodsAccess, this.allDeclaredConstructorsAccess, this.allPublicConstructorsAccess);
    }

    private void maybeRemoveMethods(ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllDeclaredMethods, ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllPublicMethods, ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllDeclaredConstructors, ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllPublicConstructors) {
        if (hasAllDeclaredMethods != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, hasAllDeclaredMethods, false);
        }
        if (hasAllDeclaredConstructors != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, hasAllDeclaredConstructors, true);
        }
        if (hasAllPublicMethods != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, hasAllPublicMethods, false);
        }
        if (hasAllPublicConstructors != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, hasAllPublicConstructors, true);
        }
    }

    private void intersectWith(ConfigurationType other) {
        this.intersectFlags(other);
        this.intersectFields(other);
        this.intersectMethods(other);
    }

    private void intersectFlags(ConfigurationType other) {
        this.setFlagsFromOther(other, (our, their) -> our != false && their != false, ConfigurationMemberInfo.ConfigurationMemberAccessibility::remove);
    }

    private void intersectFields(ConfigurationType other) {
        if (this.fields != null) {
            if (other.fields != null) {
                this.fields.keySet().retainAll(other.fields.keySet());
                this.fields.replaceAll((key, value) -> value.newIntersectedWith(other.fields.get(key)));
            } else {
                this.fields = null;
            }
        }
    }

    private void intersectMethods(ConfigurationType other) {
        if (this.methods != null) {
            if (other.methods != null) {
                this.methods.keySet().retainAll(other.methods.keySet());
            } else {
                this.methods = null;
            }
        }
    }

    private void removeAll(ConfigurationType other) {
        assert (this.sameTypeAndCondition(other));
        this.removeFlags(other);
        this.removeFields(other);
        this.removeMethods(other);
    }

    private void removeFlags(ConfigurationType other) {
        this.setFlagsFromOther(other, (our, their) -> our != false && their == false, ConfigurationMemberInfo.ConfigurationMemberAccessibility::remove);
    }

    private void removeFields(ConfigurationType other) {
        this.maybeRemoveFields(this.allDeclaredFieldsAccess.combine(other.allDeclaredFieldsAccess), this.allPublicFieldsAccess.combine(other.allPublicFieldsAccess));
        if (this.fields != null && other.fields != null) {
            for (Map.Entry<String, FieldInfo> fieldInfoEntry : other.fields.entrySet()) {
                this.fields.computeIfPresent(fieldInfoEntry.getKey(), (key, value) -> value.newWithDifferencesFrom((FieldInfo)fieldInfoEntry.getValue()));
            }
            if (this.fields.isEmpty()) {
                this.fields = null;
            }
        }
    }

    private void removeMethods(ConfigurationType other) {
        this.maybeRemoveMethods(this.allDeclaredMethodsAccess.combine(other.allDeclaredMethodsAccess), this.allPublicMethodsAccess.combine(other.allPublicMethodsAccess), this.allDeclaredConstructorsAccess.combine(other.allDeclaredConstructorsAccess), this.allPublicConstructorsAccess.combine(other.allPublicConstructorsAccess));
        if (this.methods != null && other.methods != null) {
            this.methods.entrySet().removeAll(other.methods.entrySet());
            if (this.methods.isEmpty()) {
                this.methods = null;
            }
        }
    }

    private void setFlagsFromOther(ConfigurationType other, BiPredicate<Boolean, Boolean> flagPredicate, BiFunction<ConfigurationMemberInfo.ConfigurationMemberAccessibility, ConfigurationMemberInfo.ConfigurationMemberAccessibility, ConfigurationMemberInfo.ConfigurationMemberAccessibility> accessCombiner) {
        this.allDeclaredClasses = flagPredicate.test(this.allDeclaredClasses, other.allDeclaredClasses);
        this.allRecordComponents = flagPredicate.test(this.allRecordComponents, other.allRecordComponents);
        this.allPermittedSubclasses = flagPredicate.test(this.allPermittedSubclasses, other.allPermittedSubclasses);
        this.allNestMembers = flagPredicate.test(this.allNestMembers, other.allNestMembers);
        this.allSigners = flagPredicate.test(this.allSigners, other.allSigners);
        this.allPublicClasses = flagPredicate.test(this.allPublicClasses, other.allPublicClasses);
        this.allDeclaredFieldsAccess = accessCombiner.apply(this.allDeclaredFieldsAccess, other.allDeclaredFieldsAccess);
        this.allPublicFieldsAccess = accessCombiner.apply(this.allPublicFieldsAccess, other.allPublicFieldsAccess);
        this.unsafeAllocated = flagPredicate.test(this.unsafeAllocated, other.unsafeAllocated);
        this.allDeclaredMethodsAccess = accessCombiner.apply(this.allDeclaredMethodsAccess, other.allDeclaredMethodsAccess);
        this.allPublicMethodsAccess = accessCombiner.apply(this.allPublicMethodsAccess, other.allPublicMethodsAccess);
        this.allDeclaredConstructorsAccess = accessCombiner.apply(this.allDeclaredConstructorsAccess, other.allDeclaredConstructorsAccess);
        this.allPublicConstructorsAccess = accessCombiner.apply(this.allPublicConstructorsAccess, other.allPublicConstructorsAccess);
    }

    private boolean isEmpty() {
        return this.methods == null && this.fields == null && this.allFlagsFalse();
    }

    private boolean allFlagsFalse() {
        return !this.allDeclaredClasses && !this.allRecordComponents && !this.allPermittedSubclasses && !this.allNestMembers && !this.allSigners && !this.allPublicClasses && this.allDeclaredFieldsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allPublicFieldsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allDeclaredMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allPublicMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allDeclaredConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allPublicConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    }

    public ConfigurationTypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public synchronized void addField(String name, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, boolean finalButWritable) {
        ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility = ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED;
        if (!finalButWritable && (declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED) && this.allDeclaredFieldsAccess.includes(accessibility) || declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC) && this.allPublicFieldsAccess.includes(accessibility))) {
            this.fields = ConfigurationType.maybeRemove(this.fields, map -> {
                FieldInfo fieldInfo = (FieldInfo)map.get(name);
                if (fieldInfo != null && !fieldInfo.isFinalButWritable()) {
                    map.remove(name);
                }
            });
            return;
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, FieldInfo>();
        }
        this.fields.compute(name, (k, v) -> v != null ? FieldInfo.get(v.getKind().intersect(ConfigurationMemberInfo.get(declaration, accessibility)), v.isFinalButWritable() || finalButWritable) : FieldInfo.get(declaration, accessibility, finalButWritable));
    }

    public void addMethodsWithName(String name, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        this.addMethod(name, null, declaration, accessibility);
    }

    public void addMethod(String name, String internalSignature, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration) {
        this.addMethod(name, internalSignature, declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public synchronized void addMethod(String name, String internalSignature, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        boolean matchesAllSignatures;
        ConfigurationMemberInfo kind = ConfigurationMemberInfo.get(declaration, accessibility);
        boolean bl = matchesAllSignatures = internalSignature == null;
        if (!matchesAllSignatures && !SignatureUtil.isSignatureValid((String)internalSignature, (boolean)true)) {
            return;
        }
        if (ConfigurationMethod.isConstructorName(name) ? this.hasAllConstructors(declaration, accessibility) : this.hasAllMethods(declaration, accessibility)) {
            if (!matchesAllSignatures) {
                if (accessibility == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED) {
                    this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.remove(new ConfigurationMethod(name, internalSignature)));
                } else if (accessibility == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED) {
                    this.methods = ConfigurationType.maybeRemove(this.methods, map -> {
                        ConfigurationMethod method = new ConfigurationMethod(name, internalSignature);
                        if (map.containsKey(method) && ((ConfigurationMemberInfo)map.get(method)).getAccessibility() == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED) {
                            map.remove(method);
                        }
                    });
                }
            }
            return;
        }
        if (this.methods == null) {
            this.methods = new HashMap<ConfigurationMethod, ConfigurationMemberInfo>();
        }
        ConfigurationMethod method = new ConfigurationMethod(name, internalSignature);
        if (matchesAllSignatures) {
            this.methods.compute(method, (k, v) -> v != null ? kind.union((ConfigurationMemberInfo)v) : kind);
            this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.entrySet().removeIf(entry -> name.equals(((ConfigurationMethod)entry.getKey()).getName()) && kind.includes((ConfigurationMemberInfo)entry.getValue()) && !method.equals(entry.getKey())));
        } else {
            this.methods.compute(method, (k, v) -> v != null ? kind.intersect((ConfigurationMemberInfo)v) : kind);
        }
        assert (this.methods.containsKey(method));
    }

    private boolean hasAllConstructors(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        return declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED) && this.allDeclaredConstructorsAccess.includes(accessibility) || declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC) && this.allPublicConstructorsAccess.includes(accessibility);
    }

    private boolean hasAllMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        return declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED) && this.allDeclaredMethodsAccess.includes(accessibility) || declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC) && this.allPublicMethodsAccess.includes(accessibility);
    }

    public synchronized void setAllDeclaredClasses() {
        this.allDeclaredClasses = true;
    }

    public synchronized void setAllRecordComponents() {
        this.allRecordComponents = true;
    }

    public synchronized void setAllPermittedSubclasses() {
        this.allPermittedSubclasses = true;
    }

    public synchronized void setAllNestMembers() {
        this.allNestMembers = true;
    }

    public synchronized void setAllSigners() {
        this.allSigners = true;
    }

    public synchronized void setAllPublicClasses() {
        this.allPublicClasses = true;
    }

    public void setUnsafeAllocated() {
        this.unsafeAllocated = true;
    }

    public synchronized void setAllDeclaredFields(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allDeclaredFieldsAccess.includes(accessibility)) {
            this.allDeclaredFieldsAccess = accessibility;
            this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, this.allDeclaredFieldsAccess);
        }
    }

    public synchronized void setAllPublicFields(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allPublicFieldsAccess.includes(accessibility)) {
            this.allPublicFieldsAccess = accessibility;
            this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, this.allDeclaredFieldsAccess);
        }
    }

    public synchronized void setAllDeclaredMethods(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allDeclaredMethodsAccess.includes(accessibility)) {
            this.allDeclaredMethodsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, accessibility, false);
        }
    }

    public synchronized void setAllPublicMethods(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allPublicMethodsAccess.includes(accessibility)) {
            this.allPublicMethodsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, accessibility, false);
        }
    }

    public synchronized void setAllDeclaredConstructors(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allDeclaredConstructorsAccess.includes(accessibility)) {
            this.allDeclaredConstructorsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, accessibility, true);
        }
    }

    public synchronized void setAllPublicConstructors(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allPublicConstructorsAccess.includes(accessibility)) {
            this.allPublicConstructorsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, accessibility, true);
        }
    }

    public synchronized void printJson(JsonWriter writer) throws IOException {
        Set<ConfigurationMethod> accessedMethods;
        writer.appendObjectStart();
        ConfigurationConditionPrintable.printConditionAttribute(this.condition, writer, true);
        writer.quote("type").appendFieldSeparator();
        this.typeDescriptor.printJson(writer);
        ConfigurationType.printJsonBooleanIfSet(writer, this.allDeclaredFieldsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allDeclaredFields");
        ConfigurationType.printJsonBooleanIfSet(writer, this.allPublicFieldsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allPublicFields");
        ConfigurationType.printJsonBooleanIfSet(writer, this.allDeclaredMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allDeclaredMethods");
        ConfigurationType.printJsonBooleanIfSet(writer, this.allPublicMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allPublicMethods");
        ConfigurationType.printJsonBooleanIfSet(writer, this.allDeclaredConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allDeclaredConstructors");
        ConfigurationType.printJsonBooleanIfSet(writer, this.allPublicConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allPublicConstructors");
        ConfigurationType.printJsonBooleanIfSet(writer, this.unsafeAllocated, "unsafeAllocated");
        if (this.fields != null) {
            writer.appendSeparator().quote("fields").appendFieldSeparator();
            JsonPrinter.printCollection((JsonWriter)writer, this.fields.entrySet(), Map.Entry.comparingByKey(), ConfigurationType::printField);
        }
        if (this.methods != null && !(accessedMethods = this.getMethodsByAccessibility(ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED)).isEmpty()) {
            writer.appendSeparator().quote("methods").appendFieldSeparator();
            JsonPrinter.printCollection((JsonWriter)writer, accessedMethods, Comparator.comparing(ConfigurationMethod::getName).thenComparing(Comparator.nullsFirst(Comparator.comparing(ConfigurationMethod::getInternalSignature))), JsonPrintable::printJson);
        }
        writer.appendObjectEnd();
    }

    private Set<ConfigurationMethod> getMethodsByAccessibility(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        return this.methods.entrySet().stream().filter(e -> ((ConfigurationMemberInfo)e.getValue()).getAccessibility() == accessibility).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static void printField(Map.Entry<String, FieldInfo> entry, JsonWriter w) throws IOException {
        w.appendObjectStart().quote("name").appendFieldSeparator().quote(entry.getKey());
        if (entry.getValue().isFinalButWritable()) {
            w.appendSeparator().quote("allowWrite").appendFieldSeparator().append("true");
        }
        w.appendObjectEnd();
    }

    private static void printJsonBooleanIfSet(JsonWriter writer, boolean predicate, String attribute) throws IOException {
        if (predicate) {
            ConfigurationType.printJsonBoolean(writer, predicate, attribute);
        }
    }

    private static void printJsonBoolean(JsonWriter writer, boolean value, String attribute) throws IOException {
        writer.appendSeparator().quote(attribute).appendFieldSeparator().append(Boolean.toString(value));
    }

    private void removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        ConfigurationMemberInfo kind = ConfigurationMemberInfo.get(declaration, accessibility);
        this.fields = ConfigurationType.maybeRemove(this.fields, map -> map.entrySet().removeIf(entry -> kind.includes(((FieldInfo)entry.getValue()).getKind())));
    }

    private void removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility, boolean constructors) {
        ConfigurationMemberInfo kind = ConfigurationMemberInfo.get(declaration, accessibility);
        this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.entrySet().removeIf(entry -> ((ConfigurationMethod)entry.getKey()).isConstructor() == constructors && kind.includes((ConfigurationMemberInfo)entry.getValue())));
    }

    private static <T, S> Map<T, S> maybeRemove(Map<T, S> fromMap, Consumer<Map<T, S>> action) {
        Map<T, S> map = fromMap;
        if (map != null) {
            action.accept(map);
            if (map.isEmpty()) {
                map = null;
            }
        }
        return map;
    }

    UnresolvedConfigurationCondition getCondition() {
        return this.condition;
    }

    public static final class TestBackdoor {
        public static ConfigurationMemberInfo getMethodInfoIfPresent(ConfigurationType type, ConfigurationMethod method) {
            return type.methods == null ? null : type.methods.get(method);
        }

        public static FieldInfo getFieldInfoIfPresent(ConfigurationType type, String fieldName) {
            return type.fields == null ? null : type.fields.get(fieldName);
        }

        public static ConfigurationMemberInfo.ConfigurationMemberAccessibility getAllDeclaredFields(ConfigurationType self) {
            return self.allDeclaredFieldsAccess;
        }

        public static ConfigurationMemberInfo.ConfigurationMemberAccessibility getAllPublicFields(ConfigurationType type) {
            return type.allPublicFieldsAccess;
        }

        public static boolean haveAllDeclaredClasses(ConfigurationType type) {
            return type.allDeclaredClasses;
        }

        public static boolean haveAllRecordComponents(ConfigurationType type) {
            return type.allRecordComponents;
        }

        public static boolean haveAllPermittedSubclasses(ConfigurationType type) {
            return type.allPermittedSubclasses;
        }

        public static boolean haveAllNestMembers(ConfigurationType type) {
            return type.allNestMembers;
        }

        public static boolean haveAllSigners(ConfigurationType type) {
            return type.allSigners;
        }

        public static boolean haveAllPublicClasses(ConfigurationType type) {
            return type.allPublicClasses;
        }

        public static ConfigurationMemberInfo.ConfigurationMemberAccessibility getAllDeclaredConstructors(ConfigurationType type) {
            return type.allDeclaredConstructorsAccess;
        }

        public static ConfigurationMemberInfo.ConfigurationMemberAccessibility getAllPublicConstructors(ConfigurationType type) {
            return type.allPublicConstructorsAccess;
        }

        private TestBackdoor() {
        }
    }
}

