module com.oracle.svm.svm_enterprise {
    requires com.oracle.graal.graal_enterprise;
    requires java.management;
    requires java.xml;
    requires jdk.graal.compiler;
    requires jdk.internal.vm.ci;
    requires jdk.jfr;
    requires jdk.management;
    requires org.graalvm.collections;
    requires org.graalvm.nativeimage;
    /* transitive */ requires org.graalvm.nativeimage.base;
    requires org.graalvm.nativeimage.builder;
    requires org.graalvm.nativeimage.objectfile;
    /* transitive */ requires org.graalvm.nativeimage.pointsto;
    requires org.graalvm.truffle.compiler;
    /* transitive */ requires org.graalvm.word;

    exports com.oracle.svm.enterprise.buildreport to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.buildreport.flamegraph to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.buildreport.lcov to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core to com.oracle.svm.extraimage_enterprise, com.oracle.svm_enterprise.ml_dataset, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.aarch64 to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.amd64 to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.annotate to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.auximage to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.copying to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.graal to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.graal.code to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.graal.jdk to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.graal.snippets to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.graalos;
    exports com.oracle.svm.enterprise.core.heap to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.hybrid to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.jdk to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.jdk.jni to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.monitor to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.posix to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.posix.mpk to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.riscv64 to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.sboutlining to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.sboutlining.concat to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.core.stringformat to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.gc.g1 to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.gc.g1.graal to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.gc.g1.hosted to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.gc.g1.nativelib to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.graal to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.graal.amd64 to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted to com.oracle.svm.extraimage_enterprise, com.oracle.svm.svm_enterprise.llvm, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.analysis to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.analysis.flow to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.cai to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.code to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.code.layout to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.config to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.hybrid to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.jni to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.layeredimage to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.features to com.oracle.graal.graal_enterprise, com.oracle.svm.extraimage_enterprise, com.oracle.svm_enterprise.ml_dataset, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.features.labelers to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.features.preprocessing to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.features.provider to com.oracle.svm.extraimage_enterprise, com.oracle.svm_enterprise.ml_dataset, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.inferencer to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.logging to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.models to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.phases to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.ml.policies to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.pgo to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.pgo.adapters to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.pgo.features to com.oracle.svm.extraimage_enterprise, com.oracle.svm.svm_enterprise.llvm, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.pgo.loaders to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.pgo.phases to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.pgo.policies to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.pgo.profiles to com.oracle.svm.extraimage_enterprise, com.oracle.svm.svm_enterprise.llvm, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder, org.graalvm.nativeimage.enterprise.configure;
    exports com.oracle.svm.enterprise.hosted.phases to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.phases.priorityinline to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profiling.features to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profiling.features.jfr to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profiling.phases to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profiling.policies to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profiling.utilities to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profilingframework to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profilingframework.instrument to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profilingframework.nodes to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.profilingframework.phases to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.hosted.substitute to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.jitprofiling.vtune to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder, org.graalvm.nativeimage.enterprise.configure;
    exports com.oracle.svm.enterprise.profiling.adapters to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.collect to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.data to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.framework to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder, org.graalvm.nativeimage.enterprise.configure;
    exports com.oracle.svm.enterprise.profiling.framework.collection to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder, org.graalvm.nativeimage.enterprise.configure;
    exports com.oracle.svm.enterprise.profiling.kinds to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.loaders to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder, org.graalvm.nativeimage.enterprise.configure;
    exports com.oracle.svm.enterprise.profiling.metadata to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.metadata.cctree to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.metadata.codepositions to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.metadata.elements to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.nodes to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.path to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.profiling.profiles to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder, org.graalvm.nativeimage.enterprise.configure;
    exports com.oracle.svm.enterprise.sbom to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.sbom.packageurl to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.virtualization.core to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.virtualization.vmm.firecracker to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;
    exports com.oracle.svm.enterprise.virtualization.vmm.qemu to com.oracle.svm.extraimage_enterprise, com.oracle.truffle.enterprise.svm, jdk.graal.compiler, org.graalvm.nativeimage.builder;

    opens com.oracle.svm.enterprise.core.amd64 to jdk.graal.compiler;
    opens com.oracle.svm.enterprise.core.jdk to org.graalvm.nativeimage.builder;
    opens com.oracle.svm.enterprise.hosted.ml.features to com.oracle.graal.graal_enterprise, com.oracle.svm_enterprise.ml_dataset;
    opens com.oracle.svm.enterprise.hosted.phases to jdk.graal.compiler;
    opens com.oracle.svm.enterprise.profiling.nodes to jdk.graal.compiler;

    provides PolicyFactory with SubstratePolicyFactory, SubstrateInlineAllPolicyFactory;
    provides AutomaticallyRegisteredFeatureServiceRegistration with com.oracle.svm.enterprise.virtualization.vmm.firecracker.b, k, com.oracle.svm.enterprise.core.posix.mpk.d, com.oracle.svm.enterprise.profiling.c, com.oracle.svm.enterprise.core.heap.e, com.oracle.svm.enterprise.core.graalos.g, bg, com.oracle.svm.enterprise.hosted.profiling.features.jfr.d, com.oracle.svm.enterprise.hosted.pgo.features.b, com.oracle.svm.enterprise.hosted.profilingframework.c, com.oracle.svm.enterprise.hosted.hybrid.c, com.oracle.svm.enterprise.virtualization.vmm.qemu.b, com.oracle.svm.enterprise.graal.b, com.oracle.svm.enterprise.core.graal.jdk.b, com.oracle.svm.enterprise.core.copying.f, com.oracle.svm.enterprise.hosted.f, com.oracle.svm.enterprise.core.graalos.d, com.oracle.svm.enterprise.core.amd64.j, com.oracle.svm.enterprise.hosted.jni.b, com.oracle.svm.enterprise.core.copying.b, q, p, com.oracle.svm.enterprise.core.posix.b, com.oracle.svm.enterprise.graal.amd64.c, com.oracle.svm.enterprise.core.c, com.oracle.svm.enterprise.core.m, com.oracle.svm.enterprise.core.p, com.oracle.svm.enterprise.core.stringformat.c, com.oracle.svm.enterprise.hosted.profiling.features.b, com.oracle.svm.enterprise.core.heap.b, com.oracle.svm.enterprise.gc.g1.hosted.c, UnsupportedAuxiliaryImageFeature_ServiceRegistration, com.oracle.svm.enterprise.core.posix.e, w, s, com.oracle.svm.enterprise.hosted.profilingframework.f, com.oracle.svm.enterprise.core.f, com.oracle.svm.enterprise.buildreport.lcov.c, com.oracle.svm.enterprise.hosted.code.layout.g, com.oracle.svm.enterprise.core.aarch64.d, com.oracle.svm.enterprise.hosted.ml.features.provider.c, com.oracle.svm.enterprise.buildreport.d, com.oracle.svm.enterprise.hosted.c, com.oracle.svm.enterprise.hosted.i, i, com.oracle.svm.enterprise.core.riscv64.b, com.oracle.svm.enterprise.hosted.phases.b, com.oracle.svm.enterprise.jitprofiling.vtune.c, com.oracle.svm.enterprise.core.amd64.c, u, com.oracle.svm.enterprise.core.v, m, com.oracle.svm.enterprise.core.monitor.c, com.oracle.svm.enterprise.hosted.k, av, com.oracle.svm.enterprise.core.sboutlining.h;
    provides VirtualizationTarget with com.oracle.svm.enterprise.virtualization.vmm.qemu.c, com.oracle.svm.enterprise.virtualization.vmm.firecracker.c;
    provides NativeImageClassLoaderPostProcessing with com.oracle.svm.enterprise.hosted.q;
    provides GeneratedPluginFactory with com.oracle.svm.enterprise.core.hybrid.b, g, com.oracle.svm.enterprise.gc.g1.s, com.oracle.svm.enterprise.graal.d, PluginFactory_RuntimeCodeReferenceWalker, PluginFactory_ProfilingData, ab, PluginFactory_AuxiliaryImageHeapImpl, l, PluginFactory_AuxiliaryImageProvider, com.oracle.svm.enterprise.core.monitor.f, PluginFactory_PersistedRuntimeCode, t, PluginFactory_ProfilingRuntimeProfile, com.oracle.svm.enterprise.gc.g1.u, aa, com.oracle.svm.enterprise.core.hybrid.c, com.oracle.svm.enterprise.gc.g1.w, com.oracle.svm.enterprise.profiling.d, a, h, ae, com.oracle.svm.enterprise.hosted.profilingframework.instrument.d, com.oracle.svm.enterprise.core.aarch64.e, c, af, ad, d, com.oracle.svm.enterprise.gc.g1.v, com.oracle.svm.enterprise.core.heap.f, PluginFactory_InstrumentationData, ac, f, PluginFactory_PersistedContinuationSupport, PluginFactory_PersistedRuntimeCodeInstaller, e;
    provides OptionDescriptors with com.oracle.svm.enterprise.hosted.pgo.features.a, com.oracle.svm.enterprise.hosted.profiling.features.jfr.c, com.oracle.svm.enterprise.hosted.phases.g, com.oracle.svm.enterprise.hosted.phases.priorityinline.i, com.oracle.svm.enterprise.hosted.substitute.c, com.oracle.svm.enterprise.profiling.path.e, com.oracle.svm.enterprise.profiling.path.g, z, com.oracle.svm.enterprise.core.graal.a, com.oracle.svm.enterprise.core.sboutlining.e, ProfilingRuntimeProfile_OptionDescriptors, com.oracle.svm.enterprise.virtualization.core.c, ProfileDumper_OptionDescriptors, j, az, com.oracle.svm.enterprise.buildreport.lcov.b, com.oracle.svm.enterprise.buildreport.lcov.f, com.oracle.svm.enterprise.core.monitor.k, com.oracle.svm.enterprise.hosted.cai.c, b, com.oracle.svm.enterprise.jitprofiling.vtune.e, v, com.oracle.svm.enterprise.gc.g1.k, com.oracle.svm.enterprise.hosted.code.layout.f, com.oracle.svm.enterprise.buildreport.c, com.oracle.svm.enterprise.core.stringformat.d, com.oracle.svm.enterprise.hosted.profilingframework.b, com.oracle.svm.enterprise.hosted.phases.i, AuxiliaryImageTracing_OptionDescriptors, com.oracle.svm.enterprise.hosted.phases.h, com.oracle.svm.enterprise.hosted.profiling.features.a, com.oracle.svm.enterprise.hosted.profilingframework.e, com.oracle.svm.enterprise.hosted.code.layout.c, bd, com.oracle.svm.enterprise.core.amd64.e;

}

