/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.loaders;

import com.oracle.svm.enterprise.profiling.ProfilingJsonUtils;
import com.oracle.svm.enterprise.profiling.framework.ProfilingMethod;
import com.oracle.svm.enterprise.profiling.framework.ProfilingType;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.util.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import jdk.graal.compiler.util.json.JsonParser;
import jdk.graal.compiler.util.json.JsonParserException;

public final class IprofContent {
    private static final String MALFORMED_IPROF_FILE_PATTERN = "Malformed iprof file: missing %s field.";
    private final Map<Integer, ProfilingType> idToProfilingType;
    private final Map<Integer, ProfilingMethod> idToProfilingMethod;
    private final Map<String, Map<CallingContext, long[]>> content;

    public static IprofContent parseFromIprof(Path path, Consumer<String> consumer, boolean bl2, List<String> list) {
        block9: {
            IprofContent iprofContent;
            JsonParser jsonParser = null;
            File file = path.toFile();
            long l2 = file.length();
            InputStreamReader inputStreamReader = new InputStreamReader(IprofContent.handleGzipStream(file));
            try {
                jsonParser = new JsonParser((Reader)inputStreamReader);
                Object object = jsonParser.parse();
                IprofContent.verifyVersion(object, consumer, path, bl2);
                HashMap<Integer, ProfilingType> hashMap = new HashMap<Integer, ProfilingType>();
                HashMap<Integer, ProfilingMethod> hashMap2 = new HashMap<Integer, ProfilingMethod>();
                HashMap<String, Map<CallingContext, long[]>> hashMap3 = new HashMap<String, Map<CallingContext, long[]>>();
                IprofContent.populateMaps(object, list, hashMap, hashMap2, hashMap3, consumer);
                iprofContent = new IprofContent(hashMap, hashMap2, hashMap3);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    consumer.accept(String.format("Cannot load profile %s (reason: %s). Please verify that the file exists and has appropriate access rights.", file, iOException));
                    break block9;
                }
                catch (JsonParserException jsonParserException) {
                    assert (jsonParser != null);
                    consumer.accept(String.format("Malformed JSON in %s (reason: %s). The original file size before parsing is %d, after parsing is %d, and the parsed file size is %d.", new Object[]{file, jsonParserException, l2, file.length(), jsonParser.getSourceLength()}));
                }
            }
            inputStreamReader.close();
            return iprofContent;
        }
        return new IprofContent(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private static InputStream handleGzipStream(File file) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new FileInputStream(file), 2);
        int n2 = pushbackInputStream.read();
        int n3 = pushbackInputStream.read();
        pushbackInputStream.unread(n3);
        pushbackInputStream.unread(n2);
        int n4 = n3 << 8 | n2;
        if (n4 == 35615) {
            return new GZIPInputStream(pushbackInputStream);
        }
        return pushbackInputStream;
    }

    private static void populateMaps(Object object, List<String> list, Map<Integer, ProfilingType> map, Map<Integer, ProfilingMethod> map2, Map<String, Map<CallingContext, long[]>> map3, Consumer<String> consumer) {
        Object object2;
        Integer n2;
        Object object32;
        List list2 = (List)ProfilingJsonUtils.getValue(object, "types");
        if (list2 == null) {
            consumer.accept(String.format(MALFORMED_IPROF_FILE_PATTERN, "types"));
            return;
        }
        for (Object object32 : list2) {
            n2 = (Integer)ProfilingJsonUtils.getValue(object32, "id");
            object2 = (String)ProfilingJsonUtils.getValue(object32, "name");
            map.put(n2, new ProfilingType(n2, (String)object2));
        }
        List list3 = (List)ProfilingJsonUtils.getValue(object, "methods");
        if (list3 == null) {
            consumer.accept(String.format(MALFORMED_IPROF_FILE_PATTERN, "methods"));
            return;
        }
        object32 = list3.iterator();
        while (object32.hasNext()) {
            n2 = object32.next();
            object2 = (Integer)ProfilingJsonUtils.getValue(n2, "id");
            String string = (String)ProfilingJsonUtils.getValue(n2, "name");
            List list4 = (List)ProfilingJsonUtils.getValue(n2, "signature");
            int[] nArray = new int[list4.size()];
            for (int i2 = 0; i2 < list4.size(); ++i2) {
                nArray[i2] = (Integer)list4.get(i2);
            }
            map2.put((Integer)object2, new ProfilingMethod((Integer)object2, string, nArray));
        }
        if (!list.contains("callCountProfiles")) {
            IprofContent.populateContent(object, "callCountProfiles", map3);
        }
        if (!list.contains("conditionalProfiles")) {
            IprofContent.populateContent(object, "conditionalProfiles", map3);
        }
        if (!list.contains("virtualInvokeProfiles")) {
            IprofContent.populateContent(object, "virtualInvokeProfiles", map3);
        }
        if (!list.contains("monitorProfiles")) {
            IprofContent.populateContent(object, "monitorProfiles", map3);
        }
        if (!list.contains("samplingProfiles")) {
            IprofContent.populateContent(object, "samplingProfiles", map3);
        }
        if (!list.contains("instanceOfProfiles")) {
            IprofContent.populateContent(object, "instanceOfProfiles", map3);
        }
    }

    private static void populateContent(Object object, String string, Map<String, Map<CallingContext, long[]>> map) {
        HashMap<CallingContext, long[]> hashMap = new HashMap<CallingContext, long[]>();
        List list = (List)ProfilingJsonUtils.getValue(object, string);
        if (list == null) {
            return;
        }
        for (Object e2 : list) {
            String string2 = ProfilingJsonUtils.getString(e2, "ctx");
            long[] lArray = ProfilingJsonUtils.getPrimitiveArray(e2, "records", long[].class);
            ArrayList<CodePosition> arrayList = new ArrayList<CodePosition>();
            for (String string3 : string2.split("<")) {
                String[] stringArray = string3.split(":");
                arrayList.add(new CodePosition(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])));
            }
            hashMap.put(CallingContext.create(arrayList), lArray);
        }
        map.put(string, hashMap);
    }

    private static void verifyVersion(Object object, Consumer<String> consumer, Path path, boolean bl2) {
        String string = ProfilingJsonUtils.getString(object, "version");
        if (string == null) {
            consumer.accept(MALFORMED_IPROF_FILE_PATTERN.formatted("version"));
            return;
        }
        if (!IprofContent.isCompatible(string)) {
            String string2 = String.format("The profile %s, with version %s, is incompatible with the profile version %s, that is supported on GraalVM used for the build. It is possible that given profile is generated with different GraalVM version. Please ensure that you are using a valid and supported profiles.", path, string, "1.0.0");
            if (bl2) {
                LogUtils.warning((String)string2);
            } else {
                consumer.accept(string2);
            }
        }
    }

    private static boolean isCompatible(String string) {
        int n2 = string.indexOf(".");
        int n3 = string.lastIndexOf(".");
        if (n2 == -1 || n2 == n3) {
            return false;
        }
        try {
            int n4 = Integer.parseInt(string.substring(0, n2));
            int n5 = Integer.parseInt(string.substring(n2 + 1, n3));
            Integer.parseInt(string.substring(n3 + 1));
            if (n4 == 1 || n4 == 0 && n5 == 4) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return false;
    }

    public IprofContent(Map<Integer, ProfilingType> map, Map<Integer, ProfilingMethod> map2, Map<String, Map<CallingContext, long[]>> map3) {
        this.idToProfilingType = map;
        this.idToProfilingMethod = map2;
        this.content = map3;
    }

    public Map<Integer, ProfilingType> idToProfilingType() {
        return this.idToProfilingType;
    }

    public Map<Integer, ProfilingMethod> idToProfilingMethod() {
        return this.idToProfilingMethod;
    }

    public Map<String, Map<CallingContext, long[]>> content() {
        return this.content;
    }
}

