/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.enterprise.profiling.framework.ProfilingMethod;
import com.oracle.svm.enterprise.profiling.framework.ProfilingType;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.IntSupplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class Metadata {
    private final ProfilingType[] types;
    private final ProfilingMethod[] methods;
    private final CallingContextForest forest;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private final int maxMonitorTypeID;
    private final int[] knownMonitorTypeIDs;

    public Metadata(ProfilingType[] profilingTypeArray, ProfilingMethod[] profilingMethodArray, CallingContextForest callingContextForest, int n2, int[] nArray) {
        assert (n2 <= 0 || nArray == null) : "Cannot use both maxTypeID and knownTypeIDs.";
        this.types = profilingTypeArray;
        this.methods = profilingMethodArray;
        this.forest = callingContextForest;
        this.maxMonitorTypeID = n2;
        this.knownMonitorTypeIDs = nArray;
    }

    public ProfilingType[] types() {
        return this.types;
    }

    public ProfilingMethod[] methods() {
        return this.methods;
    }

    public CallingContextForest forest() {
        return this.forest;
    }

    public void forEachMonitorTypeID(TypeIDConsumer typeIDConsumer) {
        if (this.knownMonitorTypeIDs != null) {
            for (int n2 : this.knownMonitorTypeIDs) {
                typeIDConsumer.accept(n2);
            }
            return;
        }
        for (int i2 = 0; i2 < this.maxMonitorTypeID; ++i2) {
            typeIDConsumer.accept(i2);
        }
    }

    @FunctionalInterface
    public static interface TypeIDConsumer {
        public void accept(int var1);
    }

    public static class Builder {
        private final Set<ProfilingType> types = new TreeSet<ProfilingType>(Comparator.comparingInt(ProfilingType::id));
        private final Set<ProfilingMethod> methods = new TreeSet<ProfilingMethod>(Comparator.comparingInt(ProfilingMethod::id));
        private final CallingContextForest forest = new CallingContextForest();
        private final Set<String> typesToInstrument = new HashSet<String>();
        private int maxTypeID = 0;
        private int[] knownTypeIDs;

        public int addIfAbsent(CallingContext callingContext, CallingContextForest.Payload payload, IntSupplier intSupplier) {
            return this.forest.addIfAbsent(callingContext, payload, intSupplier);
        }

        public void add(HostedType hostedType) {
            if (this.shouldInstrumentType(hostedType)) {
                this.add(new ProfilingType(hostedType));
            }
        }

        public void add(ProfilingType profilingType) {
            this.types.add(profilingType);
        }

        public void add(HostedMethod hostedMethod) {
            this.add(new ProfilingMethod(hostedMethod));
        }

        public void add(ProfilingMethod profilingMethod) {
            this.methods.add(profilingMethod);
        }

        public Metadata compressedBuild() {
            this.forest.compress();
            return this.build();
        }

        public Metadata build() {
            return new Metadata((ProfilingType[])this.types.toArray(ProfilingType[]::new), (ProfilingMethod[])this.methods.toArray(ProfilingMethod[]::new), this.forest, this.maxTypeID, this.knownTypeIDs);
        }

        public Set<ProfilingMethod> methods() {
            return this.methods;
        }

        public void reset() {
            this.types.clear();
            this.methods.clear();
            this.forest.clear();
        }

        public void setMaxMonitorTypeID(int n2) {
            if (this.knownTypeIDs != null) {
                throw new IllegalStateException("Cannot set both maxMonitorTypeID and knownTypeIDs. Use one or the other.");
            }
            this.maxTypeID = n2;
        }

        public void setTypesToInstrument(Set<String> set) {
            this.typesToInstrument.addAll(set);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public boolean shouldInstrumentType(HostedType hostedType) {
            if (this.typesToInstrument.isEmpty()) {
                return true;
            }
            if (hostedType.isPrimitive() || hostedType.isArray() && hostedType.getBaseType().isPrimitive()) {
                return true;
            }
            return this.typesToInstrument.contains(hostedType.toClassName());
        }

        public CallingContextForest forest() {
            return this.forest;
        }

        public void setKnownTypeIDs(int[] nArray) {
            if (this.maxTypeID > 0) {
                throw new IllegalStateException("Cannot set both maxTypeID and knownTypeIDs. Use one or the other.");
            }
            this.knownTypeIDs = nArray;
        }

        public void addMethodTypes(HostedMethod hostedMethod) {
            this.types.add(new ProfilingType(hostedMethod.getDeclaringClass()));
            ResolvedSignature resolvedSignature = hostedMethod.getSignature();
            this.types.add(new ProfilingType((HostedType)resolvedSignature.getReturnType()));
            for (HostedType hostedType : resolvedSignature.toParameterList(null)) {
                this.types.add(new ProfilingType(hostedType));
            }
        }
    }
}

