/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.enterprise.core.annotate.a;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationKind;
import com.oracle.svm.enterprise.profiling.framework.InstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import java.util.Arrays;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.word.LocationIdentity;

public abstract class CommonInstrumentationData
extends InstrumentationData {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor PROFILE_VIRTUAL_CALL_RECEIVER_TYPE = SnippetRuntime.findForeignCall(ProfilingRuntimeCalls.class, (String)"profileReceiverType", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{PROFILING_LOCATION});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{PROFILE_VIRTUAL_CALL_RECEIVER_TYPE};
    public static final int COUNTER_ID_FOR_MONITOR_COUNTS = 0;
    private static final long STRIP_ID_FOR_TYPE_IDS = 0L;

    CommonInstrumentationData(InstrumentationData.Storage storage) {
        super(storage);
    }

    @Override
    public SnippetRuntime.SubstrateForeignCallDescriptor[] foreignCalls() {
        SnippetRuntime.SubstrateForeignCallDescriptor[] substrateForeignCallDescriptorArray = super.foreignCalls();
        SnippetRuntime.SubstrateForeignCallDescriptor[] substrateForeignCallDescriptorArray2 = Arrays.copyOf(substrateForeignCallDescriptorArray, substrateForeignCallDescriptorArray.length + FOREIGN_CALLS.length);
        System.arraycopy(FOREIGN_CALLS, 0, substrateForeignCallDescriptorArray2, substrateForeignCallDescriptorArray.length, FOREIGN_CALLS.length);
        return substrateForeignCallDescriptorArray2;
    }

    public long readMonitorCount(long l2, int n2) {
        InstrumentationData.CounterWordSize counterWordSize = this.storage.counterWordSize();
        int n3 = this.storage.counterWordSize().byteCount() * n2;
        return counterWordSize == InstrumentationData.CounterWordSize.Bits64 ? this.storage.readLong(l2, 0, n3) : (long)this.storage.readInt(l2, 0, n3);
    }

    public long readTotalMonitorCount(int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.storage.stripsPerCounter(); ++i2) {
            l2 += this.readMonitorCount(i2, n2);
        }
        return l2;
    }

    public void sideEffectFreeWriteMonitorCount(long l2, int n2, long l3) {
        InstrumentationData.CounterWordSize counterWordSize = this.storage.counterWordSize();
        int n3 = this.storage.counterWordSize().byteCount() * n2;
        if (counterWordSize == InstrumentationData.CounterWordSize.Bits64) {
            this.storage.sideEffectFreeWriteLong(l2, 0, n3, l3);
        } else {
            this.storage.sideEffectFreeWriteInt(l2, 0, n3, (int)l3);
        }
    }

    public static class ProfilingRuntimeCalls {
        public static final int MAX_PROFILE_TYPES = 8;
        public static final int NO_TYPE_ID = -1;
        private static final int BYTES_PER_TYPE_ID = 4;

        public static int virtualCallComponentsPerCounter() {
            if (InstrumentationData.Storage.singleton().counterWordSize() == InstrumentationData.CounterWordSize.Bits64) {
                return 12;
            }
            return 16;
        }

        @a
        @SubstrateForeignCallTarget(stubCallingConvention=false)
        @Uninterruptible(reason="This method must not have a stack-overflow check as it is used before the thread register is assigned.")
        private static void profileReceiverType(Object object, long l2, int n2) {
            int n3;
            if (object == null) {
                return;
            }
            int n4 = 0;
            int n5 = DynamicHub.fromClass(object.getClass()).getTypeID();
            InstrumentationData.Storage storage = InstrumentationData.Storage.singleton();
            while (true) {
                if (n4 >= 8) {
                    return;
                }
                n3 = storage.readInt(0L, n2, n4 * 4);
                if (n3 == n5 || n3 == 0) break;
                ++n4;
            }
            if (n3 == 0 && !storage.casInt(0L, n2, n4 * 4, 0, n5)) {
                return;
            }
            if (storage.counterWordSize() == InstrumentationData.CounterWordSize.Bits64) {
                int n6 = (4 + n4) * storage.counterWordSize().byteCount();
                long l3 = storage.readLong(l2, n2, n6);
                storage.sideEffectFreeWriteLong(l2, n2, n6, l3 + 1L);
            } else {
                int n7 = (8 + n4) * storage.counterWordSize().byteCount();
                int n8 = storage.readInt(l2, n2, n7);
                storage.sideEffectFreeWriteInt(l2, n2, n7, n8 + 1);
            }
        }
    }

    public static final class SwitchPayload
    extends ConditionalPayload {
        private final int[] successorBCIsAndKeySuccessors;

        public SwitchPayload(int[] nArray, int[] nArray2) {
            assert (nArray.length == nArray2.length) : "Both arrays must correspond to number of successors.";
            this.successorBCIsAndKeySuccessors = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, this.successorBCIsAndKeySuccessors, 0, nArray.length);
            System.arraycopy(nArray2, 0, this.successorBCIsAndKeySuccessors, nArray.length, nArray2.length);
        }

        @Override
        public int length() {
            return this.successorBCIsAndKeySuccessors.length / 2;
        }

        @Override
        public int bciAt(int n2) {
            assert (n2 < this.length());
            return this.successorBCIsAndKeySuccessors[n2];
        }

        @Override
        public int successorAt(int n2) {
            assert (n2 < this.length());
            return this.successorBCIsAndKeySuccessors[this.length() + n2];
        }

        @Override
        protected boolean sameAs(CallingContextForest.Payload payload) {
            if (!(payload instanceof SwitchPayload)) {
                return false;
            }
            SwitchPayload switchPayload = (SwitchPayload)payload;
            return Arrays.equals(this.successorBCIsAndKeySuccessors, switchPayload.successorBCIsAndKeySuccessors);
        }
    }

    public static final class IfPayload
    extends ConditionalPayload {
        @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
        private final int trueBci;
        @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
        private final int falseBci;

        public IfPayload(int[] nArray) {
            assert (nArray.length == 2) : "If node must have only two successors";
            this.trueBci = nArray[0];
            this.falseBci = nArray[1];
        }

        @Override
        protected boolean sameAs(CallingContextForest.Payload payload) {
            if (!(payload instanceof IfPayload)) {
                return false;
            }
            IfPayload ifPayload = (IfPayload)payload;
            return this.trueBci == ifPayload.trueBci && this.falseBci == ifPayload.falseBci;
        }

        @Override
        public int length() {
            return 2;
        }

        public String toString() {
            return "IfPayload{trueBci=" + this.trueBci + ", falseBci=" + this.falseBci + "}";
        }

        @Override
        public int bciAt(int n2) {
            assert (n2 < this.length());
            if (n2 == 0) {
                return this.trueBci;
            }
            if (n2 == 1) {
                return this.falseBci;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int successorAt(int n2) {
            assert (n2 < this.length());
            return n2;
        }
    }

    public static abstract class ConditionalPayload
    extends CallingContextForest.Payload {
        public static final int RECORD_MULTIPLIER = 3;

        @Override
        public String key() {
            return CommonInstrumentationKind.Conditional.toString();
        }

        public final long readTotalCounterValue(InstrumentationData.Storage storage, int n2) {
            long l2 = 0L;
            for (int i2 = 0; i2 < storage.stripsPerCounter(); ++i2) {
                int n3 = this.value();
                int n4 = n2 * storage.counterWordSize().byteCount();
                if (storage.counterWordSize() == InstrumentationData.CounterWordSize.Bits64) {
                    l2 += storage.readLong(i2, n3, n4);
                    continue;
                }
                l2 += (long)storage.readInt(i2, n3, n4);
            }
            return l2;
        }

        public abstract int length();

        public abstract int bciAt(int var1);

        public abstract int successorAt(int var1);
    }

    public static class InstanceOfPayload
    extends CallingContextForest.Payload {
        private final int[] typeIDs;

        public InstanceOfPayload(int[] nArray) {
            this.typeIDs = nArray;
        }

        public int length() {
            if (this.typeIDs == null) {
                return 8;
            }
            return this.typeIDs.length;
        }

        public boolean isNoTypeID(int n2) {
            return n2 == -1;
        }

        public int typeID(InstrumentationData.Storage storage, int n2) {
            if (this.typeIDs == null) {
                return this.typeIDFromRunTimeTypeIDs(storage, n2);
            }
            return this.typeIDFromBuildTimeTypeIDs(n2);
        }

        public String toString() {
            return "InstanceOfPayload{typeIDs=" + Arrays.toString(this.typeIDs) + "}";
        }

        private int typeIDFromRunTimeTypeIDs(InstrumentationData.Storage storage, int n2) {
            int n3 = this.value();
            InstrumentationData.CounterWordSize counterWordSize = storage.counterWordSize();
            int n4 = counterWordSize == InstrumentationData.CounterWordSize.Bits64 ? n2 * counterWordSize.byteCount() / 2 : n2 * counterWordSize.byteCount();
            return storage.readInt(0L, n3, n4);
        }

        private int typeIDFromBuildTimeTypeIDs(int n2) {
            if (n2 < this.typeIDs.length) {
                return this.typeIDs[n2];
            }
            return -1;
        }

        public long readTotalCounterValue(InstrumentationData.Storage storage, int n2) {
            if (this.typeIDs == null) {
                return this.counterValueFromRunTimeTypeIDs(storage, n2);
            }
            return this.counterValueFromBuildTimeTypeIDs(storage, n2);
        }

        private long counterValueFromBuildTimeTypeIDs(InstrumentationData.Storage storage, int n2) {
            long l2 = 0L;
            for (int i2 = 0; i2 < storage.stripsPerCounter(); ++i2) {
                InstrumentationData.CounterWordSize counterWordSize = storage.counterWordSize();
                int n3 = n2 * counterWordSize.byteCount();
                if (counterWordSize == InstrumentationData.CounterWordSize.Bits64) {
                    l2 += storage.readLong(i2, this.value(), n3);
                    continue;
                }
                l2 += (long)storage.readInt(i2, this.value(), n3);
            }
            return l2;
        }

        private long counterValueFromRunTimeTypeIDs(InstrumentationData.Storage storage, int n2) {
            long l2 = 0L;
            for (int i2 = 0; i2 < storage.stripsPerCounter(); ++i2) {
                int n3;
                InstrumentationData.CounterWordSize counterWordSize = storage.counterWordSize();
                if (counterWordSize == InstrumentationData.CounterWordSize.Bits64) {
                    n3 = (4 + n2) * counterWordSize.byteCount();
                    l2 += storage.readLong(i2, this.value(), n3);
                    continue;
                }
                n3 = (8 + n2) * counterWordSize.byteCount();
                l2 += (long)storage.readInt(i2, this.value(), n3);
            }
            return l2;
        }

        @Override
        public String key() {
            return "instanceof";
        }

        @Override
        protected boolean sameAs(CallingContextForest.Payload payload) {
            if (!(payload instanceof InstanceOfPayload)) {
                return false;
            }
            InstanceOfPayload instanceOfPayload = (InstanceOfPayload)payload;
            return Arrays.equals(this.typeIDs, instanceOfPayload.typeIDs);
        }
    }

    public static class VirtualCallPayload
    extends CallingContextForest.Payload {
        private final int[] typeIDs;

        public VirtualCallPayload(int[] nArray) {
            this.typeIDs = nArray;
        }

        public int length() {
            if (this.typeIDs == null) {
                return 8;
            }
            return this.typeIDs.length;
        }

        public boolean isNoTypeID(int n2) {
            return n2 == -1;
        }

        public int typeID(InstrumentationData.Storage storage, int n2) {
            if (this.typeIDs == null) {
                return this.typeIDFromRunTimeTypeIDs(storage, n2);
            }
            return this.typeIDFromBuildTimeTypeIDs(n2);
        }

        public String toString() {
            return "VirtualCallPayload{typeIDs=" + Arrays.toString(this.typeIDs) + "}";
        }

        private int typeIDFromRunTimeTypeIDs(InstrumentationData.Storage storage, int n2) {
            int n3 = this.value();
            InstrumentationData.CounterWordSize counterWordSize = storage.counterWordSize();
            int n4 = counterWordSize == InstrumentationData.CounterWordSize.Bits64 ? n2 * counterWordSize.byteCount() / 2 : n2 * counterWordSize.byteCount();
            return storage.readInt(0L, n3, n4);
        }

        private int typeIDFromBuildTimeTypeIDs(int n2) {
            if (n2 < this.typeIDs.length) {
                return this.typeIDs[n2];
            }
            return -1;
        }

        public long readTotalCounterValue(InstrumentationData.Storage storage, int n2) {
            if (this.typeIDs == null) {
                return this.counterValueFromRunTimeTypeIDs(storage, n2);
            }
            return this.counterValueFromBuildTimeTypeIDs(storage, n2);
        }

        private long counterValueFromBuildTimeTypeIDs(InstrumentationData.Storage storage, int n2) {
            long l2 = 0L;
            for (int i2 = 0; i2 < storage.stripsPerCounter(); ++i2) {
                InstrumentationData.CounterWordSize counterWordSize = storage.counterWordSize();
                int n3 = n2 * counterWordSize.byteCount();
                if (counterWordSize == InstrumentationData.CounterWordSize.Bits64) {
                    l2 += storage.readLong(i2, this.value(), n3);
                    continue;
                }
                l2 += (long)storage.readInt(i2, this.value(), n3);
            }
            return l2;
        }

        private long counterValueFromRunTimeTypeIDs(InstrumentationData.Storage storage, int n2) {
            long l2 = 0L;
            for (int i2 = 0; i2 < storage.stripsPerCounter(); ++i2) {
                int n3;
                InstrumentationData.CounterWordSize counterWordSize = storage.counterWordSize();
                if (counterWordSize == InstrumentationData.CounterWordSize.Bits64) {
                    n3 = (4 + n2) * counterWordSize.byteCount();
                    l2 += storage.readLong(i2, this.value(), n3);
                    continue;
                }
                n3 = (8 + n2) * counterWordSize.byteCount();
                l2 += (long)storage.readInt(i2, this.value(), n3);
            }
            return l2;
        }

        @Override
        public String key() {
            return CommonInstrumentationKind.VirtualCall.toString();
        }

        @Override
        protected boolean sameAs(CallingContextForest.Payload payload) {
            if (!(payload instanceof VirtualCallPayload)) {
                return false;
            }
            VirtualCallPayload virtualCallPayload = (VirtualCallPayload)payload;
            return Arrays.equals(this.typeIDs, virtualCallPayload.typeIDs);
        }
    }

    public static class MethodEntryPayload
    extends CallingContextForest.Payload {
        @Override
        public String key() {
            return CommonInstrumentationKind.MethodEntry.toString();
        }

        @Override
        protected boolean sameAs(CallingContextForest.Payload payload) {
            return payload instanceof MethodEntryPayload;
        }

        public long readTotalCounterValue(InstrumentationData.Storage storage) {
            long l2 = 0L;
            for (int i2 = 0; i2 < storage.stripsPerCounter(); ++i2) {
                int n2 = this.value();
                if (storage.counterWordSize() == InstrumentationData.CounterWordSize.Bits64) {
                    l2 += storage.readLong(i2, n2, 0);
                    continue;
                }
                int n3 = storage.readInt(i2, n2, 0);
                l2 += (long)n3 & 0xFFFFFFFFL;
            }
            return l2;
        }
    }
}

