/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profilingframework.instrument;

import com.oracle.svm.core.code.IsolateEnterStub;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.profiling.features.ProfilingFeature;
import com.oracle.svm.enterprise.hosted.profilingframework.instrument.b;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.c;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.d;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.e;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.f;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.g;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.h;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.i;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.j;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.k;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.l;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.InstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.ProfilingData;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.SideEffectFreeWriteNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;

public abstract class a
implements b {
    private final Metadata.Builder xc;
    private final InstrumentationData xd;

    protected a(InstrumentationData instrumentationData) {
        this.xd = instrumentationData;
        this.xc = new Metadata.Builder();
    }

    @Override
    public Metadata.Builder hG() {
        return this.xc;
    }

    @Override
    public void a(g g2, LoweringTool loweringTool) {
        if (g2 instanceof h) {
            h h2 = (h)g2;
            this.a(h2, loweringTool);
        } else if (g2 instanceof c) {
            c c2 = (c)g2;
            this.a(c2, loweringTool);
        } else if (g2 instanceof l) {
            l l2 = (l)g2;
            this.a(l2, loweringTool);
        } else if (g2 instanceof f) {
            f f2 = (f)g2;
            this.a(f2, loweringTool);
        } else if (g2 instanceof e) {
            e e2 = (e)g2;
            this.a(e2, loweringTool);
        } else {
            b.super.a(g2, loweringTool);
        }
    }

    @Override
    public boolean e(ResolvedJavaMethod resolvedJavaMethod) {
        return ((SharedMethod)resolvedJavaMethod).isEntryPoint();
    }

    @Override
    public void a(OptionValues optionValues, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> map) {
        b.super.a(optionValues, providers, map);
        new a(optionValues, providers, map);
    }

    @Override
    public void a(FeatureImpl.BeforeCompilationAccessImpl beforeCompilationAccessImpl) {
        this.hH();
        this.b(beforeCompilationAccessImpl);
    }

    private void hH() {
        if (!((Boolean)ProfilingFeature.Options.ProfilingEnabled.getValue()).booleanValue()) {
            this.xc.setMaxMonitorTypeID(0);
            return;
        }
        int n2 = ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId();
        VMError.guarantee((n2 > 0 ? 1 : 0) != 0, (String)"maxTypeID should be positive!");
        int n3 = ProfilingData.singleton().commonInstrumentationData().reserveUniqueCounterIDSlots(n2 + 1);
        VMError.guarantee((n3 == 0 ? 1 : 0) != 0, (String)"The monitor record should be at the beginning of the data storage.");
        this.xc.setMaxMonitorTypeID(n2);
    }

    private void b(FeatureImpl.BeforeCompilationAccessImpl beforeCompilationAccessImpl) {
        if (!ProfilingFeature.Options.ProfilingPackagePrefixes.hasBeenSet()) {
            this.xc.setTypesToInstrument(Collections.emptySet());
            return;
        }
        Set set = Arrays.stream(((String)ProfilingFeature.Options.ProfilingPackagePrefixes.getValue()).split(",")).map(string -> string.split("\\.")).map(Arrays::asList).collect(Collectors.toSet());
        Set<String> set2 = beforeCompilationAccessImpl.getUniverse().getTypes().stream().filter(hostedType -> a.a(hostedType, set)).map(JavaType::toClassName).collect(Collectors.toSet());
        set2.add(IsolateEnterStub.class.getName());
        this.xc.setTypesToInstrument(set2);
    }

    private static boolean a(HostedType hostedType, Set<List<String>> set) {
        if (hostedType.isPrimitive() || hostedType.isArray() && hostedType.getBaseType().isPrimitive()) {
            return true;
        }
        List<String> list = a.b(hostedType);
        return set.stream().anyMatch(list2 -> a.b(list, list2));
    }

    private static List<String> b(HostedType hostedType) {
        String[] stringArray = hostedType.toJavaName().split("\\.");
        return List.of(Arrays.copyOf(stringArray, stringArray.length - 1));
    }

    private static boolean b(List<String> list, List<String> list2) {
        if (list2.size() > list.size()) {
            return false;
        }
        return list.subList(0, list2.size()).equals(list2);
    }

    @Override
    public boolean C(HostedMethod hostedMethod) {
        return !SubstrateCompilationDirectives.isDeoptTarget((ResolvedJavaMethod)hostedMethod) && !this.xd.isTypeNonInstrumentable(hostedMethod.getDeclaringClass().getJavaClass().getName()) && this.xc.shouldInstrumentType(hostedMethod.getDeclaringClass());
    }

    private void a(h h2, LoweringTool loweringTool) {
        if (h2.getNodeSourcePosition() == null) {
            assert (false) : "Should not call lower with node without node source position.";
            h2.graph().removeFixed((FixedWithNextNode)h2);
            return;
        }
        this.a(h2, loweringTool, new CommonInstrumentationData.MethodEntryPayload(), () -> this.xd.reserveUniqueCounterIDSlots(1), 0);
    }

    private void a(d d2, LoweringTool loweringTool, CallingContextForest.Payload payload, IntSupplier intSupplier, int n2) {
        this.b(d2, loweringTool, payload, intSupplier, n2);
        d2.graph().removeFixed((FixedWithNextNode)d2);
    }

    protected void a(StructuredGraph structuredGraph, d d2, OffsetAddressNode offsetAddressNode) {
        InstrumentationData.CounterWordSize counterWordSize = this.xd.storage().counterWordSize();
        JavaKind javaKind = counterWordSize.kind();
        ValueNode valueNode = counterWordSize == InstrumentationData.CounterWordSize.Bits64 ? (ValueNode)structuredGraph.unique((Node)ConstantNode.forLong((long)1L)) : (ValueNode)structuredGraph.unique((Node)ConstantNode.forInt((int)1));
        ReadNode readNode = (ReadNode)structuredGraph.add((Node)new ReadNode((AddressNode)offsetAddressNode, InstrumentationData.PROFILING_LOCATION, StampFactory.forKind((JavaKind)javaKind), BarrierType.NONE, MemoryOrderMode.PLAIN));
        ValueNode valueNode2 = (ValueNode)structuredGraph.addOrUniqueWithInputs((Node)AddNode.create((ValueNode)readNode, (ValueNode)valueNode, (NodeView)NodeView.DEFAULT));
        WriteNode writeNode = (WriteNode)structuredGraph.add((Node)SideEffectFreeWriteNode.createWithoutSideEffect((AddressNode)offsetAddressNode, (LocationIdentity)InstrumentationData.PROFILING_LOCATION, (ValueNode)valueNode2));
        structuredGraph.addBeforeFixed((FixedNode)d2, (FixedWithNextNode)writeNode);
        structuredGraph.addBeforeFixed((FixedNode)writeNode, (FixedWithNextNode)readNode);
    }

    private void a(c c2, LoweringTool loweringTool) {
        if (c2.getNodeSourcePosition() == null) {
            assert (false) : "Should not call lower with node without node source position.";
            c2.graph().removeFixed((FixedWithNextNode)c2);
        }
        CommonInstrumentationData.ConditionalPayload conditionalPayload = c2.hU() ? new CommonInstrumentationData.IfPayload(c2.hS()) : new CommonInstrumentationData.SwitchPayload(c2.hS(), c2.hT());
        this.a(c2, loweringTool, conditionalPayload, () -> this.xd.reserveUniqueCounterIDSlots(c2.hT().length), c2.hR());
    }

    private void a(e e2, LoweringTool loweringTool) {
        this.a(e2, loweringTool, new CommonInstrumentationData.VirtualCallPayload(e2.hX()), () -> ProfilingData.singleton().commonInstrumentationData().reserveUniqueCounterIDSlots(e2.hW().length), e2.hV());
    }

    private void a(f f2, LoweringTool loweringTool) {
        assert (f2.hW() == null) : "Unexpected non-null type profile for instanceof node" + String.valueOf(f2.hZ());
        this.a(f2, loweringTool, new CommonInstrumentationData.InstanceOfPayload(null));
        f2.graph().removeFixed((FixedWithNextNode)f2);
    }

    private void a(l l2, LoweringTool loweringTool) {
        if (l2.hW() == null) {
            this.a(l2, loweringTool, new CommonInstrumentationData.VirtualCallPayload(null));
        } else if (l2.hW().length != 0) {
            this.b(l2, loweringTool);
        }
        l2.graph().removeFixed((FixedWithNextNode)l2);
    }

    public static CallingContext a(NodeSourcePosition nodeSourcePosition) {
        assert (nodeSourcePosition != null);
        ArrayList<CodePosition> arrayList = new ArrayList<CodePosition>();
        for (NodeSourcePosition nodeSourcePosition2 = nodeSourcePosition; nodeSourcePosition2 != null; nodeSourcePosition2 = nodeSourcePosition2.getCaller()) {
            HostedMethod hostedMethod = (HostedMethod)nodeSourcePosition2.getMethod();
            arrayList.add(new CodePosition(hostedMethod.getWrapped().getId(), nodeSourcePosition2.getBCI()));
        }
        return CallingContext.create(arrayList);
    }

    protected void b(d d2, LoweringTool loweringTool, CallingContextForest.Payload payload, IntSupplier intSupplier, int n2) {
        StructuredGraph structuredGraph = d2.graph();
        int n3 = this.hG().addIfAbsent(a.a(d2.getNodeSourcePosition()), payload, intSupplier);
        OffsetAddressNode offsetAddressNode = this.a(d2, loweringTool, n3, n2);
        this.a(structuredGraph, d2, offsetAddressNode);
    }

    private OffsetAddressNode a(d d2, LoweringTool loweringTool, int n2, int n3) {
        StructuredGraph structuredGraph = d2.graph();
        ValueNode valueNode = this.a(d2, structuredGraph);
        int n4 = this.xd.storage().counterWordSize().byteCount();
        ConstantNode constantNode = (ConstantNode)structuredGraph.unique((Node)ConstantNode.forInt((int)(n3 * n4)));
        j j2 = (j)structuredGraph.unique((Node)new j());
        ConstantNode constantNode2 = (ConstantNode)structuredGraph.unique((Node)ConstantNode.forInt((int)n2));
        com.oracle.svm.enterprise.hosted.profilingframework.nodes.b b2 = (com.oracle.svm.enterprise.hosted.profilingframework.nodes.b)structuredGraph.unique((Node)new com.oracle.svm.enterprise.hosted.profilingframework.nodes.b((ValueNode)j2, (ValueNode)constantNode2, (ValueNode)constantNode));
        ValueNode valueNode2 = (ValueNode)structuredGraph.addOrUnique((Node)AddNode.create((ValueNode)valueNode, (ValueNode)b2, (NodeView)NodeView.DEFAULT));
        OffsetAddressNode offsetAddressNode = (OffsetAddressNode)structuredGraph.addOrUniqueWithInputs((Node)OffsetAddressNode.create((ValueNode)valueNode2));
        j2.lower(loweringTool);
        b2.lower(loweringTool);
        return offsetAddressNode;
    }

    private ValueNode a(d d2, StructuredGraph structuredGraph) {
        ValueNode valueNode = (ValueNode)structuredGraph.unique((Node)((InstrumentationData.OffHeapStorage)this.xd.storage()).profilingMemoryBaseNode());
        AddressNode addressNode = (AddressNode)structuredGraph.addOrUniqueWithInputs((Node)OffsetAddressNode.create((ValueNode)valueNode));
        if (this.e(structuredGraph.method())) {
            FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)structuredGraph.add((Node)new ReadNode(addressNode, InstrumentationData.PROFILING_LOCATION, (Stamp)IntegerStamp.create((int)64), BarrierType.NONE, MemoryOrderMode.PLAIN));
            structuredGraph.addBeforeFixed((FixedNode)d2, fixedWithNextNode);
            return fixedWithNextNode;
        }
        return (ValueNode)structuredGraph.addOrUniqueWithInputs((Node)new FloatingReadNode(addressNode, InstrumentationData.PROFILING_LOCATION, (MemoryKill)structuredGraph.start(), (Stamp)IntegerStamp.create((int)64)));
    }

    protected void b(l l2, LoweringTool loweringTool) {
        try (DebugCloseable debugCloseable = l2.withNodeSourcePosition();){
            ResolvedJavaType[] resolvedJavaTypeArray = l2.hW();
            assert (resolvedJavaTypeArray.length > 0);
            StructuredGraph structuredGraph = l2.graph();
            AbstractBeginNode abstractBeginNode = a.a(loweringTool, structuredGraph, l2, resolvedJavaTypeArray);
            structuredGraph.removeFixed((FixedWithNextNode)abstractBeginNode);
        }
    }

    private static AbstractBeginNode a(LoweringTool loweringTool, StructuredGraph structuredGraph, l l2, ResolvedJavaType[] resolvedJavaTypeArray) {
        ResolvedJavaType resolvedJavaType;
        EndNode[] endNodeArray = new EndNode[resolvedJavaTypeArray.length];
        AbstractBeginNode abstractBeginNode = a.a(resolvedJavaTypeArray, resolvedJavaTypeArray.length - 1, structuredGraph, endNodeArray);
        a.a(abstractBeginNode, loweringTool);
        for (int i2 = resolvedJavaTypeArray.length - 2; i2 >= 0; --i2) {
            resolvedJavaType = resolvedJavaTypeArray[i2];
            EndNode[] endNodeArray2 = a.a(resolvedJavaTypeArray, i2, structuredGraph, endNodeArray);
            LogicNode logicNode = (LogicNode)structuredGraph.unique((Node)InstanceOfNode.create((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)resolvedJavaType), (ValueNode)l2.hZ()));
            abstractBeginNode = BeginNode.begin((FixedNode)((FixedNode)structuredGraph.add((Node)new IfNode(logicNode, (AbstractBeginNode)endNodeArray2, abstractBeginNode, a.a(resolvedJavaTypeArray, i2)))));
            if (logicNode instanceof Lowerable) {
                Lowerable lowerable = (Lowerable)logicNode;
                lowerable.lower(loweringTool);
            }
            a.a((AbstractBeginNode)endNodeArray2, loweringTool);
        }
        FixedNode fixedNode = l2.next();
        l2.setNext((FixedNode)abstractBeginNode);
        if (endNodeArray.length > 1) {
            resolvedJavaType = (MergeNode)structuredGraph.add((Node)new MergeNode());
            for (EndNode endNode : endNodeArray) {
                resolvedJavaType.addForwardEnd(endNode);
            }
            resolvedJavaType.setStateAfter(l2.stateAfter());
            resolvedJavaType.setNext(fixedNode);
        } else {
            endNodeArray[0].replaceAtPredecessor((Node)fixedNode);
        }
        return abstractBeginNode;
    }

    private static void a(AbstractBeginNode abstractBeginNode, LoweringTool loweringTool) {
        e e2 = (e)abstractBeginNode.next();
        e2.lower(loweringTool);
    }

    private static AbstractBeginNode a(ResolvedJavaType[] resolvedJavaTypeArray, int n2, StructuredGraph structuredGraph, EndNode[] endNodeArray) {
        e e2 = (e)structuredGraph.add((Node)new e(resolvedJavaTypeArray, n2));
        EndNode endNode = (EndNode)structuredGraph.add((Node)new EndNode());
        e2.setNext((FixedNode)endNode);
        endNodeArray[n2] = endNode;
        return BeginNode.begin((FixedNode)e2);
    }

    private static ProfileData.BranchProbabilityData a(ResolvedJavaType[] resolvedJavaTypeArray, int n2) {
        return ProfileData.BranchProbabilityData.injected((double)(1.0 / (double)(resolvedJavaTypeArray.length - n2)));
    }

    protected void a(k k2, LoweringTool loweringTool, CallingContextForest.Payload payload) {
        Metadata.Builder builder = b.singleton().hG();
        int n2 = builder.addIfAbsent(a.a(k2.getNodeSourcePosition()), payload, () -> this.xd.reserveUniqueCounterIDSlots(CommonInstrumentationData.ProfilingRuntimeCalls.virtualCallComponentsPerCounter()));
        StructuredGraph structuredGraph = k2.graph();
        ConstantNode constantNode = ConstantNode.forInt((int)n2, (StructuredGraph)structuredGraph);
        a.a(structuredGraph, loweringTool, k2, constantNode);
    }

    private static void a(StructuredGraph structuredGraph, LoweringTool loweringTool, k k2, ConstantNode constantNode) {
        j j2 = (j)structuredGraph.unique((Node)new j());
        ForeignCallNode foreignCallNode = (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)CommonInstrumentationData.PROFILE_VIRTUAL_CALL_RECEIVER_TYPE, new ValueNode[]{k2.hZ(), j2, constantNode}));
        foreignCallNode.setStateAfter(k2.stateAfter());
        structuredGraph.addBeforeFixed((FixedNode)k2, (FixedWithNextNode)foreignCallNode);
        j2.lower(loweringTool);
    }

    static final class com.oracle.svm.enterprise.hosted.profilingframework.instrument.a$a<T extends FixedWithNextNode>
    extends SubstrateTemplates
    implements Snippets {
        private final SnippetTemplate.SnippetInfo xe;

        private com.oracle.svm.enterprise.hosted.profilingframework.instrument.a$a(OptionValues optionValues, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> map) {
            super(optionValues, providers);
            this.xe = this.snippet(providers, com.oracle.svm.enterprise.hosted.profilingframework.instrument.a$a.class, "profileMonitorEnterSnippet", new LocationIdentity[0]);
            map.put(i.class, new a());
        }

        @Snippet(allowMissingProbabilities=true)
        private static void profileMonitorEnterSnippet(Object object) {
            DynamicHub dynamicHub = DynamicHub.fromClass(object.getClass());
            int n2 = dynamicHub.getTypeID();
            CommonInstrumentationData commonInstrumentationData = (CommonInstrumentationData)InstrumentationData.singleton();
            long l2 = 0L;
            long l3 = commonInstrumentationData.readMonitorCount(l2, n2);
            commonInstrumentationData.sideEffectFreeWriteMonitorCount(l2, n2, l3 + 1L);
        }

        private class a
        implements NodeLoweringProvider<i> {
            private a() {
            }

            public void a(i i2, LoweringTool loweringTool) {
                SnippetTemplate.Arguments arguments = new SnippetTemplate.Arguments(a.this.xe, i2.graph().getGuardsStage(), loweringTool.getLoweringStage());
                arguments.add("object", (Object)i2.hY());
                SnippetTemplate snippetTemplate = a.this.template((CoreProviders)loweringTool, (ValueNode)i2, arguments);
                snippetTemplate.setMayRemoveLocation(true);
                snippetTemplate.instantiate(loweringTool.getMetaAccess(), (FixedNode)i2, SnippetTemplate.DEFAULT_REPLACER, arguments);
            }

            public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
                this.a((i)node, loweringTool);
            }
        }
    }
}

