/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profiling.phases;

import com.oracle.svm.enterprise.hosted.profiling.utilities.a;
import com.oracle.svm.enterprise.profiling.kinds.d;
import com.oracle.svm.enterprise.profiling.nodes.c;
import com.oracle.svm.enterprise.profiling.nodes.e;
import com.oracle.svm.enterprise.profiling.nodes.f;
import com.oracle.svm.enterprise.profiling.nodes.g;
import com.oracle.svm.enterprise.profiling.p;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.graph.iterators.FilteredNodeIterable;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.SwitchNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;

public class ProfilingInstrumentationPhase
extends BasePhase<CoreProviders> {
    public static final int wX = 0;
    private final CanonicalizerPhase wY;

    public ProfilingInstrumentationPhase(CanonicalizerPhase canonicalizerPhase) {
        this.wY = canonicalizerPhase;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        ControlSplitNode controlSplitNode;
        Object object3;
        Object object22;
        assert (structuredGraph.trackNodeSourcePosition()) : "Without source positions AOT instrumentation is useless.";
        ProfilingInstrumentationPhase.a(structuredGraph.start());
        EconomicMap<NodeSourcePosition, List<ControlSplitNode>> economicMap = a.j(structuredGraph);
        for (Object object22 : economicMap.getValues()) {
            object3 = object22.iterator();
            while (object3.hasNext()) {
                controlSplitNode = (ControlSplitNode)object3.next();
                ProfilingInstrumentationPhase.b(controlSplitNode);
            }
        }
        FilteredNodeIterable filteredNodeIterable = structuredGraph.getNodes(MethodCallTargetNode.TYPE).filter(node -> ((MethodCallTargetNode)node).invokeKind().isIndirect());
        for (Object object3 : filteredNodeIterable) {
            assert (object3.getNodeSourcePosition() != null);
            if (object3.getNodeSourcePosition() == null) continue;
            ProfilingInstrumentationPhase.a((MethodCallTargetNode)object3);
        }
        object22 = structuredGraph.getNodes(MonitorEnterNode.TYPE);
        object3 = object22.iterator();
        while (object3.hasNext()) {
            controlSplitNode = (MonitorEnterNode)object3.next();
            assert (controlSplitNode.getNodeSourcePosition() != null);
            if (controlSplitNode.getNodeSourcePosition() == null) continue;
            ProfilingInstrumentationPhase.a((MonitorEnterNode)controlSplitNode);
        }
        this.wY.apply(structuredGraph, (Object)coreProviders);
    }

    public static boolean a(ControlSplitNode controlSplitNode) {
        double d2 = 1.0 / (double)controlSplitNode.successors().count();
        for (Node node : controlSplitNode.successors().snapshot()) {
            if (Double.compare(controlSplitNode.probability((AbstractBeginNode)node), d2) == 0) continue;
            return true;
        }
        return false;
    }

    private static void a(StartNode startNode) {
        StructuredGraph structuredGraph = startNode.graph();
        HostedMethod hostedMethod = (HostedMethod)structuredGraph.method();
        NodeSourcePosition nodeSourcePosition = new NodeSourcePosition(null, (ResolvedJavaMethod)hostedMethod, 0);
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition(nodeSourcePosition);){
            Object object = startNode;
            if (p.e((ResolvedJavaMethod)hostedMethod)) {
                c c2 = new c();
                structuredGraph.addAfterFixed((FixedWithNextNode)startNode, (FixedNode)structuredGraph.add((Node)c2));
                c2.setStateAfter(startNode.stateAfter());
                object = c2;
            }
            structuredGraph.addAfterFixed((FixedWithNextNode)object, (FixedNode)structuredGraph.add((Node)new g((ResolvedJavaMethod)hostedMethod, d.zL.iL())));
        }
    }

    private static void b(ControlSplitNode controlSplitNode) {
        if (controlSplitNode.getNodeSourcePosition() == null) {
            return;
        }
        StructuredGraph structuredGraph = controlSplitNode.graph();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)controlSplitNode);){
            controlSplitNode.successors().forEach(node -> ProfilingInstrumentationPhase.a(controlSplitNode, node, structuredGraph));
        }
    }

    private static void a(ControlSplitNode controlSplitNode, Node node, StructuredGraph structuredGraph) {
        NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition();
        if (nodeSourcePosition == null) {
            return;
        }
        com.oracle.svm.enterprise.profiling.nodes.a a2 = new com.oracle.svm.enterprise.profiling.nodes.a(nodeSourcePosition.getBCI(), ProfilingInstrumentationPhase.c(controlSplitNode), ProfilingInstrumentationPhase.d(controlSplitNode), d.zM.iL());
        structuredGraph.addAfterFixed((FixedWithNextNode)node, (FixedNode)structuredGraph.add((Node)a2));
    }

    private static int[] c(ControlSplitNode controlSplitNode) {
        if (controlSplitNode instanceof IfNode) {
            return ProfilingInstrumentationPhase.a((IfNode)controlSplitNode);
        }
        assert (controlSplitNode instanceof SwitchNode);
        return ProfilingInstrumentationPhase.a((SwitchNode)controlSplitNode);
    }

    private static int[] a(IfNode ifNode) {
        int[] nArray = new int[ifNode.successors().count()];
        NodeSourcePosition nodeSourcePosition = ifNode.trueSuccessor().getNodeSourcePosition();
        NodeSourcePosition nodeSourcePosition2 = ifNode.falseSuccessor().getNodeSourcePosition();
        nArray[0] = nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -5;
        nArray[1] = nodeSourcePosition2 != null ? nodeSourcePosition2.getBCI() : -5;
        return nArray;
    }

    private static int[] a(SwitchNode switchNode) {
        List list = switchNode.successors().snapshot();
        int[] nArray = switchNode.getKeySuccessors();
        int[] nArray2 = new int[nArray.length];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!hashSet.contains(nArray[i2])) {
                NodeSourcePosition nodeSourcePosition = ((Node)list.get(nArray[i2])).getNodeSourcePosition();
                nArray2[i2] = nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -5;
                hashSet.add(nArray[i2]);
                continue;
            }
            nArray2[i2] = -5;
        }
        return nArray2;
    }

    private static int[] d(ControlSplitNode controlSplitNode) {
        if (controlSplitNode instanceof IfNode) {
            return ProfilingInstrumentationPhase.hh();
        }
        assert (controlSplitNode instanceof SwitchNode);
        return ProfilingInstrumentationPhase.b((SwitchNode)controlSplitNode);
    }

    private static int[] b(SwitchNode switchNode) {
        return switchNode.getKeySuccessors();
    }

    private static int[] hh() {
        return new int[]{0, 1};
    }

    private static void a(MethodCallTargetNode methodCallTargetNode) {
        StructuredGraph structuredGraph = methodCallTargetNode.graph();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)methodCallTargetNode);){
            Object object;
            ResolvedJavaType[] resolvedJavaTypeArray;
            if (methodCallTargetNode.getTypeProfile() == null) {
                resolvedJavaTypeArray = null;
            } else {
                object = methodCallTargetNode.getTypeProfile().getTypes();
                resolvedJavaTypeArray = new ResolvedJavaType[((JavaTypeProfile.ProfiledType[])object).length];
                for (int i2 = 0; i2 < ((JavaTypeProfile.ProfiledType[])object).length; ++i2) {
                    resolvedJavaTypeArray[i2] = object[i2].getType();
                }
            }
            object = new e(methodCallTargetNode.receiver(), resolvedJavaTypeArray);
            structuredGraph.addBeforeFixed(methodCallTargetNode.invoke().asFixedNode(), (FixedWithNextNode)structuredGraph.add((Node)object));
            object.setStateAfter(GraphUtil.findLastFrameState((FixedNode)((FixedNode)object.predecessor())).duplicateWithVirtualState());
        }
    }

    private static void a(MonitorEnterNode monitorEnterNode) {
        StructuredGraph structuredGraph = monitorEnterNode.graph();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition((Node)monitorEnterNode);){
            f f2 = new f(monitorEnterNode.object());
            structuredGraph.addAfterFixed((FixedWithNextNode)monitorEnterNode, (FixedNode)structuredGraph.add((Node)f2));
            f2.setStateAfter(GraphUtil.findLastFrameState((FixedNode)((FixedNode)f2.predecessor())).duplicateWithVirtualState());
        }
    }
}

