/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.svm.enterprise.hosted.cai.e;
import com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.function.Function;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;

public class BeforeHotCallerCompilationPhase
extends BasePhase<HighTierContext> {
    private final HostedUniverse ur;
    private final PGOProfilesLookup us;
    private final Function<HostedMethod, e.a> ut;

    public BeforeHotCallerCompilationPhase(HostedUniverse hostedUniverse, Function<HostedMethod, e.a> function, PGOProfilesLookup pGOProfilesLookup) {
        this.ur = hostedUniverse;
        this.us = pGOProfilesLookup;
        this.ut = function;
    }

    protected void run(StructuredGraph structuredGraph, HighTierContext highTierContext) {
        assert (structuredGraph.globalProfileProvider().hotCaller()) : "Should not be used on cold compilation units.";
        e.a a2 = this.ut.apply((HostedMethod)structuredGraph.method());
        PGOApplyProfilesPhase.createForBeforeHotCompilationPhase(this.ur, a2, this.us).apply(structuredGraph, highTierContext);
    }
}

