/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features.provider;

import com.oracle.svm.core.BuildDirectoryProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.ml.features.provider.d;
import com.oracle.svm.enterprise.hosted.ml.inferencer.Inferencer;
import com.oracle.svm.enterprise.hosted.ml.models.c;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleFinder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class a
implements InternalFeature {
    private Field sP;
    private Field sQ;
    private Properties sR;
    private static final boolean sS;

    public static boolean fA() {
        return Stream.of(Platform.LINUX_AMD64.class, Platform.LINUX_AARCH64.class, Platform.WINDOWS_AMD64.class).anyMatch(Platform::includedIn) || Stream.of(Platform.DARWIN_AMD64.class, Platform.DARWIN_AARCH64.class).anyMatch(Platform::includedIn) && a.a("macOS", 10, 15);
    }

    private static boolean a(String string, int n2, int n3) {
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.version");
        String[] stringArray = string3.split("\\.");
        int n4 = Integer.parseInt(stringArray[0]);
        int n5 = Integer.parseInt(stringArray[1]);
        return string2.replaceAll("\\s", "").toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)) && (n4 > n2 || n4 == n2 && n5 >= n3);
    }

    private static boolean fB() {
        if (b.MLProfileInference.hasBeenSet()) {
            return (Boolean)b.MLProfileInference.getValue();
        }
        return SubstrateOptions.optimizationLevel().isOneOf(new SubstrateOptions.OptimizationLevel[]{SubstrateOptions.OptimizationLevel.O2, SubstrateOptions.OptimizationLevel.O3});
    }

    public static boolean fC() {
        return ((Boolean)b.MLGraphFeaturesExtraction.getValue() != false || a.fB()) && a.fA();
    }

    public static boolean fD() {
        if (b.MLProfileInferenceUseGNNModel.hasBeenSet()) {
            return (Boolean)b.MLProfileInferenceUseGNNModel.getValue();
        }
        return SubstrateOptions.optimizationLevel().equals((Object)SubstrateOptions.OptimizationLevel.O3);
    }

    public static boolean fE() {
        return (Boolean)b.MLGraphFeaturesExtraction.getValue() != false && a.fA();
    }

    public static boolean fF() {
        return a.fB() && a.fA();
    }

    public static boolean fG() {
        return a.fF() && b.LogMLInference.getValue() != null;
    }

    public static boolean fH() {
        return ImageSingletons.contains(com.oracle.svm.enterprise.hosted.ml.models.a.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (a.fF() && !sS) {
            throw UserError.abort((String)("Machine-learning-based profile inference is enabled but the required java.logging module is unavailable. ML profile inference can be disabled with " + SubstrateOptionsParser.commandArgument(b.MLProfileInference, (String)"-") + " or by using " + SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)"1")), (Object[])new Object[0]);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        if (a.fF()) {
            try {
                Class clazz = ReflectionUtil.lookupClass((boolean)false, (String)"java.util.logging.LogManager");
                this.sP = ReflectionUtil.lookupField((Class)clazz, (String)"manager");
                this.sQ = ReflectionUtil.lookupField((Class)clazz, (String)"props");
                this.sR = (Properties)this.sQ.get(this.sP.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw VMError.shouldNotReachHere((String)"Can not access the java log manager.\n");
            }
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        if (a.fC()) {
            ImageSingletons.add(d.class, (Object)((Object)new d()));
        }
        if (a.fF()) {
            try {
                Inferencer inferencer = a.fI();
                com.oracle.svm.enterprise.hosted.ml.models.a a2 = a.fD() ? com.oracle.svm.enterprise.hosted.ml.models.b.b(a.J("gnn"), inferencer) : c.c(a.J("xgboost"), inferencer);
                ImageSingletons.add(com.oracle.svm.enterprise.hosted.ml.models.a.class, (Object)((Object)a2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                a.a(fileNotFoundException, "Invalid Configuration File", true);
            }
            catch (IOException iOException) {
                a.a(iOException, "Invalid Inference Configuration File IO", true);
            }
            catch (JsonParserException jsonParserException) {
                a.a(jsonParserException, "Invalid JSON Configuration", true);
            }
            catch (Inferencer.InferenceException inferenceException) {
                a.a(inferenceException, "Invalid Inference", true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                a.a(unsatisfiedLinkError, "Missing Inference Library", true);
            }
            catch (Exception exception) {
                a.a(exception, "General Inference Exception", true);
            }
            try {
                this.sQ.set(this.sP.get(null), this.sR);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw VMError.shouldNotReachHere((String)"Can not access the java log manager.\n");
            }
        }
        if (a.fG()) {
            com.oracle.svm.enterprise.hosted.ml.logging.a.fL();
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        if (a.fH()) {
            try {
                ((com.oracle.svm.enterprise.hosted.ml.models.a)((Object)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.ml.models.a.class))).q();
            }
            catch (Exception exception) {
                a.a(exception, "Can not close the ONNX ML model inference session", true);
            }
        }
        if (a.fG()) {
            com.oracle.svm.enterprise.hosted.ml.logging.a.c(Paths.get((String)b.LogMLInference.getValue(), new String[0]).toAbsolutePath());
            com.oracle.svm.enterprise.hosted.ml.logging.a.fM();
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess afterHeapLayoutAccess) {
        if (a.fC()) {
            ((d)((Object)ImageSingletons.lookup(d.class))).v();
        }
    }

    public static Inferencer fI() throws Inferencer.InferenceException {
        try {
            return (Inferencer)a.sT.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {
            throw new Inferencer.InferenceException("Can not instantiate inference engine for profile inference.", exception);
        }
    }

    public static void a(Throwable throwable, String string, boolean bl2) {
        String string2 = "ML Profile Inference - " + string + ": " + String.valueOf(throwable);
        if (Assertions.assertionsEnabled()) {
            throw VMError.shouldNotReachHere((String)string2);
        }
        if (bl2) {
            LogUtils.warning((String)string2);
        }
    }

    private static Path J(String string) {
        return BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("profile_inference").resolve("model").resolve(string);
    }

    static {
        Optional<Module> optional = ModuleLayer.boot().findModule("java.logging");
        if (optional.isPresent()) {
            a.class.getModule().addReads(optional.get());
        }
        sS = optional.isPresent();
    }

    public static class b {
        public static final HostedOptionKey<Boolean> MLProfileInference = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> MLProfileInferenceUseGNNModel = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> MLGraphFeaturesExtraction = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                super.onValueUpdate(economicMap, (Object)bl2, (Object)bl3);
                if (bl3.booleanValue()) {
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                    MLProfileInference.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<Boolean> ClampMLInferredProfiles = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> MLProfileInferenceGuards = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Double> GuardMinLoopProbability = new HostedOptionKey((Object)0.2);
        public static final HostedOptionKey<Double> GuardMaxCondExitProbability = new HostedOptionKey((Object)0.8);
        public static final HostedOptionKey<Double> GuardMinCondEstimatedAssembly = new HostedOptionKey((Object)50.0);
        public static final HostedOptionKey<String> LogMLInference = new HostedOptionKey<String>(null){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, String string, String string2) {
                super.onValueUpdate(economicMap, (Object)string, (Object)string2);
                if (string2 != null) {
                    LogUtils.warning((String)"Building the image in ML logging mode involves collecting ML-inferred and dynamically gathered profiles, allowing the ML model to overwrite dynamically collected profiles. This is the debug flag only and it should not be used in production.");
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (String)object, (String)object2);
            }
        };
    }

    static class a {
        static Class<?> sT = a.fJ();

        a() {
        }

        private static Class<?> fJ() {
            Path path = BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("profile_inference").resolve("onnx");
            Path path2 = path.resolve("native");
            System.setProperty("onnxruntime.native.path", String.valueOf(path2));
            String string = "com.oracle.svm.svm_enterprise_onnx_runtime";
            Path path3 = path.resolve("jar").resolve("svm-enterprise-onnx-runtime.jar");
            try {
                ClassLoader classLoader;
                if (ModuleSupport.modulePathBuild) {
                    ModuleFinder moduleFinder = ModuleFinder.of(path3);
                    Configuration configuration = ModuleLayer.boot().configuration().resolve(moduleFinder, ModuleFinder.of(new Path[0]), Collections.singleton(string));
                    ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, List.of(ModuleLayer.boot()), Inferencer.class.getClassLoader());
                    ModuleLayer moduleLayer = controller.layer();
                    Module module = moduleLayer.findModule(string).orElseThrow();
                    if (JavaVersionUtil.JAVA_SPEC > 21) {
                        Method method = ReflectionUtil.lookupMethod(ModuleLayer.Controller.class, (String)"enableNativeAccess", (Class[])new Class[]{Module.class});
                        method.invoke((Object)controller, module);
                    }
                    classLoader = module.getClassLoader();
                    ModuleSupport.accessModule((ModuleSupport.Access)ModuleSupport.Access.EXPORT, (Module)module, (Module)a.class.getModule(), (String)"com.oracle.svm.enterprise.hosted.ml.inferencer");
                } else {
                    classLoader = new URLClassLoader(new URL[]{path3.toUri().toURL()});
                }
                return ReflectionUtil.lookupClass((boolean)false, (String)"com.oracle.svm.enterprise.hosted.onnx.ONNXInferencer", (ClassLoader)classLoader);
            }
            catch (ReflectiveOperationException | FindException | MalformedURLException | NoSuchElementException exception) {
                a.a(exception, "Cannot load module" + string + " from: " + String.valueOf(path3), false);
                return null;
            }
        }
    }
}

