/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.hybrid;

import com.oracle.svm.enterprise.core.hybrid.n;
import com.oracle.svm.enterprise.hosted.hybrid.a;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.Phase;

public class OrderStringStorePhase
extends Phase {
    public float codeSizeIncrease() {
        return 1.0f;
    }

    protected void run(StructuredGraph structuredGraph) {
        assert (n.useStringInlining());
        for (StoreFieldNode storeFieldNode : structuredGraph.getNodes().filter(StoreFieldNode.class)) {
            if (!a.fh().a(storeFieldNode.field())) continue;
            OrderStringStorePhase.a(storeFieldNode, structuredGraph);
        }
    }

    private static void a(StoreFieldNode storeFieldNode, StructuredGraph structuredGraph) {
        Node node = storeFieldNode.predecessor();
        ValueNode valueNode = GraphUtil.originalValue((ValueNode)storeFieldNode.object(), (boolean)false);
        while (node != null && node != valueNode) {
            StoreFieldNode storeFieldNode2;
            ValueNode valueNode2;
            LoopBeginNode loopBeginNode;
            if (node instanceof LoopBeginNode) {
                loopBeginNode = (LoopBeginNode)node;
                assert (loopBeginNode.isSimpleLoop());
                assert (loopBeginNode.forwardEndCount() == 1) : "AbstractMergeNodes with multiple endpoints not supported: " + String.valueOf(loopBeginNode);
                node = loopBeginNode.forwardEndAt(0);
                continue;
            }
            loopBeginNode = node.predecessor();
            if (node instanceof StoreFieldNode && (valueNode2 = GraphUtil.originalValue((ValueNode)(storeFieldNode2 = (StoreFieldNode)node).object(), (boolean)false)) == valueNode) {
                assert (a.fh().b(storeFieldNode2.field().getDeclaringClass()));
                assert (!a.fh().a(storeFieldNode2.field())) : "Expected only one store to String.value in the same control-flow branch, but found two";
                StoreFieldNode storeFieldNode3 = (StoreFieldNode)structuredGraph.add((Node)new StoreFieldNode(storeFieldNode2.object(), storeFieldNode2.field(), storeFieldNode2.value(), storeFieldNode2.stateAfter(), storeFieldNode2.getMemoryOrder()));
                storeFieldNode2.replaceAtUsages((Node)storeFieldNode3);
                structuredGraph.removeFixed((FixedWithNextNode)storeFieldNode2);
                structuredGraph.addAfterFixed((FixedWithNextNode)storeFieldNode, (FixedNode)storeFieldNode3);
            }
            node = loopBeginNode;
        }
    }
}

