/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.bc;
import com.oracle.svm.enterprise.gc.g1.b;
import com.oracle.svm.enterprise.gc.g1.e;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.CodeUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class i
extends ObjectHeader {
    private final int nk;
    private final int nl;
    private final int nm;
    private final int nn;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public i() {
        assert (ReferenceAccess.singleton().haveCompressedReferences()) : "G1 requires compressed references";
        this.nk = CodeUtil.log2((int)ConfigurationValues.getObjectLayout().getAlignment());
        if (bc.useCompressedReferences()) {
            this.nl = 5;
            this.nm = this.nl - this.nk;
            UnsignedWord unsignedWord = WordFactory.unsigned((int)1);
            UnsignedWord unsignedWord2 = WordFactory.unsigned((int)30);
            this.nn = NumUtil.safeToInt((long)unsignedWord.or(unsignedWord2).rawValue());
            assert (b.cY() == Long.bitCount(unsignedWord2.rawValue())) : unsignedWord2.rawValue();
        } else {
            this.nl = 0;
            this.nm = 0;
            this.nn = 0;
        }
    }

    @Fold
    public static i get() {
        return (i)e.get().getObjectHeader();
    }

    public int getReservedBitsMask() {
        return this.nn;
    }

    public Word encodeAsTLABObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Word a(DynamicHub dynamicHub) {
        Word word = Word.objectToUntrackedPointer((Object)dynamicHub).subtract((UnsignedWord)KnownIntrinsics.heapBase());
        i.a(this.d((UnsignedWord)word), "must be in hub-specific address space");
        Word word2 = word.shiftLeft(this.nm);
        i.a(word2.and(this.nn).isNull(), "all reserved bits must be zero");
        return word2;
    }

    public long encodeAsImageHeapObjectHeader(ImageHeapObject imageHeapObject, long l2) {
        assert (this.d(WordFactory.unsigned((long)l2))) : l2;
        long l3 = l2 << this.nm;
        assert ((l3 & (long)this.nn) == 0L) : "all reserved bits must be zero";
        return l3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer extractPotentialDynamicHubFromHeader(Word word) {
        if (bc.useCompressedReferences()) {
            Word word2 = word.unsignedShiftRight(this.nl);
            UnsignedWord unsignedWord = word2.shiftLeft(this.nk);
            return KnownIntrinsics.heapBase().add(unsignedWord);
        }
        assert (this.nl == 0);
        return word.add((UnsignedWord)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsUnmanagedObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
    protected void initializeObjectHeader(Pointer pointer, Word word, boolean bl2, ObjectHeader.MemWriter memWriter) {
        memWriter.writeWord(pointer, i.getHubOffset(), word);
        if (bc.useCompressedReferences()) {
            i.a(word.and((Word)WordFactory.unsigned((long)-4294967296L)).isNull(), "the whole 32-bit mark word must be 0");
        } else {
            memWriter.writeWord(pointer, i.getMarkWordOffset(), (Word)WordFactory.zero());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOptionalIdentityHashField(Word word) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have the identity hash code field in the object header");
            return false;
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasIdentityHashFromAddress(Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have the identity hash code field in the object header");
        return false;
    }

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.", callerMustBe=true)
    public void setIdentityHashFromAddress(Pointer pointer, Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"identity hash codes are never computed from addresses");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(boolean bl2, String string) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)bl2, (String)string);
        } else assert (bl2) : string;
    }

    @Fold
    static int getMarkWordOffset() {
        return i.getHubOffset() + i.getReferenceSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean d(UnsignedWord unsignedWord) {
        UnsignedWord unsignedWord2 = this.dp();
        return unsignedWord2.aboveThan(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private UnsignedWord dp() {
        if (!bc.useCompressedReferences() && this.nm == 0) {
            return UnsignedUtils.MAX_VALUE;
        }
        int n2 = ConfigurationValues.getObjectLayout().getReferenceSize();
        return WordFactory.unsigned((long)(1L << n2 * 8 - this.nm));
    }
}

