/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.posix.mpk;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import com.oracle.svm.core.posix.PosixVirtualMemoryProvider;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import jdk.graal.compiler.core.amd64.WriteProtectionKeyRegisterNode;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX_AMD64.class})
class b
extends PosixVirtualMemoryProvider
implements MemoryProtectionProvider {
    private static final int hE = -8;
    private static final UnsignedWord hF = WordFactory.unsigned((int)0x55555554);
    private static final int hG = 1;
    private static final int hH = 2;
    private static final int hI = 4;
    static final int hJ = -1;
    private Isolates.ProtectionDomain hK;
    private static final CGlobalData<CCharPointer> hL = CGlobalDataFactory.createCString((String)"pkey_mprotect");
    private static final CGlobalData<CCharPointer> hM = CGlobalDataFactory.createCString((String)"pkey_alloc");
    private static final CGlobalData<CCharPointer> hN = CGlobalDataFactory.createCString((String)"pkey_free");

    b() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static d bD() {
        return (d)Dlfcn.dlsym((PointerBase)Dlfcn.RTLD_DEFAULT(), (CCharPointer)((CCharPointer)hL.get()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static b bE() {
        return (b)Dlfcn.dlsym((PointerBase)Dlfcn.RTLD_DEFAULT(), (CCharPointer)((CCharPointer)hM.get()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static c bF() {
        return (c)Dlfcn.dlsym((PointerBase)Dlfcn.RTLD_DEFAULT(), (CCharPointer)((CCharPointer)hN.get()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int protect(PointerBase pointerBase, UnsignedWord unsignedWord, int n2) {
        int n3 = b.bH().readInt(0);
        if (n3 != 0) {
            d d2 = b.bD();
            if (d2.isNull()) {
                return -1;
            }
            return d2.a(pointerBase, unsignedWord, b.accessAsProt((int)n2), n3);
        }
        return Mman.NoTransitions.mprotect((PointerBase)pointerBase, (UnsignedWord)unsignedWord, (int)b.accessAsProt((int)n2));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer commit(PointerBase pointerBase, UnsignedWord unsignedWord, int n2) {
        Pointer pointer = super.commit(pointerBase, unsignedWord, n2);
        if (pointer.isNonNull() && this.protect((PointerBase)pointer, unsignedWord, n2) != 0) {
            Mman.NoTransitions.munmap((PointerBase)pointer, (UnsignedWord)unsignedWord);
            return (Pointer)WordFactory.nullPointer();
        }
        return pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer mapFile(PointerBase pointerBase, UnsignedWord unsignedWord, WordBase wordBase, UnsignedWord unsignedWord2, int n2) {
        Pointer pointer = super.mapFile(pointerBase, unsignedWord, wordBase, unsignedWord2, n2);
        if (pointer.isNonNull() && this.protect((PointerBase)pointer, unsignedWord, n2) != 0) {
            Mman.NoTransitions.munmap((PointerBase)pointer, (UnsignedWord)unsignedWord);
            return (Pointer)WordFactory.nullPointer();
        }
        return pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int bG() {
        b b2 = b.bE();
        if (b2.isNull()) {
            return -1;
        }
        return b2.b((UnsignedWord)WordFactory.zero(), (UnsignedWord)WordFactory.zero());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer bH() {
        return KnownIntrinsics.heapBase().add(-8);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void u(int n2) {
        b.bH().writeInt(0, n2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void bI() {
        c c2;
        int n2 = b.bH().readInt(0);
        if (n2 != 0 && (c2 = b.bF()).isNonNull()) {
            c2.v(n2);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void unlockCurrentIsolate() {
        int n2 = b.bH().readInt(0);
        if (n2 != 0) {
            UnsignedWord unsignedWord = WordFactory.unsigned((int)3).shiftLeft(2 * n2).not();
            WriteProtectionKeyRegisterNode.writeProtectionKeyRegister((WordBase)hF.and(unsignedWord));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void handleSegfault(PointerBase pointerBase) {
        Signal.siginfo_t siginfo_t2 = (Signal.siginfo_t)pointerBase;
        if (siginfo_t2.si_code() == 4) {
            WriteProtectionKeyRegisterNode.writeProtectionKeyRegister((WordBase)WordFactory.zero());
        }
    }

    public void printSignalInfo(PointerBase pointerBase) {
        Signal.siginfo_t siginfo_t2 = (Signal.siginfo_t)pointerBase;
        if (siginfo_t2.si_code() != 4) {
            return;
        }
        Log log = Log.log();
        log.newline();
        log.string("Protection key access violation at memory address ").hex(siginfo_t2.si_addr().rawValue());
        log.newline();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    PointerBase a(PointerBase pointerBase, UnsignedWord unsignedWord, int n2) {
        return super.commit(pointerBase, unsignedWord, n2);
    }

    public Isolates.ProtectionDomain getProtectionDomain() {
        if (this.hK == null) {
            int n2 = b.bH().readInt(0);
            this.hK = n2 != 0 ? new a(n2) : Isolates.ProtectionDomain.NO_DOMAIN;
        }
        return this.hK;
    }

    public int asProtectionKey(Isolates.ProtectionDomain protectionDomain) throws MemoryProtectionProvider.UnsupportedDomainException {
        if (Isolates.ProtectionDomain.NO_DOMAIN.equals((Object)protectionDomain)) {
            return 0;
        }
        if (Isolates.ProtectionDomain.NEW_DOMAIN.equals((Object)protectionDomain)) {
            return -1;
        }
        if (protectionDomain instanceof a) {
            return ((a)protectionDomain).hO;
        }
        throw new MemoryProtectionProvider.UnsupportedDomainException();
    }

    static interface d
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public int a(PointerBase var1, UnsignedWord var2, int var3, int var4);
    }

    static interface b
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public int b(UnsignedWord var1, UnsignedWord var2);
    }

    static interface c
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public int v(int var1);
    }

    private static final class a
    implements Isolates.ProtectionDomain {
        final int hO;

        a(int n2) {
            this.hO = n2;
        }

        public String toString() {
            return "Protection Domain with Linux memory protection key " + String.valueOf(this.hO);
        }
    }
}

