/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.copying;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.cpufeature.RuntimeCPUFeatureCheck;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.copying.RawMemCopyNode;
import com.oracle.svm.graal.RuntimeCPUFeatureRegion;
import java.util.ArrayList;
import java.util.EnumMap;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyLookup;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

class s
implements ArrayCopyLookup {
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] gm;
    static final EnumMap<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor>[] gn;

    s() {
    }

    private static SnippetRuntime.SubstrateForeignCallDescriptor a(String string, JavaKind javaKind) {
        LocationIdentity locationIdentity = NamedLocationIdentity.getArrayLocation((JavaKind)javaKind);
        return SnippetRuntime.findForeignCall(s.class, (String)string, (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{locationIdentity});
    }

    public ForeignCallDescriptor lookupArraycopyDescriptor(JavaKind javaKind, boolean bl2, boolean bl3, boolean bl4, LocationIdentity locationIdentity) {
        if (!javaKind.isPrimitive() || bl4 || !locationIdentity.equals(NamedLocationIdentity.getArrayLocation((JavaKind)javaKind))) {
            throw VMError.unsupportedFeature((String)("Fast ArrayCopy on " + String.valueOf(javaKind) + ", uninit " + bl4 + ", killing " + String.valueOf(locationIdentity) + " not supported yet."));
        }
        return (ForeignCallDescriptor)gn[bl3 ? 1 : 0].get(javaKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void booleanDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Boolean, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Boolean, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void booleanConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Boolean, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Boolean, false, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void byteDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Byte, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Byte, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void byteConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Byte, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Byte, false, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void shortDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Short, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Short, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void shortConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Short, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Short, false, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void charDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Char, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Char, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void charConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Char, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Char, false, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void intDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Int, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Int, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void intConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Int, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Int, false, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void floatDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Float, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Float, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void floatConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Float, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Float, false, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void longDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Long, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Long, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void longConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Long, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Long, false, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void doubleDisjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Double, true, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Double, true, word, word2, word3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @Uninterruptible(reason="Raw memory reads and writes.")
    private static void doubleConjointArraycopy(Word word, Word word2, Word word3) {
        if (RuntimeCPUFeatureCheck.isSupported((Enum)AMD64.CPUFeature.AVX)) {
            RuntimeCPUFeatureRegion runtimeCPUFeatureRegion = RuntimeCPUFeatureRegion.enter((Enum)AMD64.CPUFeature.AVX);
            try {
                RawMemCopyNode.copyRawMemory(JavaKind.Double, false, word, word2, word3, AMD64.CPUFeature.AVX);
            }
            finally {
                runtimeCPUFeatureRegion.leave();
            }
        } else {
            RawMemCopyNode.copyRawMemory(JavaKind.Double, false, word, word2, word3);
        }
    }

    static {
        gn = new EnumMap[2];
        EnumMap<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor> enumMap = new EnumMap<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor>(JavaKind.class);
        EnumMap<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor> enumMap2 = new EnumMap<JavaKind, SnippetRuntime.SubstrateForeignCallDescriptor>(JavaKind.class);
        for (JavaKind javaKind : JavaKind.values()) {
            if (!javaKind.isPrimitive() || javaKind == JavaKind.Void) continue;
            SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor = s.a(javaKind.getJavaName() + "ConjointArraycopy", javaKind);
            SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor2 = s.a(javaKind.getJavaName() + "DisjointArraycopy", javaKind);
            enumMap2.put(javaKind, substrateForeignCallDescriptor);
            enumMap.put(javaKind, substrateForeignCallDescriptor2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(enumMap2.values());
        arrayList.addAll(enumMap.values());
        gm = arrayList.toArray(new SnippetRuntime.SubstrateForeignCallDescriptor[arrayList.size()]);
        s.gn[0] = enumMap2;
        s.gn[1] = enumMap;
    }
}

